/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.queries.context;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.QueryHint;
import org.vitrivr.cottontail.core.queries.binding.BindingContext;
import org.vitrivr.cottontail.core.queries.nodes.traits.OrderTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.TraitType;
import org.vitrivr.cottontail.core.queries.planning.cost.CostPolicy;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.execution.operators.basics.Operator;
import org.vitrivr.cottontail.dbms.execution.transactions.Transaction;
import org.vitrivr.cottontail.dbms.queries.binding.DefaultBindingContext;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.queries.operators.OperatorNode;
import org.vitrivr.cottontail.dbms.queries.planning.CottontailQueryPlanner;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001;B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001cH\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020)H\u0016J\b\u00104\u001a\u000202H\u0016J\f\u00105\u001a\u00060\u0017j\u0002`\u0018H\u0016J\u0010\u00103\u001a\u0002022\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u0001H\u0016J\b\u00109\u001a\u00020:H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR*\u0010 \u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030#\u0012\u0004\u0012\u00020$0\"0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R \u0010'\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030#\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\"\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u001b\u001a\u0004\u0018\u00010)@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006<"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/context/DefaultQueryContext;", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "queryId", "", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "txn", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "hints", "", "Lorg/vitrivr/cottontail/core/queries/QueryHint;", "(Ljava/lang/String;Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;Ljava/util/Set;)V", "bindings", "Lorg/vitrivr/cottontail/core/queries/binding/BindingContext;", "getBindings", "()Lorg/vitrivr/cottontail/core/queries/binding/BindingContext;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "costPolicy", "Lorg/vitrivr/cottontail/core/queries/planning/cost/CostPolicy;", "getCostPolicy", "()Lorg/vitrivr/cottontail/core/queries/planning/cost/CostPolicy;", "groupIdCounter", "", "Lorg/vitrivr/cottontail/core/queries/GroupId;", "getHints", "()Ljava/util/Set;", "<set-?>", "Lorg/vitrivr/cottontail/dbms/queries/operators/OperatorNode$Logical;", "logical", "getLogical", "()Lorg/vitrivr/cottontail/dbms/queries/operators/OperatorNode$Logical;", "order", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;", "getOrder", "()Ljava/util/List;", "output", "getOutput", "Lorg/vitrivr/cottontail/dbms/queries/operators/OperatorNode$Physical;", "physical", "getPhysical", "()Lorg/vitrivr/cottontail/dbms/queries/operators/OperatorNode$Physical;", "getQueryId", "()Ljava/lang/String;", "getTxn", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "assign", "", "plan", "implement", "nextGroupId", "planner", "Lorg/vitrivr/cottontail/dbms/queries/planning/CottontailQueryPlanner;", "split", "toOperatorTree", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "Subcontext", "cottontaildb-dbms"})
public final class DefaultQueryContext
implements QueryContext {
    @NotNull
    private final String queryId;
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final Transaction txn;
    @NotNull
    private final Set<QueryHint> hints;
    @NotNull
    private final BindingContext bindings;
    @Nullable
    private OperatorNode.Logical logical;
    @Nullable
    private OperatorNode.Physical physical;
    @NotNull
    private final CostPolicy costPolicy;
    private volatile int groupIdCounter;

    public DefaultQueryContext(@NotNull String queryId, @NotNull Catalogue catalogue, @NotNull Transaction txn, @NotNull Set<? extends QueryHint> hints) {
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Intrinsics.checkNotNullParameter(hints, (String)"hints");
        this.queryId = queryId;
        this.catalogue = catalogue;
        this.txn = txn;
        this.hints = hints;
        this.bindings = new DefaultBindingContext();
        QueryHint.CostPolicy costPolicy = (QueryHint.CostPolicy)CollectionsKt.singleOrNull((List)CollectionsKt.filterIsInstance((Iterable)this.getHints(), QueryHint.CostPolicy.class));
        this.costPolicy = costPolicy != null ? (CostPolicy)costPolicy : (CostPolicy)this.getCatalogue().getConfig().getCost();
    }

    public /* synthetic */ DefaultQueryContext(String string, Catalogue catalogue, Transaction transaction, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        this(string, catalogue, transaction, set);
    }

    @Override
    @NotNull
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public Transaction getTxn() {
        return this.txn;
    }

    @Override
    @NotNull
    public Set<QueryHint> getHints() {
        return this.hints;
    }

    @Override
    @NotNull
    public BindingContext getBindings() {
        return this.bindings;
    }

    @Override
    @Nullable
    public OperatorNode.Logical getLogical() {
        return this.logical;
    }

    @Override
    @Nullable
    public OperatorNode.Physical getPhysical() {
        return this.physical;
    }

    @Override
    @Nullable
    public List<ColumnDef<?>> getOutput() {
        OperatorNode.Logical logical = this.getLogical();
        return logical != null ? logical.getColumns() : null;
    }

    @Override
    @NotNull
    public List<Pair<ColumnDef<?>, SortOrder>> getOrder() {
        Object object = this.getLogical();
        if (object == null || (object = (OrderTrait)((OperatorNode)object).get((TraitType)OrderTrait.Companion)) == null || (object = object.getOrder()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    @NotNull
    public CostPolicy getCostPolicy() {
        return this.costPolicy;
    }

    @Override
    public int nextGroupId() {
        int n = this.groupIdCounter;
        this.groupIdCounter = n + 1;
        return n;
    }

    @Override
    public void assign(@NotNull OperatorNode.Logical plan) {
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        this.logical = plan;
        this.physical = null;
    }

    @Override
    public void assign(@NotNull OperatorNode.Physical plan) {
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        this.logical = null;
        this.physical = plan;
    }

    @Override
    public void plan(@NotNull CottontailQueryPlanner planner) {
        Intrinsics.checkNotNullParameter((Object)planner, (String)"planner");
        this.physical = CottontailQueryPlanner.planAndSelect$default(planner, this, false, false, 6, null);
    }

    @Override
    public void implement() {
        OperatorNode.Logical logical = this.getLogical();
        this.physical = logical != null ? logical.implement() : null;
    }

    @Override
    @NotNull
    public QueryContext split() {
        return new Subcontext();
    }

    @Override
    @NotNull
    public Operator toOperatorTree() {
        OperatorNode.Physical partitioned;
        int availableWorkers;
        OperatorNode.Physical local = this.getPhysical();
        if (!(local != null)) {
            boolean $i$a$-check-DefaultQueryContext$toOperatorTree$22 = false;
            IllegalStateException $i$a$-check-DefaultQueryContext$toOperatorTree$22 = new IllegalStateException("Cannot generate an operator tree without a valid, physical node expression tree.");
            throw new IllegalStateException(((Object)$i$a$-check-DefaultQueryContext$toOperatorTree$22).toString());
        }
        if (!this.getHints().contains(QueryHint.NoParallel.INSTANCE) && (availableWorkers = this.getTxn().getAvailableIntraQueryWorkers()) > 1 && (partitioned = local.tryPartition(this.getCostPolicy(), availableWorkers)) != null) {
            return partitioned.toOperator(this);
        }
        return local.toOperator(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0015H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\"H\u0016J\b\u00100\u001a\u00020.H\u0016J\f\u00101\u001a\u000602j\u0002`3H\u0016J\u0010\u0010/\u001a\u00020.2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u0001H\u0016J\b\u00107\u001a\u000208H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0016\u0010!\u001a\u0004\u0018\u00010\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00069"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/context/DefaultQueryContext$Subcontext;", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/queries/context/DefaultQueryContext;)V", "bindings", "Lorg/vitrivr/cottontail/core/queries/binding/BindingContext;", "getBindings", "()Lorg/vitrivr/cottontail/core/queries/binding/BindingContext;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "costPolicy", "Lorg/vitrivr/cottontail/core/queries/planning/cost/CostPolicy;", "getCostPolicy", "()Lorg/vitrivr/cottontail/core/queries/planning/cost/CostPolicy;", "hints", "", "Lorg/vitrivr/cottontail/core/queries/QueryHint;", "getHints", "()Ljava/util/Set;", "logical", "Lorg/vitrivr/cottontail/dbms/queries/operators/OperatorNode$Logical;", "getLogical", "()Lorg/vitrivr/cottontail/dbms/queries/operators/OperatorNode$Logical;", "order", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;", "getOrder", "()Ljava/util/List;", "output", "getOutput", "physical", "Lorg/vitrivr/cottontail/dbms/queries/operators/OperatorNode$Physical;", "getPhysical", "()Lorg/vitrivr/cottontail/dbms/queries/operators/OperatorNode$Physical;", "queryId", "", "getQueryId", "()Ljava/lang/String;", "txn", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "getTxn", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "assign", "", "plan", "implement", "nextGroupId", "", "Lorg/vitrivr/cottontail/core/queries/GroupId;", "planner", "Lorg/vitrivr/cottontail/dbms/queries/planning/CottontailQueryPlanner;", "split", "toOperatorTree", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "cottontaildb-dbms"})
    private final class Subcontext
    implements QueryContext {
        @NotNull
        private final BindingContext bindings;

        public Subcontext() {
            this.bindings = DefaultQueryContext.this.getBindings().copy();
        }

        @Override
        @NotNull
        public BindingContext getBindings() {
            return this.bindings;
        }

        @Override
        @NotNull
        public String getQueryId() {
            return DefaultQueryContext.this.getQueryId();
        }

        @Override
        @NotNull
        public Catalogue getCatalogue() {
            return DefaultQueryContext.this.getCatalogue();
        }

        @Override
        @NotNull
        public Transaction getTxn() {
            return DefaultQueryContext.this.getTxn();
        }

        @Override
        @NotNull
        public Set<QueryHint> getHints() {
            return DefaultQueryContext.this.getHints();
        }

        @Override
        @NotNull
        public CostPolicy getCostPolicy() {
            return DefaultQueryContext.this.getCostPolicy();
        }

        @Override
        @Nullable
        public OperatorNode.Logical getLogical() {
            return DefaultQueryContext.this.getLogical();
        }

        @Override
        @Nullable
        public OperatorNode.Physical getPhysical() {
            return DefaultQueryContext.this.getPhysical();
        }

        @Override
        @Nullable
        public List<ColumnDef<?>> getOutput() {
            return DefaultQueryContext.this.getOutput();
        }

        @Override
        @NotNull
        public List<Pair<ColumnDef<?>, SortOrder>> getOrder() {
            return DefaultQueryContext.this.getOrder();
        }

        @Override
        public int nextGroupId() {
            return DefaultQueryContext.this.nextGroupId();
        }

        @Override
        public void assign(@NotNull OperatorNode.Logical plan) {
            Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
            DefaultQueryContext.this.assign(plan);
        }

        @Override
        public void assign(@NotNull OperatorNode.Physical plan) {
            Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
            DefaultQueryContext.this.assign(plan);
        }

        @Override
        public void plan(@NotNull CottontailQueryPlanner planner) {
            Intrinsics.checkNotNullParameter((Object)planner, (String)"planner");
            DefaultQueryContext.this.plan(planner);
        }

        @Override
        public void implement() {
            DefaultQueryContext.this.implement();
        }

        @Override
        @NotNull
        public QueryContext split() {
            return DefaultQueryContext.this.split();
        }

        @Override
        @NotNull
        public Operator toOperatorTree() {
            return DefaultQueryContext.this.toOperatorTree();
        }
    }
}

