/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.catalogue.entries.ColumnCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.EntityCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.catalogue.entries.SequenceCatalogueEntries;
import org.vitrivr.cottontail.dbms.catalogue.entries.StatisticsCatalogueEntry;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "parent", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "(Lorg/vitrivr/cottontail/core/database/Name$SchemaName;Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;)V", "catalogue", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "closed", "", "getClosed", "()Z", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "getParent", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema$Tx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Tx", "cottontaildb-dbms"})
public final class DefaultSchema
implements Schema {
    @NotNull
    private final Name.SchemaName name;
    @NotNull
    private final DefaultCatalogue parent;
    @NotNull
    private final DefaultCatalogue catalogue;

    public DefaultSchema(@NotNull Name.SchemaName name, @NotNull DefaultCatalogue parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        this.catalogue = this.getParent();
    }

    @Override
    @NotNull
    public Name.SchemaName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DefaultCatalogue getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V3_0;
    }

    @Override
    public boolean getClosed() {
        return this.getParent().getClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J1\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013\"\u0006\u0012\u0002\b\u00030\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "cleanup", "", "createEntity", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;[Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/dbms/entity/Entity;", "dropEntity", "entityForName", "listEntities", "", "truncateEntity", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements SchemaTx {
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            if (this.getDbo().getClosed()) {
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), this.getDbo());
            }
            this.closeStamp = this.getDbo().getCatalogue().getCloseLock$cottontaildb_dbms().readLock();
        }

        @Override
        @NotNull
        public DefaultSchema getDbo() {
            return DefaultSchema.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Name.EntityName> listEntities() {
            List list;
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = EntityCatalogueEntry.Companion.store$cottontaildb_dbms(defaultSchema.getCatalogue(), this.getContext().getXodusTx());
                List list2 = new ArrayList();
                Cursor cursor2 = store.openCursor(this.getContext().getXodusTx());
                ByteIterable ret = cursor2.getSearchKeyRange((ByteIterable)NameBinding.Schema.INSTANCE.objectToEntry((Comparable)defaultSchema.getName()));
                if (ret != null) {
                    do {
                        Comparable comparable = NameBinding.Entity.INSTANCE.entryToObject(cursor2.getKey());
                        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.database.Name.EntityName");
                        Name.EntityName name = (Name.EntityName)comparable;
                        if (!Intrinsics.areEqual((Object)name.schema(), (Object)defaultSchema.getName())) break;
                        list2.add(name);
                    } while (cursor2.getNext());
                }
                cursor2.close();
                list = list2;
            }
            finally {
                lock2.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Entity entityForName(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!EntityCatalogueEntry.Companion.exists$cottontaildb_dbms(name, defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                    throw new DatabaseException.EntityDoesNotExistException(name);
                }
                Entity entity = new DefaultEntity(name, defaultSchema);
                return entity;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Entity createEntity(@NotNull Name.EntityName name, ColumnDef<?> ... columns) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                Collection<Name.ColumnName> collection;
                int n;
                boolean $i$f$forEach;
                ColumnDef<?>[] $this$forEach$iv;
                int n2;
                Object object;
                ColumnDef<?>[] $this$mapTo$iv$iv2;
                boolean bl = false;
                if (columns.length == 0) {
                    throw new DatabaseException.NoColumnException(name);
                }
                if (EntityCatalogueEntry.Companion.exists$cottontaildb_dbms(name, defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                    throw new DatabaseException.EntityAlreadyExistsException(name);
                }
                ColumnDef<?>[] $this$map$iv = columns;
                boolean $i$f$map = false;
                ColumnDef<?>[] columnDefArray = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (ColumnDef<?> item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    void var14_23 = item$iv$iv;
                    object = destination$iv$iv2;
                    n2 = 0;
                    object.add(it.getName());
                }
                int distinctSize = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)).size();
                if (distinctSize != columns.length) {
                    $this$forEach$iv = columns;
                    $i$f$forEach = false;
                    int destination$iv$iv2 = $this$forEach$iv.length;
                    for (int $this$mapTo$iv$iv2 = 0; $this$mapTo$iv$iv2 < destination$iv$iv2; ++$this$mapTo$iv$iv2) {
                        boolean bl2;
                        ColumnDef<?> it1;
                        block15: {
                            ColumnDef<?> element$iv;
                            it1 = element$iv = $this$forEach$iv[$this$mapTo$iv$iv2];
                            n = 0;
                            ColumnDef<?>[] $this$any$iv = columns;
                            boolean $i$f$any = false;
                            int n3 = $this$any$iv.length;
                            for (n2 = 0; n2 < n3; ++n2) {
                                ColumnDef<?> element$iv2;
                                ColumnDef<?> it2 = element$iv2 = $this$any$iv[n2];
                                boolean bl3 = false;
                                if (!(Intrinsics.areEqual((Object)it1.getName(), (Object)it2.getName()) && it1 != it2)) continue;
                                bl2 = true;
                                break block15;
                            }
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        throw new DatabaseException.DuplicateColumnException(name, it1.getName());
                    }
                }
                $this$forEach$iv = columns;
                long l = System.currentTimeMillis();
                Name.EntityName entityName = name;
                object = EntityCatalogueEntry.Companion;
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv;
                destination$iv$iv2 = new ArrayList($this$map$iv.length);
                $i$f$mapTo = false;
                n = $this$mapTo$iv$iv2.length;
                for (int it1 = 0; it1 < n; ++it1) {
                    void it;
                    ColumnDef<?> item$iv$iv;
                    ColumnDef<?> $i$f$any = item$iv$iv = $this$mapTo$iv$iv2[it1];
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(it.getName());
                }
                Name.EntityName entityName2 = entityName;
                long l2 = l;
                collection = (List)destination$iv$iv2;
                Collection<Name.ColumnName> collection2 = collection;
                List list = CollectionsKt.emptyList();
                if (!((EntityCatalogueEntry.Companion)object).write$cottontaildb_dbms(new EntityCatalogueEntry(entityName2, l2, (List<Name.ColumnName>)collection2, list), defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                    throw new DatabaseException.DataCorruptionException("CREATE entity " + name + " failed: Failed to create catalogue entry.");
                }
                if (!SequenceCatalogueEntries.INSTANCE.create$cottontaildb_dbms(name.tid(), defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                    throw new DatabaseException.DataCorruptionException("CREATE entity " + name + " failed: Failed to create sequence entry for tuple ID.");
                }
                $this$forEach$iv = columns;
                $i$f$forEach = false;
                int n4 = $this$forEach$iv.length;
                for (int i = 0; i < n4; ++i) {
                    ColumnDef<?> element$iv;
                    ColumnDef<?> it = element$iv = $this$forEach$iv[i];
                    boolean bl5 = false;
                    if (!ColumnCatalogueEntry.Companion.write$cottontaildb_dbms(new ColumnCatalogueEntry(it), defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                        throw new DatabaseException.DataCorruptionException("CREATE entity " + name + " failed: Failed to create column entry for column " + it + '.');
                    }
                    if (!StatisticsCatalogueEntry.Companion.write$cottontaildb_dbms(new StatisticsCatalogueEntry(it), defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                        throw new DatabaseException.DataCorruptionException("CREATE entity " + name + " failed: Failed to create statistics entry for column " + it + '.');
                    }
                    if (defaultSchema.getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(it.getName()), StoreConfig.WITHOUT_DUPLICATES, this.getContext().getXodusTx(), true) != null) continue;
                    throw new DatabaseException.DataCorruptionException("CREATE entity " + name + " failed: Failed to create store for column " + it + '.');
                }
                Entity entity = new DefaultEntity(name, defaultSchema);
                return entity;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                Name.IndexName it;
                boolean bl = false;
                EntityCatalogueEntry entityCatalogueEntry = EntityCatalogueEntry.Companion.read$cottontaildb_dbms(name, defaultSchema.getCatalogue(), this.getContext().getXodusTx());
                if (entityCatalogueEntry == null) {
                    throw new DatabaseException.EntityDoesNotExistException(name);
                }
                EntityCatalogueEntry entry = entityCatalogueEntry;
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(new DefaultEntity(name, defaultSchema));
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx entityTx = (EntityTx)tx;
                Iterable $this$forEach$iv = entry.getIndexes();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Name.IndexName)element$iv;
                    boolean bl2 = false;
                    entityTx.dropIndex(it);
                }
                $this$forEach$iv = entry.getColumns();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Name.ColumnName)element$iv;
                    boolean bl3 = false;
                    if (!ColumnCatalogueEntry.Companion.delete$cottontaildb_dbms((Name.ColumnName)it, defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                        throw new DatabaseException.DataCorruptionException("DROP entity " + name + " failed: Failed to delete column entry for column " + it + '.');
                    }
                    if (!StatisticsCatalogueEntry.Companion.delete$cottontaildb_dbms((Name.ColumnName)it, defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                        throw new DatabaseException.DataCorruptionException("DROP entity " + name + " failed: Failed to delete statistics entry for column " + it + '.');
                    }
                    defaultSchema.getParent().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName((Name.ColumnName)it), this.getContext().getXodusTx());
                }
                if (!EntityCatalogueEntry.Companion.delete$cottontaildb_dbms(name, defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                    throw new DatabaseException.DataCorruptionException("DROP entity " + name + " failed: Failed to delete catalogue entry.");
                }
                if (!SequenceCatalogueEntries.INSTANCE.delete$cottontaildb_dbms(name.tid(), defaultSchema.getCatalogue(), this.getContext().getXodusTx())) {
                    throw new DatabaseException.DataCorruptionException("DROP entity " + name + " failed: Failed to delete tuple ID sequence entry.");
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncateEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                Name.IndexName it;
                boolean bl = false;
                EntityCatalogueEntry entityCatalogueEntry = EntityCatalogueEntry.Companion.read$cottontaildb_dbms(name, defaultSchema.getCatalogue(), this.getContext().getXodusTx());
                if (entityCatalogueEntry == null) {
                    throw new DatabaseException.EntityDoesNotExistException(name);
                }
                EntityCatalogueEntry entry = entityCatalogueEntry;
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(new DefaultEntity(name, defaultSchema));
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx entityTx = (EntityTx)tx;
                Iterable $this$forEach$iv = entry.getIndexes();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Name.IndexName)element$iv;
                    boolean bl2 = false;
                    org.vitrivr.cottontail.dbms.general.Tx tx2 = this.getContext().getTx(entityTx.indexForName(it));
                    Intrinsics.checkNotNull((Object)tx2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.IndexTx");
                    IndexTx indexTx = (IndexTx)tx2;
                    indexTx.clear();
                }
                $this$forEach$iv = entry.getColumns();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Name.ColumnName)element$iv;
                    boolean bl3 = false;
                    org.vitrivr.cottontail.dbms.general.Tx tx3 = this.getContext().getTx(entityTx.columnForName((Name.ColumnName)it));
                    Intrinsics.checkNotNull((Object)tx3, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                    ColumnTx columnTx = (ColumnTx)tx3;
                    columnTx.clear();
                }
                if (!SequenceCatalogueEntries.INSTANCE.reset$cottontaildb_dbms(name.tid(), defaultSchema.getCatalogue(), this.getContext().getXodusTx()) && SequenceCatalogueEntries.INSTANCE.read$cottontaildb_dbms(name.tid(), defaultSchema.getCatalogue(), this.getContext().getXodusTx()) == null) {
                    throw new DatabaseException.DataCorruptionException("DROP entity " + name + " failed: Failed to reset tuple ID sequence entry.");
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        public void cleanup() {
            this.getDbo().getCatalogue().getCloseLock$cottontaildb_dbms().unlockRead(this.closeStamp);
        }
    }
}

