/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.columns;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.bindings.BooleanBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.values.BooleanVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.dbms.statistics.columns.AbstractValueStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.xodus.XodusBinding;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0000H\u0016J\u001f\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0011J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00f8\u0001\u0001\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/BooleanVectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/AbstractValueStatistics;", "Lorg/vitrivr/cottontail/core/values/BooleanVectorValue;", "logicalSize", "", "(I)V", "numberOfFalseEntries", "", "getNumberOfFalseEntries", "()[J", "numberOfTrueEntries", "getNumberOfTrueEntries", "copy", "delete", "", "deleted", "delete-cmzpXVc", "([Z)V", "insert", "inserted", "insert-cmzpXVc", "reset", "Binding", "cottontaildb-dbms"})
public final class BooleanVectorValueStatistics
extends AbstractValueStatistics<BooleanVectorValue> {
    @NotNull
    private final long[] numberOfTrueEntries = new long[this.getType().getLogicalSize()];

    public BooleanVectorValueStatistics(int logicalSize) {
        super((Types)new Types.BooleanVector(logicalSize), null);
    }

    @NotNull
    public final long[] getNumberOfTrueEntries() {
        return this.numberOfTrueEntries;
    }

    @NotNull
    public final long[] getNumberOfFalseEntries() {
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        long[] lArray = new long[n2];
        while (n < n2) {
            int n3 = n++;
            lArray[n3] = this.getNumberOfNonNullEntries() - this.numberOfTrueEntries[n3];
        }
        return lArray;
    }

    public void insert-cmzpXVc(@Nullable boolean[] inserted) {
        super.insert(inserted != null ? BooleanVectorValue.box-impl((boolean[])inserted) : null);
        if (inserted != null) {
            boolean[] blArray = inserted;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                boolean d = blArray[i];
                if (!d) continue;
                this.numberOfTrueEntries[i2] = this.numberOfTrueEntries[i2] + 1L;
            }
        }
    }

    public void delete-cmzpXVc(@Nullable boolean[] deleted) {
        super.delete(deleted != null ? BooleanVectorValue.box-impl((boolean[])deleted) : null);
        if (deleted != null) {
            boolean[] blArray = deleted;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                boolean d = blArray[i];
                if (!d) continue;
                this.numberOfTrueEntries[i2] = this.numberOfTrueEntries[i2] - 1L;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        int n = this.getType().getLogicalSize();
        for (int i = 0; i < n; ++i) {
            this.numberOfTrueEntries[i] = 0L;
        }
    }

    @NotNull
    public BooleanVectorValueStatistics copy() {
        BooleanVectorValueStatistics copy = new BooleanVectorValueStatistics(this.getType().getLogicalSize());
        copy.setFresh(this.getFresh());
        copy.setNumberOfNullEntries(this.getNumberOfNullEntries());
        copy.setNumberOfNonNullEntries(this.getNumberOfNonNullEntries());
        int n = this.getType().getLogicalSize();
        for (int i = 0; i < n; ++i) {
            copy.numberOfTrueEntries[i] = this.numberOfTrueEntries[i];
        }
        return copy;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/BooleanVectorValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/xodus/XodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/BooleanVectorValueStatistics;", "logicalSize", "", "(I)V", "getLogicalSize", "()I", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements XodusBinding<BooleanVectorValueStatistics> {
        private final int logicalSize;

        public Binding(int logicalSize) {
            this.logicalSize = logicalSize;
        }

        public final int getLogicalSize() {
            return this.logicalSize;
        }

        @Override
        @NotNull
        public BooleanVectorValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            BooleanVectorValueStatistics stat = new BooleanVectorValueStatistics(this.logicalSize);
            Boolean bl = BooleanBinding.BINDING.readObject(stream);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"BINDING.readObject(stream)");
            stat.setFresh(bl);
            stat.setNumberOfNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfNonNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            int n = this.logicalSize;
            for (int i = 0; i < n; ++i) {
                stat.getNumberOfTrueEntries()[i] = LongBinding.readCompressed((ByteArrayInputStream)stream);
                stat.getNumberOfFalseEntries()[i] = LongBinding.readCompressed((ByteArrayInputStream)stream);
            }
            return stat;
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull BooleanVectorValueStatistics statistics) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
            BooleanBinding.BINDING.writeObject(output, (Comparable)Boolean.valueOf(statistics.getFresh()));
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfNonNullEntries());
            int n = statistics.getType().getLogicalSize();
            for (int i = 0; i < n; ++i) {
                LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfTrueEntries()[i]);
                LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfFalseEntries()[i]);
            }
        }
    }
}

