/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.columns;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.bindings.BooleanBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.SignedDoubleBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.dbms.statistics.columns.AbstractValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.VectorValueStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.xodus.XodusBinding;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u001bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u001f\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016R\u001f\u0010\u0007\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001d\u0010\u000b\u001a\u00020\u00028VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u001f\u0010\r\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000e\u0010\tR\u001f\u0010\u000f\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0010\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/DoubleVectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/AbstractValueStatistics;", "Lorg/vitrivr/cottontail/core/values/DoubleVectorValue;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/VectorValueStatistics;", "logicalSize", "", "(I)V", "max", "getMax-aM0kQ94", "()[D", "[D", "mean", "getMean-aM0kQ94", "min", "getMin-aM0kQ94", "sum", "getSum-aM0kQ94", "copy", "delete", "", "deleted", "delete-962Je_c", "([D)V", "insert", "inserted", "insert-962Je_c", "reset", "Binding", "cottontaildb-dbms"})
public final class DoubleVectorValueStatistics
extends AbstractValueStatistics<DoubleVectorValue>
implements VectorValueStatistics<DoubleVectorValue> {
    @NotNull
    private final double[] min;
    @NotNull
    private final double[] max;
    @NotNull
    private final double[] sum;

    public DoubleVectorValueStatistics(int logicalSize) {
        super((Types)new Types.DoubleVector(logicalSize), null);
        int n;
        int n2 = 0;
        int n3 = this.getType().getLogicalSize();
        double[] dArray = new double[n3];
        DoubleVectorValueStatistics doubleVectorValueStatistics = this;
        while (n2 < n3) {
            n = n2++;
            dArray[n] = Double.MAX_VALUE;
        }
        doubleVectorValueStatistics.min = DoubleVectorValue.constructor-impl((double[])dArray);
        n2 = 0;
        n3 = this.getType().getLogicalSize();
        dArray = new double[n3];
        doubleVectorValueStatistics = this;
        while (n2 < n3) {
            n = n2++;
            dArray[n] = Double.MIN_VALUE;
        }
        doubleVectorValueStatistics.max = DoubleVectorValue.constructor-impl((double[])dArray);
        this.sum = DoubleVectorValue.constructor-impl((double[])new double[this.getType().getLogicalSize()]);
    }

    @NotNull
    public double[] getMin-aM0kQ94() {
        return this.min;
    }

    @NotNull
    public double[] getMax-aM0kQ94() {
        return this.max;
    }

    @NotNull
    public double[] getSum-aM0kQ94() {
        return this.sum;
    }

    @NotNull
    public double[] getMean-aM0kQ94() {
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = DoubleVectorValue.get-iEH02FE((double[])this.getSum-aM0kQ94(), (int)n3) / (double)this.getNumberOfNonNullEntries();
        }
        return DoubleVectorValue.constructor-impl((double[])dArray);
    }

    public void insert-962Je_c(@Nullable double[] inserted) {
        super.insert(inserted != null ? DoubleVectorValue.box-impl((double[])inserted) : null);
        if (inserted != null) {
            double[] dArray = inserted;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                double d = dArray[i];
                this.getMin-aM0kQ94()[i2] = Double.min(d, this.getMin-aM0kQ94()[i2]);
                this.getMax-aM0kQ94()[i2] = Double.max(d, this.getMax-aM0kQ94()[i2]);
                double[] dArray2 = this.getSum-aM0kQ94();
                dArray2[i2] = dArray2[i2] + d;
            }
        }
    }

    public void delete-962Je_c(@Nullable double[] deleted) {
        super.delete(deleted != null ? DoubleVectorValue.box-impl((double[])deleted) : null);
        if (deleted != null) {
            double[] dArray = deleted;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                double d = dArray[i];
                if (this.getMin-aM0kQ94()[i2] == d || this.getMax-aM0kQ94()[i2] == d) {
                    this.setFresh(false);
                }
                double[] dArray2 = this.getSum-aM0kQ94();
                dArray2[i2] = dArray2[i2] - d;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        int n = this.getType().getLogicalSize();
        for (int i = 0; i < n; ++i) {
            this.getMin-aM0kQ94()[i] = Double.MAX_VALUE;
            this.getMax-aM0kQ94()[i] = Double.MIN_VALUE;
            this.getSum-aM0kQ94()[i] = 0.0;
        }
    }

    @NotNull
    public DoubleVectorValueStatistics copy() {
        DoubleVectorValueStatistics copy = new DoubleVectorValueStatistics(this.getType().getLogicalSize());
        copy.setFresh(this.getFresh());
        copy.setNumberOfNullEntries(this.getNumberOfNullEntries());
        copy.setNumberOfNonNullEntries(this.getNumberOfNonNullEntries());
        int n = this.getType().getLogicalSize();
        for (int i = 0; i < n; ++i) {
            copy.getMin-aM0kQ94()[i] = this.getMin-aM0kQ94()[i];
            copy.getMax-aM0kQ94()[i] = this.getMax-aM0kQ94()[i];
            copy.getSum-aM0kQ94()[i] = this.getSum-aM0kQ94()[i];
        }
        return copy;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/DoubleVectorValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/xodus/XodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/DoubleVectorValueStatistics;", "logicalSize", "", "(I)V", "getLogicalSize", "()I", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements XodusBinding<DoubleVectorValueStatistics> {
        private final int logicalSize;

        public Binding(int logicalSize) {
            this.logicalSize = logicalSize;
        }

        public final int getLogicalSize() {
            return this.logicalSize;
        }

        @Override
        @NotNull
        public DoubleVectorValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            DoubleVectorValueStatistics stat = new DoubleVectorValueStatistics(this.logicalSize);
            Boolean bl = BooleanBinding.BINDING.readObject(stream);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"BINDING.readObject(stream)");
            stat.setFresh(bl);
            stat.setNumberOfNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfNonNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            int n = this.logicalSize;
            for (int i = 0; i < n; ++i) {
                double[] dArray = stat.getMin-aM0kQ94();
                Double d = SignedDoubleBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"BINDING.readObject(stream)");
                dArray[i] = ((Number)d).doubleValue();
                double[] dArray2 = stat.getMax-aM0kQ94();
                Double d2 = SignedDoubleBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"BINDING.readObject(stream)");
                dArray2[i] = ((Number)d2).doubleValue();
                double[] dArray3 = stat.getSum-aM0kQ94();
                Double d3 = SignedDoubleBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"BINDING.readObject(stream)");
                dArray3[i] = ((Number)d3).doubleValue();
            }
            return stat;
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull DoubleVectorValueStatistics statistics) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
            BooleanBinding.BINDING.writeObject(output, (Comparable)Boolean.valueOf(statistics.getFresh()));
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfNonNullEntries());
            int n = statistics.getType().getLogicalSize();
            for (int i = 0; i < n; ++i) {
                SignedDoubleBinding.BINDING.writeObject(output, (Comparable)Double.valueOf(statistics.getMin-aM0kQ94()[i]));
                SignedDoubleBinding.BINDING.writeObject(output, (Comparable)Double.valueOf(statistics.getMax-aM0kQ94()[i]));
                SignedDoubleBinding.BINDING.writeObject(output, (Comparable)Double.valueOf(statistics.getSum-aM0kQ94()[i]));
            }
        }
    }
}

