/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.columns;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.bindings.BooleanBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.SignedFloatBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.dbms.statistics.columns.AbstractValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.VectorValueStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.xodus.XodusBinding;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u001bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u001f\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016R\u001f\u0010\u0007\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001d\u0010\u000b\u001a\u00020\u00028VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u001f\u0010\r\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000e\u0010\tR\u001f\u0010\u000f\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0010\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/FloatVectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/AbstractValueStatistics;", "Lorg/vitrivr/cottontail/core/values/FloatVectorValue;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/VectorValueStatistics;", "logicalSize", "", "(I)V", "max", "getMax-JdBqzJc", "()[F", "[F", "mean", "getMean-JdBqzJc", "min", "getMin-JdBqzJc", "sum", "getSum-JdBqzJc", "copy", "delete", "", "deleted", "delete-qTmBfow", "([F)V", "insert", "inserted", "insert-qTmBfow", "reset", "Binding", "cottontaildb-dbms"})
public final class FloatVectorValueStatistics
extends AbstractValueStatistics<FloatVectorValue>
implements VectorValueStatistics<FloatVectorValue> {
    @NotNull
    private final float[] min;
    @NotNull
    private final float[] max;
    @NotNull
    private final float[] sum;

    public FloatVectorValueStatistics(int logicalSize) {
        super((Types)new Types.FloatVector(logicalSize), null);
        int n;
        int n2 = 0;
        int n3 = this.getType().getLogicalSize();
        float[] fArray = new float[n3];
        FloatVectorValueStatistics floatVectorValueStatistics = this;
        while (n2 < n3) {
            n = n2++;
            fArray[n] = Float.MAX_VALUE;
        }
        floatVectorValueStatistics.min = FloatVectorValue.constructor-impl((float[])fArray);
        n2 = 0;
        n3 = this.getType().getLogicalSize();
        fArray = new float[n3];
        floatVectorValueStatistics = this;
        while (n2 < n3) {
            n = n2++;
            fArray[n] = Float.MIN_VALUE;
        }
        floatVectorValueStatistics.max = FloatVectorValue.constructor-impl((float[])fArray);
        this.sum = FloatVectorValue.constructor-impl((float[])new float[this.getType().getLogicalSize()]);
    }

    @NotNull
    public float[] getMin-JdBqzJc() {
        return this.min;
    }

    @NotNull
    public float[] getMax-JdBqzJc() {
        return this.max;
    }

    @NotNull
    public float[] getSum-JdBqzJc() {
        return this.sum;
    }

    @NotNull
    public float[] getMean-JdBqzJc() {
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = FloatVectorValue.get-PgYoAEc((float[])this.getSum-JdBqzJc(), (int)n3) / (float)this.getNumberOfNonNullEntries();
        }
        return FloatVectorValue.constructor-impl((float[])fArray);
    }

    public void insert-qTmBfow(@Nullable float[] inserted) {
        super.insert(inserted != null ? FloatVectorValue.box-impl((float[])inserted) : null);
        if (inserted != null) {
            float[] fArray = inserted;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                float d = fArray[i];
                this.getMin-JdBqzJc()[i2] = Float.min(d, this.getMin-JdBqzJc()[i2]);
                this.getMax-JdBqzJc()[i2] = Float.max(d, this.getMax-JdBqzJc()[i2]);
                float[] fArray2 = this.getSum-JdBqzJc();
                fArray2[i2] = fArray2[i2] + d;
            }
        }
    }

    public void delete-qTmBfow(@Nullable float[] deleted) {
        super.delete(deleted != null ? FloatVectorValue.box-impl((float[])deleted) : null);
        if (deleted != null) {
            float[] fArray = deleted;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                float d = fArray[i];
                if (this.getMin-JdBqzJc()[i2] == d || this.getMax-JdBqzJc()[i2] == d) {
                    this.setFresh(false);
                }
                float[] fArray2 = this.getSum-JdBqzJc();
                fArray2[i2] = fArray2[i2] - d;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        int n = this.getType().getLogicalSize();
        for (int i = 0; i < n; ++i) {
            this.getMin-JdBqzJc()[i] = Float.MAX_VALUE;
            this.getMax-JdBqzJc()[i] = Float.MIN_VALUE;
            this.getSum-JdBqzJc()[i] = 0.0f;
        }
    }

    @NotNull
    public FloatVectorValueStatistics copy() {
        FloatVectorValueStatistics copy = new FloatVectorValueStatistics(this.getType().getLogicalSize());
        copy.setFresh(this.getFresh());
        copy.setNumberOfNullEntries(this.getNumberOfNullEntries());
        copy.setNumberOfNonNullEntries(this.getNumberOfNonNullEntries());
        int n = this.getType().getLogicalSize();
        for (int i = 0; i < n; ++i) {
            copy.getMin-JdBqzJc()[i] = this.getMin-JdBqzJc()[i];
            copy.getMax-JdBqzJc()[i] = this.getMax-JdBqzJc()[i];
            copy.getSum-JdBqzJc()[i] = this.getSum-JdBqzJc()[i];
        }
        return copy;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/FloatVectorValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/xodus/XodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/FloatVectorValueStatistics;", "logicalSize", "", "(I)V", "getLogicalSize", "()I", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements XodusBinding<FloatVectorValueStatistics> {
        private final int logicalSize;

        public Binding(int logicalSize) {
            this.logicalSize = logicalSize;
        }

        public final int getLogicalSize() {
            return this.logicalSize;
        }

        @Override
        @NotNull
        public FloatVectorValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            FloatVectorValueStatistics stat = new FloatVectorValueStatistics(this.logicalSize);
            Boolean bl = BooleanBinding.BINDING.readObject(stream);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"BINDING.readObject(stream)");
            stat.setFresh(bl);
            stat.setNumberOfNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfNonNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            int n = this.logicalSize;
            for (int i = 0; i < n; ++i) {
                float[] fArray = stat.getMin-JdBqzJc();
                Float f = SignedFloatBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)f, (String)"BINDING.readObject(stream)");
                fArray[i] = ((Number)f).floatValue();
                float[] fArray2 = stat.getMax-JdBqzJc();
                Float f2 = SignedFloatBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"BINDING.readObject(stream)");
                fArray2[i] = ((Number)f2).floatValue();
                float[] fArray3 = stat.getSum-JdBqzJc();
                Float f3 = SignedFloatBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"BINDING.readObject(stream)");
                fArray3[i] = ((Number)f3).floatValue();
            }
            return stat;
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull FloatVectorValueStatistics statistics) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
            BooleanBinding.BINDING.writeObject(output, (Comparable)Boolean.valueOf(statistics.getFresh()));
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfNonNullEntries());
            int n = statistics.getType().getLogicalSize();
            for (int i = 0; i < n; ++i) {
                SignedFloatBinding.BINDING.writeObject(output, (Comparable)Float.valueOf(statistics.getMin-JdBqzJc()[i]));
                SignedFloatBinding.BINDING.writeObject(output, (Comparable)Float.valueOf(statistics.getMax-JdBqzJc()[i]));
                SignedFloatBinding.BINDING.writeObject(output, (Comparable)Float.valueOf(statistics.getSum-JdBqzJc()[i]));
            }
        }
    }
}

