/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.columns;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.bindings.BooleanBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.values.LongVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.dbms.statistics.columns.AbstractValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.VectorValueStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.xodus.XodusBinding;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u001bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u001f\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016R\u001f\u0010\u0007\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001d\u0010\u000b\u001a\u00020\u00028VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u001f\u0010\r\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000e\u0010\tR\u001f\u0010\u000f\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0010\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/LongVectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/AbstractValueStatistics;", "Lorg/vitrivr/cottontail/core/values/LongVectorValue;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/VectorValueStatistics;", "logicalSize", "", "(I)V", "max", "getMax-KCB4rAk", "()[J", "[J", "mean", "getMean-KCB4rAk", "min", "getMin-KCB4rAk", "sum", "getSum-KCB4rAk", "copy", "delete", "", "deleted", "delete-KvwBEqU", "([J)V", "insert", "inserted", "insert-KvwBEqU", "reset", "Binding", "cottontaildb-dbms"})
public final class LongVectorValueStatistics
extends AbstractValueStatistics<LongVectorValue>
implements VectorValueStatistics<LongVectorValue> {
    @NotNull
    private final long[] min;
    @NotNull
    private final long[] max;
    @NotNull
    private final long[] sum;

    public LongVectorValueStatistics(int logicalSize) {
        super((Types)new Types.LongVector(logicalSize), null);
        int n;
        int n2 = 0;
        int n3 = this.getType().getLogicalSize();
        long[] lArray = new long[n3];
        LongVectorValueStatistics longVectorValueStatistics = this;
        while (n2 < n3) {
            n = n2++;
            lArray[n] = Long.MAX_VALUE;
        }
        longVectorValueStatistics.min = LongVectorValue.constructor-impl((long[])lArray);
        n2 = 0;
        n3 = this.getType().getLogicalSize();
        lArray = new long[n3];
        longVectorValueStatistics = this;
        while (n2 < n3) {
            n = n2++;
            lArray[n] = Long.MIN_VALUE;
        }
        longVectorValueStatistics.max = LongVectorValue.constructor-impl((long[])lArray);
        this.sum = LongVectorValue.constructor-impl((long[])new long[this.getType().getLogicalSize()]);
    }

    @NotNull
    public long[] getMin-KCB4rAk() {
        return this.min;
    }

    @NotNull
    public long[] getMax-KCB4rAk() {
        return this.max;
    }

    @NotNull
    public long[] getSum-KCB4rAk() {
        return this.sum;
    }

    @NotNull
    public long[] getMean-KCB4rAk() {
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        long[] lArray = new long[n2];
        while (n < n2) {
            int n3 = n++;
            lArray[n3] = LongVectorValue.get-Zk1dq3U((long[])this.getSum-KCB4rAk(), (int)n3) / this.getNumberOfNonNullEntries();
        }
        return LongVectorValue.constructor-impl((long[])lArray);
    }

    public void insert-KvwBEqU(@Nullable long[] inserted) {
        super.insert(inserted != null ? LongVectorValue.box-impl((long[])inserted) : null);
        if (inserted != null) {
            long[] lArray = inserted;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                long d = lArray[i];
                this.getMin-KCB4rAk()[i2] = Long.min(d, this.getMin-KCB4rAk()[i2]);
                this.getMax-KCB4rAk()[i2] = Long.max(d, this.getMax-KCB4rAk()[i2]);
            }
        }
    }

    public void delete-KvwBEqU(@Nullable long[] deleted) {
        super.delete(deleted != null ? LongVectorValue.box-impl((long[])deleted) : null);
        if (deleted != null) {
            long[] lArray = deleted;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                long d = lArray[i];
                if (this.getMin-KCB4rAk()[i2] != d && this.getMax-KCB4rAk()[i2] != d) continue;
                this.setFresh(false);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        int n = this.getType().getLogicalSize();
        for (int i = 0; i < n; ++i) {
            this.getMin-KCB4rAk()[i] = Long.MAX_VALUE;
            this.getMax-KCB4rAk()[i] = Long.MIN_VALUE;
        }
    }

    @NotNull
    public LongVectorValueStatistics copy() {
        LongVectorValueStatistics copy = new LongVectorValueStatistics(this.getType().getLogicalSize());
        copy.setFresh(this.getFresh());
        copy.setNumberOfNullEntries(this.getNumberOfNullEntries());
        copy.setNumberOfNonNullEntries(this.getNumberOfNonNullEntries());
        int n = this.getType().getLogicalSize();
        for (int i = 0; i < n; ++i) {
            copy.getMin-KCB4rAk()[i] = this.getMin-KCB4rAk()[i];
            copy.getMax-KCB4rAk()[i] = this.getMax-KCB4rAk()[i];
            copy.getSum-KCB4rAk()[i] = this.getSum-KCB4rAk()[i];
        }
        return copy;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/LongVectorValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/xodus/XodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/LongVectorValueStatistics;", "logicalSize", "", "(I)V", "getLogicalSize", "()I", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements XodusBinding<LongVectorValueStatistics> {
        private final int logicalSize;

        public Binding(int logicalSize) {
            this.logicalSize = logicalSize;
        }

        public final int getLogicalSize() {
            return this.logicalSize;
        }

        @Override
        @NotNull
        public LongVectorValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            LongVectorValueStatistics stat = new LongVectorValueStatistics(this.logicalSize);
            Boolean bl = BooleanBinding.BINDING.readObject(stream);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"BINDING.readObject(stream)");
            stat.setFresh(bl);
            stat.setNumberOfNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfNonNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            int n = this.logicalSize;
            for (int i = 0; i < n; ++i) {
                long[] lArray = stat.getMin-KCB4rAk();
                Long l = LongBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"BINDING.readObject(stream)");
                lArray[i] = ((Number)l).longValue();
                long[] lArray2 = stat.getMax-KCB4rAk();
                Long l2 = LongBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"BINDING.readObject(stream)");
                lArray2[i] = ((Number)l2).longValue();
                long[] lArray3 = stat.getSum-KCB4rAk();
                Long l3 = LongBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"BINDING.readObject(stream)");
                lArray3[i] = ((Number)l3).longValue();
            }
            return stat;
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull LongVectorValueStatistics statistics) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
            BooleanBinding.BINDING.writeObject(output, (Comparable)Boolean.valueOf(statistics.getFresh()));
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics.getNumberOfNonNullEntries());
            int n = statistics.getType().getLogicalSize();
            for (int i = 0; i < n; ++i) {
                LongBinding.BINDING.writeObject(output, (Comparable)Long.valueOf(statistics.getMin-KCB4rAk()[i]));
                LongBinding.BINDING.writeObject(output, (Comparable)Long.valueOf(statistics.getMax-KCB4rAk()[i]));
                LongBinding.BINDING.writeObject(output, (Comparable)Long.valueOf(statistics.getSum-KCB4rAk()[i]));
            }
        }
    }
}

