/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.BufferedWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeSource;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueTx;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.execution.locking.LockMode;
import org.vitrivr.cottontail.dbms.execution.operators.basics.Operator;
import org.vitrivr.cottontail.dbms.execution.operators.sources.PartitionCalculatorKt;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionStatus;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionType;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.Tx;
import org.vitrivr.cottontail.dbms.index.Index;
import org.vitrivr.cottontail.dbms.index.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;
import org.vitrivr.cottontail.legacy.MigrationManager;
import org.vitrivr.cottontail.legacy.v2.entity.BrokenIndexV2;
import org.vitrivr.cottontail.utilities.io.TxFileUtilities;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0013H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;", "Lorg/vitrivr/cottontail/legacy/MigrationManager;", "batchSize", "", "logFile", "Ljava/nio/file/Path;", "(ILjava/nio/file/Path;)V", "transactionIdCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "writer", "Ljava/io/BufferedWriter;", "close", "", "log", "message", "", "logStdout", "migrate", "config", "Lorg/vitrivr/cottontail/config/Config;", "migrateDBOs", "source", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "destination", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "migrateData", "openDestinationCatalogue", "openSourceCatalogue", "LegacyMigrationContext", "MigrationContext", "cottontaildb-dbms"})
@ExperimentalTime
public abstract class AbstractMigrationManager
implements MigrationManager {
    private final int batchSize;
    @NotNull
    private final AtomicLong transactionIdCounter;
    @NotNull
    private final BufferedWriter writer;

    public AbstractMigrationManager(int batchSize, @NotNull Path logFile) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        this.batchSize = batchSize;
        this.transactionIdCounter = new AtomicLong(0L);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.CREATE};
        BufferedWriter bufferedWriter = Files.newBufferedWriter(logFile.resolve("cottontaildb_migration_" + System.currentTimeMillis() + ".log"), openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"newBufferedWriter(\n     \u2026rdOpenOption.CREATE\n    )");
        this.writer = bufferedWriter;
    }

    @Nullable
    public abstract Catalogue openSourceCatalogue(@NotNull Config var1);

    @Nullable
    public abstract DefaultCatalogue openDestinationCatalogue(@NotNull Config var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.log("Starting catalogue migration from " + (Object)((Object)this.getFrom()) + " for " + config.getRoot() + ".\n");
        Catalogue srcCatalogue = this.openSourceCatalogue(config);
        if (srcCatalogue == null) {
            this.log("Failed to open source catalogue.\n");
            return;
        }
        this.log("Source catalogue " + srcCatalogue.getConfig().getRoot() + " loaded successfully.\n");
        Path migratedDatabaseRoot = config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~migrated");
        if (!Files.exists(migratedDatabaseRoot, new LinkOption[0])) {
            Files.createDirectories(migratedDatabaseRoot, new FileAttribute[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)migratedDatabaseRoot, (String)"migratedDatabaseRoot");
        DefaultCatalogue dstCatalogue = this.openDestinationCatalogue(Config.copy$default(config, migratedDatabaseRoot, false, null, null, null, null, null, null, null, 510, null));
        if (dstCatalogue == null) {
            this.log("Failed to open destination catalogue.\n");
            srcCatalogue.close();
            return;
        }
        this.log("Destination catalogue " + dstCatalogue.getConfig().getRoot() + " loaded successfully.\n");
        boolean isWindows = false;
        try {
            this.migrateDBOs(srcCatalogue, dstCatalogue);
            this.migrateData(srcCatalogue, dstCatalogue);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(config.getRoot(), config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~old"), copyOptionArray);
            copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(migratedDatabaseRoot, config.getRoot(), copyOptionArray);
        }
        catch (Throwable e) {
            this.log("Error during data migration: " + e.getMessage() + '\n');
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            isWindows = StringsKt.contains$default((CharSequence)string2, (CharSequence)"windows", (boolean)false, (int)2, null);
            TxFileUtilities.INSTANCE.delete(dstCatalogue.getPath());
        }
        finally {
            srcCatalogue.close();
            dstCatalogue.close();
        }
        if (isWindows) {
            this.log(StringsKt.trimIndent((String)("\n                            Windows detected. Finish the migration before a restart manually:\n                              1. Move " + config.getRoot() + " -> " + config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~old") + "\n                              2. Move " + migratedDatabaseRoot + " -> " + config.getRoot() + "\n                              3. Delete " + dstCatalogue.getPath() + "\n                        ")));
        }
        long duration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        this.log("Data migration completed. Took " + Duration.toString-impl((long)duration) + ".\n");
    }

    /*
     * WARNING - void declaration
     */
    protected void migrateDBOs(@NotNull Catalogue source, @NotNull DefaultCatalogue destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        LegacyMigrationContext sourceContext = new LegacyMigrationContext();
        Transaction transaction = destination.getEnvironment$cottontaildb_dbms().beginExclusiveTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"destination.environment.\u2026ginExclusiveTransaction()");
        MigrationContext destinationContext = new MigrationContext(transaction);
        Tx tx = sourceContext.getTx(source);
        Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.catalogue.CatalogueTx");
        CatalogueTx srcCatalogueTx = (CatalogueTx)tx;
        Tx tx2 = destinationContext.getTx(destination);
        Intrinsics.checkNotNull((Object)tx2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.catalogue.CatalogueTx");
        CatalogueTx dstCatalogueTx = (CatalogueTx)tx2;
        List<Name.SchemaName> schemas = srcCatalogueTx.listSchemas();
        Iterator<Name.SchemaName> iterator = schemas.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int s = n++;
            Name.SchemaName srcSchemaName = iterator.next();
            this.log("+ Migrating schema " + srcSchemaName + " (" + (s + 1) + " / " + schemas.size() + "):\n");
            Schema schema = dstCatalogueTx.createSchema(srcSchemaName);
            Tx tx3 = destinationContext.getTx(schema);
            Intrinsics.checkNotNull((Object)tx3, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.schema.SchemaTx");
            SchemaTx dstSchemaTx = (SchemaTx)tx3;
            Tx tx4 = sourceContext.getTx(srcCatalogueTx.schemaForName(srcSchemaName));
            Intrinsics.checkNotNull((Object)tx4, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.schema.SchemaTx");
            SchemaTx srcSchemaTx = (SchemaTx)tx4;
            List<Name.EntityName> entities = srcSchemaTx.listEntities();
            Iterator<Name.EntityName> iterator2 = entities.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int i = n2++;
                Name.EntityName srcEntityName = iterator2.next();
                this.log("-- Migrating entity " + srcEntityName + " (" + (i + 1) + " / " + entities.size() + "):\n");
                Tx tx5 = sourceContext.getTx(srcSchemaTx.entityForName(srcEntityName));
                Intrinsics.checkNotNull((Object)tx5, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx srcEntityTx = (EntityTx)tx5;
                Collection $this$toTypedArray$iv = srcEntityTx.listColumns();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
                Intrinsics.checkNotNull((Object)columnDefArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                ColumnDef[] columnDefArray2 = columnDefArray;
                Entity entity = dstSchemaTx.createEntity(srcEntityName, Arrays.copyOf(columnDefArray2, columnDefArray2.length));
                for (Name.IndexName indexName : srcEntityTx.listIndexes()) {
                    Collection<Name.ColumnName> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    this.log("---- Migrating index " + indexName + "...\n");
                    Index index = srcEntityTx.indexForName(indexName);
                    Intrinsics.checkNotNull((Object)index, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.legacy.v2.entity.BrokenIndexV2");
                    BrokenIndexV2 index2 = (BrokenIndexV2)index;
                    Tx tx6 = destinationContext.getTx(entity);
                    Intrinsics.checkNotNull((Object)tx6, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                    EntityTx destEntityTx = (EntityTx)tx6;
                    ColumnDef<?>[] columnDefArray3 = index2.getColumns();
                    IndexType indexType = index2.getType();
                    Name.IndexName indexName2 = index2.getName();
                    EntityTx entityTx = destEntityTx;
                    boolean $i$f$map = false;
                    void var28_29 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n3 = ((void)$this$mapTo$iv$iv).length;
                    for (int j = 0; j < n3; ++j) {
                        void it;
                        void item$iv$iv;
                        void var34_35 = item$iv$iv = $this$mapTo$iv$iv[j];
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getName());
                    }
                    collection = (List)destination$iv$iv;
                    entityTx.createIndex(indexName2, indexType, (List<Name.ColumnName>)collection, IndexDescriptor.DefaultImpls.buildConfig$default(index2.getType().getDescriptor(), null, 1, null));
                }
            }
        }
        sourceContext.commit();
        destinationContext.commit();
    }

    protected void migrateData(@NotNull Catalogue source, @NotNull DefaultCatalogue destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        LegacyMigrationContext sourceContext = new LegacyMigrationContext();
        Tx tx = sourceContext.getTx(source);
        Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.catalogue.CatalogueTx");
        CatalogueTx srcCatalogueTx = (CatalogueTx)tx;
        List<Name.SchemaName> schemas = srcCatalogueTx.listSchemas();
        Iterator<Name.SchemaName> iterator = schemas.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int s = n++;
            Name.SchemaName srcSchemaName = iterator.next();
            Tx tx2 = sourceContext.getTx(srcCatalogueTx.schemaForName(srcSchemaName));
            Intrinsics.checkNotNull((Object)tx2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.schema.SchemaTx");
            SchemaTx srcSchemaTx = (SchemaTx)tx2;
            List<Name.EntityName> entities = srcSchemaTx.listEntities();
            this.logStdout("+ Migrating data for schema " + srcSchemaName + " (" + (s + 1) + " / " + schemas.size() + ")...\n");
            for (Name.EntityName srcEntityName : entities) {
                Tx tx3 = sourceContext.getTx(srcSchemaTx.entityForName(srcEntityName));
                Intrinsics.checkNotNull((Object)tx3, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx srcEntityTx = (EntityTx)tx3;
                long count = srcEntityTx.count();
                if (count > 0L) {
                    long size = srcEntityTx.largestTupleId() - srcEntityTx.smallestTupleId();
                    int partitions = (int)Math.floorDiv(size, this.batchSize) + 1;
                    Collection $this$toTypedArray$iv = srcEntityTx.listColumns();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Intrinsics.checkNotNull((Object)thisCollection$iv.toArray(new ColumnDef[0]), (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    long i = 0L;
                    for (int p = 0; p < partitions; ++p) {
                        ColumnDef[] columns;
                        Transaction transaction = destination.getEnvironment$cottontaildb_dbms().beginExclusiveTransaction();
                        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"destination.environment.\u2026ginExclusiveTransaction()");
                        MigrationContext destinationContext = new MigrationContext(transaction);
                        Tx tx4 = destinationContext.getTx(destination);
                        Intrinsics.checkNotNull((Object)tx4, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.catalogue.CatalogueTx");
                        CatalogueTx destCatalogueTx = (CatalogueTx)tx4;
                        Tx tx5 = destinationContext.getTx(destCatalogueTx.schemaForName(srcSchemaName));
                        Intrinsics.checkNotNull((Object)tx5, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.schema.SchemaTx");
                        SchemaTx destSchemaTx = (SchemaTx)tx5;
                        Tx tx6 = destinationContext.getTx(destSchemaTx.entityForName(srcEntityName));
                        Intrinsics.checkNotNull((Object)tx6, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                        EntityTx destEntityTx = (EntityTx)tx6;
                        Cursor cursor2 = srcEntityTx.cursor(columns, PartitionCalculatorKt.partitionFor(srcEntityTx, p, partitions));
                        Iterator $this$forEach$iv = (Iterator)cursor2;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv;
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            Record r = (Record)element$iv;
                            boolean bl = false;
                            this.logStdout("-- Migrating data for " + srcEntityName + "... (" + ++i + " / " + count + ")\r");
                            destEntityTx.insert(r);
                        }
                        cursor2.close();
                        this.log("-- Migrating data for " + srcEntityName + "; committing... (" + i + " / " + count + ")\r");
                        destinationContext.commit();
                    }
                    this.log("-- Data migration for " + srcEntityName + " completed (" + i + " / " + count + ").\n");
                    continue;
                }
                this.log("-- Data migration for " + srcEntityName + " skipped (no data).\n");
            }
        }
        sourceContext.rollback();
    }

    private final void logStdout(String message) {
        System.out.print((Object)message);
    }

    protected final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        System.out.print((Object)message);
        this.writer.append(message);
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010$\u001a\u00020%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001aH\u0016J\b\u0010-\u001a\u00020%H\u0016J\u0018\u0010.\u001a\u00020%2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020%H\u0016J\u0010\u00102\u001a\u00020%2\u0006\u00103\u001a\u000204H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager$LegacyMigrationContext;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "(Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;)V", "availableIntraQueryWorkers", "", "getAvailableIntraQueryWorkers", "()I", "availableQueryWorkers", "getAvailableQueryWorkers", "readonly", "", "getReadonly", "()Z", "<set-?>", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "txId", "", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "getTxId", "()J", "txns", "", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "Lorg/vitrivr/cottontail/dbms/general/Tx;", "type", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "getType", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "xodusTx", "Ljetbrains/exodus/env/Transaction;", "getXodusTx", "()Ljetbrains/exodus/env/Transaction;", "commit", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/core/basics/Record;", "operator", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "getTx", "dbo", "kill", "requestLock", "mode", "Lorg/vitrivr/cottontail/dbms/execution/locking/LockMode;", "rollback", "signalEvent", "action", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation;", "cottontaildb-dbms"})
    public final class LegacyMigrationContext
    implements TransactionContext,
    org.vitrivr.cottontail.dbms.execution.transactions.Transaction {
        private final long txId;
        @NotNull
        private final TransactionType type;
        private final boolean readonly;
        private final int availableQueryWorkers;
        private final int availableIntraQueryWorkers;
        @NotNull
        private volatile TransactionStatus state;
        @NotNull
        private final Map<DBO, Tx> txns;

        public LegacyMigrationContext() {
            this.txId = AbstractMigrationManager.this.transactionIdCounter.getAndIncrement();
            this.type = TransactionType.SYSTEM;
            this.readonly = true;
            this.state = TransactionStatus.IDLE;
            Object2ObjectMap object2ObjectMap = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap, (String)"synchronize(Object2ObjectLinkedOpenHashMap())");
            this.txns = (Map)object2ObjectMap;
        }

        @Override
        public long getTxId() {
            return this.txId;
        }

        @Override
        @NotNull
        public Transaction getXodusTx() {
            throw new UnsupportedOperationException("Xodus transaction not available for LegacyMigrationContext.");
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        @Override
        public boolean getReadonly() {
            return this.readonly;
        }

        @Override
        public int getAvailableQueryWorkers() {
            return this.availableQueryWorkers;
        }

        @Override
        public int getAvailableIntraQueryWorkers() {
            return this.availableIntraQueryWorkers;
        }

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        @Override
        @NotNull
        public Tx getTx(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Tx tx = this.txns.computeIfAbsent(dbo, arg_0 -> LegacyMigrationContext.getTx$lambda$0((Function1)new Function1<DBO, Tx>(dbo, this){
                final /* synthetic */ DBO $dbo;
                final /* synthetic */ LegacyMigrationContext this$0;
                {
                    this.$dbo = $dbo;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Tx invoke(@NotNull DBO it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$dbo.newTx(this.this$0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)tx, (String)"override fun getTx(dbo: \u2026dbo.newTx(this)\n        }");
            return tx;
        }

        @Override
        public void requestLock(@NotNull DBO dbo, @NotNull LockMode mode) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        }

        @Override
        public void signalEvent(@NotNull Operation.DataManagementOperation action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            throw new UnsupportedOperationException("Operation signalEvent() not supported for LegacyMigrationContext.");
        }

        @Override
        @NotNull
        public Flow<Record> execute(@NotNull Operator operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            throw new UnsupportedOperationException("Operation execute() not supported for LegacyMigrationContext.");
        }

        @Override
        public void commit() {
            if (!(this.getState() == TransactionStatus.IDLE)) {
                boolean $i$a$-check-AbstractMigrationManager$LegacyMigrationContext$commit$22 = false;
                String $i$a$-check-AbstractMigrationManager$LegacyMigrationContext$commit$22 = "Cannot commit transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw new IllegalStateException($i$a$-check-AbstractMigrationManager$LegacyMigrationContext$commit$22.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            for (Tx txn : CollectionsKt.reversed((Iterable)this.txns.values())) {
                txn.beforeCommit();
            }
            this.txns.clear();
            this.state = TransactionStatus.COMMIT;
        }

        @Override
        public void rollback() {
            if (!(this.getState() == TransactionStatus.IDLE || this.getState() == TransactionStatus.ERROR)) {
                boolean $i$a$-check-AbstractMigrationManager$LegacyMigrationContext$rollback$22 = false;
                String $i$a$-check-AbstractMigrationManager$LegacyMigrationContext$rollback$22 = "Cannot rollback transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw new IllegalStateException($i$a$-check-AbstractMigrationManager$LegacyMigrationContext$rollback$22.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            for (Tx txn : CollectionsKt.reversed((Iterable)this.txns.values())) {
                txn.beforeRollback();
            }
            this.txns.clear();
            this.state = TransactionStatus.ROLLBACK;
        }

        @Override
        public void kill() {
            throw new UnsupportedOperationException("Operation kill() not supported for LegacyMigrationContext.");
        }

        private static final Tx getTx$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Tx)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010$\u001a\u00020%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001cH\u0016J\b\u0010-\u001a\u00020%H\u0016J\u0018\u0010.\u001a\u00020%2\u0006\u0010,\u001a\u00020\u001c2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020%H\u0016J\u0010\u00102\u001a\u00020%2\u0006\u00103\u001a\u000204H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager$MigrationContext;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "xodusTx", "Ljetbrains/exodus/env/Transaction;", "(Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;Ljetbrains/exodus/env/Transaction;)V", "availableIntraQueryWorkers", "", "getAvailableIntraQueryWorkers", "()I", "availableQueryWorkers", "getAvailableQueryWorkers", "readonly", "", "getReadonly", "()Z", "<set-?>", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "txId", "", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "getTxId", "()J", "txns", "", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "Lorg/vitrivr/cottontail/dbms/general/Tx;", "type", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "getType", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "getXodusTx", "()Ljetbrains/exodus/env/Transaction;", "commit", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/core/basics/Record;", "operator", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "getTx", "dbo", "kill", "requestLock", "mode", "Lorg/vitrivr/cottontail/dbms/execution/locking/LockMode;", "rollback", "signalEvent", "action", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation;", "cottontaildb-dbms"})
    public final class MigrationContext
    implements TransactionContext,
    org.vitrivr.cottontail.dbms.execution.transactions.Transaction {
        @NotNull
        private final Transaction xodusTx;
        private final long txId;
        @NotNull
        private final TransactionType type;
        @NotNull
        private volatile TransactionStatus state;
        private final boolean readonly;
        private final int availableQueryWorkers;
        private final int availableIntraQueryWorkers;
        @NotNull
        private final Map<DBO, Tx> txns;

        public MigrationContext(Transaction xodusTx) {
            Intrinsics.checkNotNullParameter((Object)xodusTx, (String)"xodusTx");
            this.xodusTx = xodusTx;
            this.txId = AbstractMigrationManager.this.transactionIdCounter.getAndIncrement();
            this.type = TransactionType.SYSTEM;
            this.state = TransactionStatus.IDLE;
            Object2ObjectMap object2ObjectMap = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap, (String)"synchronize(Object2ObjectLinkedOpenHashMap())");
            this.txns = (Map)object2ObjectMap;
        }

        @Override
        @NotNull
        public Transaction getXodusTx() {
            return this.xodusTx;
        }

        @Override
        public long getTxId() {
            return this.txId;
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        @Override
        public boolean getReadonly() {
            return this.readonly;
        }

        @Override
        public int getAvailableQueryWorkers() {
            return this.availableQueryWorkers;
        }

        @Override
        public int getAvailableIntraQueryWorkers() {
            return this.availableIntraQueryWorkers;
        }

        @Override
        @NotNull
        public Tx getTx(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Tx tx = this.txns.computeIfAbsent(dbo, arg_0 -> MigrationContext.getTx$lambda$0((Function1)new Function1<DBO, Tx>(dbo, this){
                final /* synthetic */ DBO $dbo;
                final /* synthetic */ MigrationContext this$0;
                {
                    this.$dbo = $dbo;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Tx invoke(@NotNull DBO it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$dbo.newTx(this.this$0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)tx, (String)"override fun getTx(dbo: \u2026dbo.newTx(this)\n        }");
            return tx;
        }

        @Override
        public void requestLock(@NotNull DBO dbo, @NotNull LockMode mode) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        }

        @Override
        public void signalEvent(@NotNull Operation.DataManagementOperation action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        }

        @Override
        @NotNull
        public Flow<Record> execute(@NotNull Operator operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            throw new UnsupportedOperationException("Operation execute() not supported for MigrationContext.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            if (!(this.getState() == TransactionStatus.IDLE)) {
                boolean $i$a$-check-AbstractMigrationManager$MigrationContext$commit$22 = false;
                String $i$a$-check-AbstractMigrationManager$MigrationContext$commit$22 = "Cannot commit transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw new IllegalStateException($i$a$-check-AbstractMigrationManager$MigrationContext$commit$22.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            try {
                for (Tx txn : CollectionsKt.reversed((Iterable)this.txns.values())) {
                    try {
                        txn.beforeCommit();
                    }
                    catch (Throwable e) {
                        this.getXodusTx().abort();
                        throw e;
                    }
                }
                this.getXodusTx().commit();
            }
            finally {
                this.txns.clear();
                this.state = TransactionStatus.COMMIT;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() {
            if (!(this.getState() == TransactionStatus.IDLE || this.getState() == TransactionStatus.ERROR)) {
                boolean $i$a$-check-AbstractMigrationManager$MigrationContext$rollback$22 = false;
                String $i$a$-check-AbstractMigrationManager$MigrationContext$rollback$22 = "Cannot rollback transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw new IllegalStateException($i$a$-check-AbstractMigrationManager$MigrationContext$rollback$22.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            try {
                for (Tx txn : CollectionsKt.reversed((Iterable)this.txns.values())) {
                    try {
                        txn.beforeRollback();
                    }
                    catch (Throwable e) {
                        this.getXodusTx().abort();
                        throw e;
                    }
                }
                this.getXodusTx().abort();
            }
            finally {
                this.txns.clear();
                this.state = TransactionStatus.ROLLBACK;
            }
        }

        @Override
        public void kill() {
            throw new UnsupportedOperationException("Operation kill() not supported for MigrationContext.");
        }

        private static final Tx getTx$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Tx)$tmp0.invoke(p0);
        }
    }
}

