/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.legacy.v1.MigrationManagerV1;
import org.vitrivr.cottontail.legacy.v1.catalogue.CatalogueV1Header;
import org.vitrivr.cottontail.legacy.v2.MigrationManagerV2;
import org.vitrivr.cottontail.legacy.v2.catalogue.CatalogueV2Header;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/legacy/VersionProber;", "", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "isV1", "", "isV2", "isV3", "migrate", "", "probe", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "Companion", "cottontaildb-dbms"})
public final class VersionProber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private static final DBOVersion EXPECTED = DBOVersion.V3_0;

    public VersionProber(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final DBOVersion probe() {
        return this.isV3() ? DBOVersion.V3_0 : (this.isV2() ? DBOVersion.V2_0 : (this.isV1() ? DBOVersion.V1_0 : DBOVersion.UNDEFINED));
    }

    @ExperimentalTime
    public final void migrate() {
        if (this.isV2()) {
            Path path = this.config.getRoot().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.config.root.parent");
            new MigrationManagerV2(10000, path).migrate(this.config);
        } else if (this.isV1()) {
            Path path = this.config.getRoot().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.config.root.parent");
            new MigrationManagerV1(10000, path).migrate(this.config);
        } else {
            throw new IllegalStateException("Cannot migrate Cottontail DB from DB version " + (Object)((Object)this.probe()) + '.');
        }
    }

    private final boolean isV1() {
        CatalogueV1Header header;
        block5: {
            CatalogueV1Header catalogueV1Header;
            CottontailStoreWAL cottontailStoreWAL;
            System.gc();
            try {
                MapDBConfig mapDBConfig = this.config.getMapdb();
                Path path = this.config.getRoot().resolve("catalogue.db");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"config.root.resolve(CatalogueV1.FILE_CATALOGUE)");
                cottontailStoreWAL = mapDBConfig.store(path);
            }
            catch (Throwable e) {
                return false;
            }
            CottontailStoreWAL store = cottontailStoreWAL;
            try {
                CottontailStoreWAL cottontailStoreWAL2 = store;
                catalogueV1Header = cottontailStoreWAL2 != null ? (CatalogueV1Header)cottontailStoreWAL2.get(1L, CatalogueV1Header.Serializer) : null;
            }
            catch (Throwable e) {
                CottontailStoreWAL cottontailStoreWAL3 = store;
                if (cottontailStoreWAL3 != null) {
                    cottontailStoreWAL3.close();
                }
                return false;
            }
            header = catalogueV1Header;
            CottontailStoreWAL cottontailStoreWAL4 = store;
            if (cottontailStoreWAL4 == null) break block5;
            cottontailStoreWAL4.close();
        }
        return header != null;
    }

    private final boolean isV2() {
        CatalogueV2Header header;
        block5: {
            CatalogueV2Header catalogueV2Header;
            DB dB;
            System.gc();
            try {
                MapDBConfig mapDBConfig = this.config.getMapdb();
                Path path = this.config.getRoot().resolve("catalogue.db");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"config.root.resolve(CatalogueV2.FILE_CATALOGUE)");
                dB = mapDBConfig.db(path);
            }
            catch (Throwable e) {
                return false;
            }
            DB store = dB;
            try {
                DB dB2 = store;
                catalogueV2Header = dB2 != null && (dB2 = dB2.atomicVar("cdb_catalogue_header", (Serializer)CatalogueV2Header.Serializer)) != null && (dB2 = (Atomic.Var)dB2.open()) != null ? (CatalogueV2Header)dB2.get() : null;
            }
            catch (Throwable e) {
                DB dB3 = store;
                if (dB3 != null) {
                    dB3.close();
                }
                return false;
            }
            header = catalogueV2Header;
            DB dB4 = store;
            if (dB4 == null) break block5;
            dB4.close();
        }
        return header != null;
    }

    private final boolean isV3() {
        return Files.isDirectory(this.config.getRoot().resolve("xodus"), new LinkOption[0]);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/VersionProber$Companion;", "", "()V", "EXPECTED", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getEXPECTED", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DBOVersion getEXPECTED() {
            return EXPECTED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

