/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.catalogue;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.FunctionRegistry;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.legacy.v1.catalogue.CatalogueV1Header;
import org.vitrivr.cottontail.legacy.v1.schema.SchemaV1;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 92\u00020\u0001:\u00029:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016R\u0014\u0010\u0005\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006;"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "catalogue", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "functions", "Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "getFunctions", "()Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "header", "Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1Header;", "name", "Lorg/vitrivr/cottontail/core/database/Name$RootName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$RootName;", "parent", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getParent", "()Lorg/vitrivr/cottontail/dbms/general/DBO;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "size", "", "getSize", "()I", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class CatalogueV1
implements Catalogue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final Path path;
    @NotNull
    private final Name.RootName name;
    @Nullable
    private final DBO parent;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final CottontailStoreWAL store;
    @NotNull
    private final Map<Name.SchemaName, SchemaV1> registry;
    private volatile boolean closed;
    public static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final String FILE_CATALOGUE = "catalogue.db";

    public CatalogueV1(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.path = this.getConfig().getRoot();
        this.name = Name.RootName.INSTANCE;
        this.closeLock = new StampedLock();
        MapDBConfig mapDBConfig = this.getConfig().getMapdb();
        Path path = this.path.resolve(FILE_CATALOGUE);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.path.resolve(FILE_CATALOGUE)");
        this.store = mapDBConfig.store(path);
        Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(Object2ObjectOpenHashMap())");
        this.registry = map2;
        CatalogueV1Header header = this.getHeader();
        for (long sid : header.getSchemas()) {
            CatalogueV1Header.CatalogueEntry schema;
            if ((CatalogueV1Header.CatalogueEntry)this.store.get(sid, CatalogueV1Header.CatalogueEntry.Serializer) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open Cottontail DB catalogue entry!");
            }
            Path path2 = this.path.resolve("schema_" + schema.getName());
            if (!Files.exists(path2, new LinkOption[0])) {
                throw new DatabaseException.DataCorruptionException("Broken catalogue entry for schema '" + schema.getName() + "'. Path " + path2 + " does not exist!");
            }
            SchemaV1 s = new SchemaV1(Name.SchemaName.Companion.create(schema.getName()), this);
            this.registry.put(s.getName(), s);
        }
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public FunctionRegistry getFunctions() {
        throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Name.RootName getName() {
        return this.name;
    }

    @Override
    @Nullable
    public DBO getParent() {
        return this.parent;
    }

    private final CatalogueV1Header getHeader() {
        CatalogueV1Header catalogueV1Header = (CatalogueV1Header)this.store.get(1L, CatalogueV1Header.Serializer);
        if (catalogueV1Header == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open Cottontail DB catalogue header!");
        }
        return catalogueV1Header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        int n;
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            n = 0;
            n = this.getHeader().getSchemas().length;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return n;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public CatalogueTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-CatalogueV1$close$22 = false;
            Map<Name.SchemaName, SchemaV1> $this$forEach$iv = this.registry;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Name.SchemaName, SchemaV1>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Name.SchemaName, SchemaV1> element$iv;
                Map.Entry<Name.SchemaName, SchemaV1> entry = element$iv = iterator.next();
                boolean bl = false;
                SchemaV1 v = entry.getValue();
                v.close();
            }
            this.store.close();
            this.closed = true;
            Unit $i$a$-write-CatalogueV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "cleanup", "", "createSchema", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "dropSchema", "listSchemas", "", "schemaForName", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements CatalogueTx {
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = CatalogueV1.this.closeLock.readLock();
        }

        @Override
        @NotNull
        public Catalogue getDbo() {
            return CatalogueV1.this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Name.SchemaName> listSchemas() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CatalogueV1.this.registry.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SchemaV1 schemaV1 = (SchemaV1)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public SchemaV1 schemaForName(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            SchemaV1 schemaV1 = (SchemaV1)CatalogueV1.this.registry.get(name);
            if (schemaV1 == null) {
                throw new DatabaseException.SchemaDoesNotExistException(name);
            }
            return schemaV1;
        }

        @Override
        @NotNull
        public Schema createSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void cleanup() {
            CatalogueV1.this.closeLock.unlockRead(this.closeStamp);
        }
    }
}

