/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.column;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnEngine;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.legacy.v1.column.ColumnV1Header;
import org.vitrivr.cottontail.legacy.v1.entity.EntityV1;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializerFactory;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.MapDBSerializer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 7*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u000278B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00101\u001a\u000202H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00028\u0000042\u0006\u00105\u001a\u000206H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00069"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1;", "T", "Lorg/vitrivr/cottontail/core/values/types/Value;", "Lorg/vitrivr/cottontail/dbms/column/Column;", "Ljava/lang/AutoCloseable;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "parent", "Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;", "(Lorg/vitrivr/cottontail/core/database/Name$ColumnName;Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "columnDef", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumnDef$annotations", "()V", "getColumnDef", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "engine", "Lorg/vitrivr/cottontail/dbms/column/ColumnEngine;", "getEngine", "()Lorg/vitrivr/cottontail/dbms/column/ColumnEngine;", "header", "Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1Header;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class ColumnV1<T extends Value>
implements Column<T>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.ColumnName name;
    @NotNull
    private final EntityV1 parent;
    @NotNull
    private final Path path;
    @NotNull
    private CottontailStoreWAL store;
    @NotNull
    private final ColumnDef<T> columnDef;
    private volatile boolean closed;
    @NotNull
    private final StampedLock closeLock;
    private static final long HEADER_RECORD_ID = 1L;

    /*
     * WARNING - void declaration
     */
    public ColumnV1(@NotNull Name.ColumnName name, @NotNull EntityV1 parent) {
        void it;
        CottontailStoreWAL cottontailStoreWAL;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        Path path = this.getParent().getPath().resolve("col_" + this.getName().getSimple() + ".db");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parent.path.resolve(\"col_${name.simple}.db\")");
        this.path = path;
        ColumnV1 columnV1 = this;
        try {
            ColumnV1 columnV12 = columnV1;
            cottontailStoreWAL = this.getParent().getParent().getParent().getConfig().getMapdb().store(this.path);
        }
        catch (DBException dBException) {
            void e;
            ColumnV1 columnV13 = columnV1;
            throw new DatabaseException("Failed to open column at '" + this.path + "': " + e.getMessage() + '\'', null, 2, null);
        }
        columnV12.store = cottontailStoreWAL;
        ColumnV1Header e = this.getHeader();
        columnV1 = this;
        boolean bl = false;
        Name.ColumnName columnName = this.getName();
        Types<?> types = it.getType();
        Intrinsics.checkNotNull(types, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.Types<T of org.vitrivr.cottontail.legacy.v1.column.ColumnV1.columnDef$lambda$0>");
        columnV1.columnDef = new ColumnDef(columnName, types, it.getNullable(), false, 8, null);
        this.closeLock = new StampedLock();
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public EntityV1 getParent() {
        return this.parent;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    private final ColumnV1Header getHeader() {
        ColumnV1Header columnV1Header = (ColumnV1Header)this.store.get(1L, ColumnV1Header.Serializer);
        if (columnV1Header == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open header of column '" + this.getName() + "'!'");
        }
        return columnV1Header;
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    public static /* synthetic */ void getColumnDef$annotations() {
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @NotNull
    public final ColumnEngine getEngine() {
        return ColumnEngine.MAPDB;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-ColumnV1$close$22 = false;
            this.store.close();
            this.closed = true;
            Unit $i$a$-write-ColumnV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public ColumnTx<T> newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    @NotNull
    public Types<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1$Companion;", "", "()V", "HEADER_RECORD_ID", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J#\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0007j\u0002`\u00152\b\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0014\u0010\u001b\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0007j\u0002`\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001eH\u0016J\u0018\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0017\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\u0004\u0018\u00018\u00002\n\u0010\u0014\u001a\u00060\u0007j\u0002`\u0015H\u0016\u00a2\u0006\u0002\u0010\"J\f\u0010$\u001a\u00060\u0007j\u0002`\u0015H\u0016J\u0010\u0010%\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00150&J\u0018\u0010%\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00150&2\u0006\u0010'\u001a\u00020 J\f\u0010(\u001a\u00060\u0007j\u0002`\u0015H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*H\u0016J!\u0010+\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "columnDef", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumnDef", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "dbo", "Lorg/vitrivr/cottontail/dbms/column/Column;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/column/Column;", "serializer", "Lorg/vitrivr/cottontail/storage/serializers/values/mapdb/MapDBSerializer;", "add", "", "tupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "value", "(JLorg/vitrivr/cottontail/core/values/types/Value;)Z", "cleanup", "", "clear", "contains", "count", "cursor", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "partition", "Lkotlin/ranges/LongRange;", "delete", "(J)Lorg/vitrivr/cottontail/core/values/types/Value;", "get", "largestTupleId", "scan", "", "range", "smallestTupleId", "statistics", "Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "update", "(JLorg/vitrivr/cottontail/core/values/types/Value;)Lorg/vitrivr/cottontail/core/values/types/Value;", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements ColumnTx<T> {
        @NotNull
        private final MapDBSerializer<T> serializer;
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.serializer = ValueSerializerFactory.INSTANCE.mapdb(ColumnV1.this.getType());
            this.closeStamp = ColumnV1.this.closeLock.readLock();
            if (ColumnV1.this.getClosed()) {
                ColumnV1.this.closeLock.unlockRead(this.closeStamp);
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), ColumnV1.this);
            }
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnV1.this.getColumnDef();
        }

        @Override
        @NotNull
        public Column<T> getDbo() {
            return ColumnV1.this;
        }

        @Override
        @Nullable
        public T get(long tupleId) {
            return (Value)ColumnV1.this.store.get(tupleId, this.serializer);
        }

        @Override
        public long count() {
            return ColumnV1.this.getHeader().getCount();
        }

        @Override
        public long smallestTupleId() {
            return 1L;
        }

        @Override
        public long largestTupleId() {
            return ColumnV1.this.store.getMaxRecid();
        }

        @NotNull
        public final Iterator<Long> scan() {
            return this.scan(new LongRange(this.smallestTupleId(), this.largestTupleId()));
        }

        @NotNull
        public final Iterator<Long> scan(@NotNull LongRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new Iterator<Long>(ColumnV1.this, range){
                @NotNull
                private final CottontailStoreWAL.RecordIdIterator wrapped;
                {
                    this.wrapped = new CottontailStoreWAL.RecordIdIterator(ColumnV1.access$getStore$p($receiver), $range);
                }

                @NotNull
                public Long next() {
                    return this.wrapped.next();
                }

                public boolean hasNext() {
                    return this.wrapped.hasNext();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        public boolean contains(long tupleId) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public boolean add(long tupleId, @Nullable T value) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @Nullable
        public T update(long tupleId, @Nullable T value) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @Nullable
        public T delete(long tupleId) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @NotNull
        public ValueStatistics<T> statistics() {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void cleanup() {
            ColumnV1.this.closeLock.unlockRead(this.closeStamp);
        }

        @Override
        @NotNull
        public Cursor<T> cursor() {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @NotNull
        public Cursor<T> cursor(@NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }
    }
}

