/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.index.Index;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.legacy.v1.column.ColumnV1;
import org.vitrivr.cottontail.legacy.v1.entity.BrokenIndexV1;
import org.vitrivr.cottontail.legacy.v1.entity.EntityV1Header;
import org.vitrivr.cottontail.legacy.v1.entity.IndexV1Entry;
import org.vitrivr.cottontail.legacy.v1.schema.SchemaV1;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u00012\u00020\u0002:\u000223B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010,\u001a\u00020-H\u0016J\u0014\u0010.\u001a\u00060/R\u00020\u00002\u0006\u00100\u001a\u000201H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00064"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "Ljava/lang/AutoCloseable;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "parent", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "columns", "", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1;", "header", "Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1Header;", "indexes", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "Lorg/vitrivr/cottontail/dbms/index/Index;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "getParent", "()Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1$Tx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class EntityV1
implements Entity,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.EntityName name;
    @NotNull
    private final SchemaV1 parent;
    @NotNull
    private final Path path;
    @NotNull
    private final CottontailStoreWAL store;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final Map<Name.ColumnName, ColumnV1<?>> columns;
    @NotNull
    private final Map<Name.IndexName, Index> indexes;
    private volatile boolean closed;
    @NotNull
    public static final String FILE_CATALOGUE = "index.db";
    public static final long HEADER_RECORD_ID = 1L;

    /*
     * WARNING - void declaration
     */
    public EntityV1(@NotNull Name.EntityName name, @NotNull SchemaV1 parent) {
        void $this$mapTo$iv$iv;
        CottontailStoreWAL cottontailStoreWAL;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        Path path = this.getParent().getPath().resolve("entity_" + this.getName().getSimple());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.parent.path.resolve(\"entity_${name.simple}\")");
        this.path = path;
        Object object = this;
        try {
            EntityV1 entityV1 = object;
            MapDBConfig mapDBConfig = this.getParent().getParent().getConfig().getMapdb();
            Path path2 = this.path.resolve(FILE_CATALOGUE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.path.resolve(FILE_CATALOGUE)");
            cottontailStoreWAL = mapDBConfig.store(path2);
        }
        catch (DBException dBException) {
            void e;
            EntityV1 entityV1 = object;
            throw new DatabaseException("Failed to open entity '" + this.getName() + "': " + e.getMessage() + "'.", null, 2, null);
        }
        entityV1.store = cottontailStoreWAL;
        this.closeLock = new StampedLock();
        this.columns = (Map)new Object2ObjectLinkedOpenHashMap();
        this.indexes = (Map)new Object2ObjectOpenHashMap();
        long[] $this$map$iv = this.getHeader().getColumns();
        boolean $i$f$map = false;
        long[] lArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_17 = item$iv$iv = $this$mapTo$iv$iv[i];
            object = destination$iv$iv;
            boolean bl = false;
            Name.EntityName entityName = this.getName();
            GroupSerializer groupSerializer = Serializer.STRING;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"STRING");
            String string = (String)this.store.get((long)it, (Serializer)groupSerializer);
            if (string == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open entity '" + this.getName() + "': Could not read column definition at position " + (long)it + '!');
            }
            Name.ColumnName columnName = entityName.column(string);
            this.columns.put(columnName, new ColumnV1(columnName, this));
            object.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        long[] $this$forEach$iv = this.getHeader().getIndexes();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i = 0; i < n2; ++i) {
            IndexV1Entry indexEntry;
            long element$iv;
            long idx = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if ((IndexV1Entry)this.store.get(idx, IndexV1Entry.Serializer) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open entity '" + this.getName() + "': Could not read index definition at position " + idx + '!');
            }
            Name.IndexName indexName = this.getName().index(indexEntry.getName());
            Map<Name.IndexName, Index> map2 = this.indexes;
            Name.IndexName indexName2 = this.getName().index(indexEntry.getName());
            Entity entity = this;
            Path path3 = this.path.resolve(indexEntry.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.path.resolve(indexEntry.name)");
            BrokenIndexV1 brokenIndexV1 = new BrokenIndexV1(indexName2, entity, path3, indexEntry.getType());
            map2.put(indexName, brokenIndexV1);
        }
    }

    @Override
    @NotNull
    public Name.EntityName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public SchemaV1 getParent() {
        return this.parent;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    private final EntityV1Header getHeader() {
        EntityV1Header entityV1Header = (EntityV1Header)this.store.get(1L, EntityV1Header.Serializer);
        if (entityV1Header == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open header of entity '" + this.getName() + "'!");
        }
        return entityV1Header;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-EntityV1$close$22 = false;
            if (!this.getClosed()) {
                Iterable $this$forEach$iv = this.columns.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ColumnV1 it = (ColumnV1)element$iv;
                    boolean bl = false;
                    it.close();
                }
                this.store.close();
                this.closed = true;
            }
            Unit $i$a$-write-EntityV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0007j\u0002`\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J%\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0#H\u0016\u00a2\u0006\u0002\u0010%J-\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0#2\u0006\u0010&\u001a\u00020'H\u0016\u00a2\u0006\u0002\u0010(J\u0014\u0010)\u001a\u00020\r2\n\u0010\u0014\u001a\u00060\u0007j\u0002`\u0015H\u0016J\u0010\u0010*\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u0014\u0010,\u001a\u00060\u0007j\u0002`\u00152\u0006\u0010-\u001a\u00020\"H\u0016J\f\u0010.\u001a\u00060\u0007j\u0002`\u0015H\u0016J\u0012\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0\u001dH\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0016J\b\u00101\u001a\u00020\rH\u0016J+\u00102\u001a\u00020\"2\n\u0010\u0014\u001a\u00060\u0007j\u0002`\u00152\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0#H\u0016\u00a2\u0006\u0002\u00103J\f\u00104\u001a\u00060\u0007j\u0002`\u0015H\u0016J\u0010\u00105\u001a\u00020\r2\u0006\u0010-\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u00066"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/entity/EntityTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/entity/Entity;", "cleanup", "", "columnForName", "Lorg/vitrivr/cottontail/dbms/column/Column;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "contains", "", "tupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "count", "createIndex", "Lorg/vitrivr/cottontail/dbms/index/Index;", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "columns", "", "configuration", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "cursor", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/basics/Record;", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/core/basics/Cursor;", "partition", "Lkotlin/ranges/LongRange;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;Lkotlin/ranges/LongRange;)Lorg/vitrivr/cottontail/core/basics/Cursor;", "delete", "dropIndex", "indexForName", "insert", "record", "largestTupleId", "listColumns", "listIndexes", "optimize", "read", "(J[Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/core/basics/Record;", "smallestTupleId", "update", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements EntityTx {
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = EntityV1.this.closeLock.readLock();
            if (EntityV1.this.getClosed()) {
                EntityV1.this.closeLock.unlockRead(this.closeStamp);
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), EntityV1.this);
            }
        }

        @Override
        @NotNull
        public Entity getDbo() {
            return EntityV1.this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> listColumns() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = EntityV1.this.columns.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColumnV1 columnV1 = (ColumnV1)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getColumnDef());
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Column<?> columnForName(@NotNull Name.ColumnName name) {
            ColumnV1 columnV1;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            EntityV1 entityV1 = EntityV1.this;
            lock2.lock();
            try {
                ColumnV1 columnV12;
                boolean bl = false;
                if (!name.getWildcard()) {
                    columnV12 = (ColumnV1)entityV1.columns.get(name);
                    if (columnV12 == null) {
                        throw new DatabaseException.ColumnDoesNotExistException(name);
                    }
                } else {
                    Name.ColumnName fqn = entityV1.getName().column(name.getSimple());
                    columnV12 = (ColumnV1)entityV1.columns.get(fqn);
                    if (columnV12 == null) {
                        throw new DatabaseException.ColumnDoesNotExistException(fqn);
                    }
                }
                columnV1 = columnV12;
            }
            finally {
                lock2.unlock();
            }
            return columnV1;
        }

        @Override
        @NotNull
        public List<Name.IndexName> listIndexes() {
            return CollectionsKt.toList((Iterable)EntityV1.this.indexes.keySet());
        }

        @Override
        @NotNull
        public Index indexForName(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Index index = (Index)EntityV1.this.indexes.get(name);
            if (index == null) {
                throw new DatabaseException.IndexDoesNotExistException((Name)name);
            }
            return index;
        }

        @Override
        public long smallestTupleId() {
            org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx((DBO)CollectionsKt.first((Iterable)EntityV1.this.columns.values()));
            Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.legacy.v1.column.ColumnV1.Tx<*>");
            ColumnV1.Tx columnTx = (ColumnV1.Tx)tx;
            return columnTx.smallestTupleId();
        }

        @Override
        public long largestTupleId() {
            org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx((DBO)CollectionsKt.first((Iterable)EntityV1.this.columns.values()));
            Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.legacy.v1.column.ColumnV1.Tx<*>");
            ColumnV1.Tx columnTx = (ColumnV1.Tx)tx;
            return columnTx.largestTupleId();
        }

        @Override
        public boolean contains(long tupleId) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @NotNull
        public Index createIndex(@NotNull Name.IndexName name, @NotNull IndexType type, @NotNull List<Name.ColumnName> columns, @NotNull IndexConfig<?> configuration) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropIndex(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void optimize() {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @NotNull
        public Record read(long tupleId, @NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @NotNull
        public Cursor<Record> cursor(@NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            return this.cursor(columns, new LongRange(this.smallestTupleId(), this.largestTupleId()));
        }

        @NotNull
        public Cursor<Record> cursor(@NotNull ColumnDef<?>[] columns, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            return (Cursor)new Cursor<Record>(this, EntityV1.this, partition, columns){
                @NotNull
                private final Iterator<Long> wrapped;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ EntityV1 this$1;
                final /* synthetic */ ColumnDef<?>[] $columns;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$columns = $columns;
                    org.vitrivr.cottontail.dbms.general.Tx tx = $receiver.getContext().getTx((DBO)CollectionsKt.first((Iterable)EntityV1.access$getColumns$p($receiver2).values()));
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.legacy.v1.column.ColumnV1.Tx<*>");
                    this.wrapped = ((ColumnV1.Tx)tx).scan($partition);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public Record value() {
                    void $this$toTypedArray$iv;
                    void $this$mapTo$iv$iv;
                    Collection $this$map$iv;
                    long tupleId = ((Number)this.wrapped.next()).longValue();
                    ColumnDef<?>[] columnDefArray = this.$columns;
                    EntityV1 entityV1 = this.this$1;
                    Tx tx = this.this$0;
                    boolean $i$f$map = false;
                    void var8_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        ColumnV1 column;
                        void it;
                        void item$iv$iv;
                        void var14_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        if ((ColumnV1)EntityV1.access$getColumns$p(entityV1).get(it.getName()) == null) {
                            throw new IllegalArgumentException("Column " + it + " does not exist on entity " + entityV1.getName() + '.');
                        }
                        org.vitrivr.cottontail.dbms.general.Tx tx2 = tx.getContext().getTx(column);
                        Intrinsics.checkNotNull((Object)tx2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                        collection.add(((ColumnTx)tx2).get(tupleId));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
                    Intrinsics.checkNotNull((Object)valueArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    Value[] values = valueArray;
                    return (Record)new StandaloneRecord(tupleId, this.$columns, values);
                }

                public long key() {
                    return ((Number)this.wrapped.next()).longValue();
                }

                public boolean moveNext() {
                    return this.wrapped.hasNext();
                }

                public void close() {
                }

                public boolean hasNext() {
                    return Cursor.DefaultImpls.hasNext((Cursor)this);
                }

                @NotNull
                public Record next() {
                    return (Record)Cursor.DefaultImpls.next((Cursor)this);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        public long count() {
            return EntityV1.this.getHeader().getSize();
        }

        public long insert(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        public void update(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        public void delete(long tupleId) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void cleanup() {
            EntityV1.this.closeLock.unlockRead(this.closeStamp);
        }
    }
}

