/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.schema;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;
import org.vitrivr.cottontail.legacy.v1.catalogue.CatalogueV1;
import org.vitrivr.cottontail.legacy.v1.entity.EntityV1;
import org.vitrivr.cottontail.legacy.v1.schema.SchemaV1;
import org.vitrivr.cottontail.legacy.v1.schema.SchemaV1Header;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u00012\u00020\u0002:\u000201B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00062"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "Ljava/lang/AutoCloseable;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "parent", "Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;", "(Lorg/vitrivr/cottontail/core/database/Name$SchemaName;Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "header", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1Header;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "getParent", "()Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;", "path", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class SchemaV1
implements Schema,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.SchemaName name;
    @NotNull
    private final CatalogueV1 parent;
    private final Path path;
    @NotNull
    private final CottontailStoreWAL store;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final Map<Name.EntityName, EntityV1> registry;
    private volatile boolean closed;
    public static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final String FILE_CATALOGUE = "index.db";

    /*
     * WARNING - void declaration
     */
    public SchemaV1(@NotNull Name.SchemaName name, @NotNull CatalogueV1 parent) {
        void $this$mapTo$iv$iv;
        CottontailStoreWAL cottontailStoreWAL;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        this.path = this.getParent().getPath().resolve("schema_" + this.getName().getSimple());
        Object object = this;
        try {
            SchemaV1 schemaV1 = object;
            MapDBConfig mapDBConfig = this.getParent().getConfig().getMapdb();
            Path path = this.path.resolve(FILE_CATALOGUE);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.path.resolve(FILE_CATALOGUE)");
            cottontailStoreWAL = mapDBConfig.store(path);
        }
        catch (DBException dBException) {
            void e;
            SchemaV1 schemaV1 = object;
            throw new DatabaseException("Failed to open schema " + this.getName() + " at '" + this.path + "': " + e.getMessage() + '\'', null, 2, null);
        }
        schemaV1.store = cottontailStoreWAL;
        this.closeLock = new StampedLock();
        Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(Object2ObjectOpenHashMap())");
        this.registry = map2;
        long[] $this$map$iv = this.getHeader().getEntities();
        boolean $i$f$map = false;
        long[] lArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            object = destination$iv$iv;
            boolean bl = false;
            Name.SchemaName schemaName = this.getName();
            GroupSerializer groupSerializer = Serializer.STRING;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"STRING");
            String string = (String)this.store.get((long)it, (Serializer)groupSerializer);
            if (string == null) {
                throw new DatabaseException.DataCorruptionException("Failed to read schema " + this.getName() + " (" + this.path + "): Could not find entity name of ID " + (long)it + '.');
            }
            Name.EntityName name2 = schemaName.entity(string);
            this.registry.put(name2, new EntityV1(name2, this));
            object.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Name.SchemaName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public CatalogueV1 getParent() {
        return this.parent;
    }

    public final Path getPath() {
        return this.path;
    }

    private final SchemaV1Header getHeader() {
        SchemaV1Header schemaV1Header = (SchemaV1Header)this.store.get(1L, SchemaV1Header.Serializer);
        if (schemaV1Header == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open header of schema " + this.getName() + '!');
        }
        return schemaV1Header;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public SchemaTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean $i$a$-read-SchemaV1$close$22 = false;
            if (!this.getClosed()) {
                this.registry.entrySet().removeIf(arg_0 -> SchemaV1.close$lambda$2$lambda$1(close.1.1.INSTANCE, arg_0));
                this.store.close();
                this.closed = true;
            }
            Unit $i$a$-read-SchemaV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    private static final boolean close$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J1\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013\"\u0006\u0012\u0002\b\u00030\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/general/DBO;", "cleanup", "", "createEntity", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;[Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "dropEntity", "entityForName", "Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;", "listEntities", "", "truncateEntity", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements SchemaTx {
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = SchemaV1.this.closeLock.readLock();
        }

        @Override
        @NotNull
        public DBO getDbo() {
            return SchemaV1.this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Name.EntityName> listEntities() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = SchemaV1.this.registry.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EntityV1 entityV1 = (EntityV1)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        @Override
        @NotNull
        public EntityV1 entityForName(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            EntityV1 entityV1 = (EntityV1)SchemaV1.this.registry.get(name);
            if (entityV1 == null) {
                throw new DatabaseException.EntityDoesNotExistException(name);
            }
            return entityV1;
        }

        @Override
        @NotNull
        public DefaultEntity createEntity(@NotNull Name.EntityName name, ColumnDef<?> ... columns) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void truncateEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void cleanup() {
            SchemaV1.this.closeLock.unlockRead(this.closeStamp);
        }
    }
}

