/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v2;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.legacy.AbstractMigrationManager;
import org.vitrivr.cottontail.legacy.v2.catalogue.CatalogueV2;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/MigrationManagerV2;", "Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;", "batchSize", "", "logFile", "Ljava/nio/file/Path;", "(ILjava/nio/file/Path;)V", "from", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getFrom", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "openDestinationCatalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "config", "Lorg/vitrivr/cottontail/config/Config;", "openSourceCatalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "cottontaildb-dbms"})
@ExperimentalTime
public final class MigrationManagerV2
extends AbstractMigrationManager {
    @NotNull
    private final DBOVersion from;

    public MigrationManagerV2(int batchSize, @NotNull Path logFile) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        super(batchSize, logFile);
        this.from = DBOVersion.V2_0;
    }

    public /* synthetic */ MigrationManagerV2(int n, Path path, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1000000;
        }
        if ((n2 & 2) != 0) {
            Path path2 = Paths.get(".", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(\".\")");
            path = path2;
        }
        this(n, path);
    }

    @Override
    @NotNull
    public DBOVersion getFrom() {
        return this.from;
    }

    @Override
    @Nullable
    public Catalogue openSourceCatalogue(@NotNull Config config) {
        Catalogue catalogue;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        try {
            catalogue = new CatalogueV2(config);
        }
        catch (Throwable e) {
            catalogue = null;
        }
        return catalogue;
    }

    @Override
    @Nullable
    public DefaultCatalogue openDestinationCatalogue(@NotNull Config config) {
        DefaultCatalogue defaultCatalogue;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        try {
            defaultCatalogue = new DefaultCatalogue(config);
        }
        catch (Throwable e) {
            defaultCatalogue = null;
        }
        return defaultCatalogue;
    }

    public MigrationManagerV2() {
        this(0, null, 3, null);
    }
}

