/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v2.catalogue;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.FunctionRegistry;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.legacy.v2.catalogue.CatalogueV2Header;
import org.vitrivr.cottontail.legacy.v2.schema.SchemaV2;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 72\u00020\u0001:\u000278B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00101\u001a\u000202H\u0016J\u0014\u00103\u001a\u000604R\u00020\u00002\u0006\u00105\u001a\u000206H\u0016R\u0014\u0010\u0005\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00069"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2;", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "catalogue", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "functions", "Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "getFunctions", "()Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2Header;", "name", "Lorg/vitrivr/cottontail/core/database/Name$RootName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$RootName;", "parent", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getParent", "()Lorg/vitrivr/cottontail/dbms/general/DBO;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaV2;", "size", "", "getSize", "()I", "store", "Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2$Tx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class CatalogueV2
implements Catalogue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final Path path;
    @Nullable
    private final DBO parent;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final DB store;
    @NotNull
    private final Atomic.Var<CatalogueV2Header> headerField;
    @NotNull
    private final Map<Name.SchemaName, SchemaV2> registry;
    @NotNull
    public static final String CATALOGUE_HEADER_FIELD = "cdb_catalogue_header";
    @NotNull
    public static final String FILE_CATALOGUE = "catalogue.db";

    public CatalogueV2(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.path = this.getConfig().getRoot();
        this.closeLock = new StampedLock();
        MapDBConfig mapDBConfig = this.getConfig().getMapdb();
        Path path = this.path.resolve(FILE_CATALOGUE);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.path.resolve(FILE_CATALOGUE)");
        this.store = mapDBConfig.db(path);
        this.headerField = (Atomic.Var)this.store.atomicVar(CATALOGUE_HEADER_FIELD, (Serializer)CatalogueV2Header.Serializer).createOrOpen();
        Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(Object2ObjectOpenHashMap())");
        this.registry = map2;
        if (this.headerField.get() == null) {
            this.headerField.set((Object)new CatalogueV2Header(null, 0L, 0L, null, 15, null));
            this.store.commit();
        }
        for (CatalogueV2Header.SchemaRef schemaRef : ((CatalogueV2Header)this.headerField.get()).getSchemas()) {
            if (schemaRef.getPath() != null && Files.exists(schemaRef.getPath(), new LinkOption[0])) {
                this.registry.put(Name.SchemaName.Companion.create(schemaRef.getName()), new SchemaV2(this.path, this));
                continue;
            }
            Path path2 = this.path.resolve("schema_" + schemaRef.getName());
            if (!Files.exists(path2, new LinkOption[0])) {
                throw new DatabaseException.DataCorruptionException("Broken catalogue entry for schema '" + schemaRef.getName() + "'. Path " + path2 + " does not exist!");
            }
            Name.SchemaName schemaName = Name.SchemaName.Companion.create(schemaRef.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            this.registry.put(schemaName, new SchemaV2(path2, this));
        }
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Name.RootName getName() {
        return Name.RootName.INSTANCE;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    @Nullable
    public DBO getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public FunctionRegistry getFunctions() {
        throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        int n;
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            n = 0;
            n = ((CatalogueV2Header)this.headerField.get()).getSchemas().size();
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return n;
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-CatalogueV2$close$22 = false;
            this.store.close();
            Map<Name.SchemaName, SchemaV2> $this$forEach$iv = this.registry;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Name.SchemaName, SchemaV2>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Name.SchemaName, SchemaV2> element$iv;
                Map.Entry<Name.SchemaName, SchemaV2> entry = element$iv = iterator.next();
                boolean bl = false;
                SchemaV2 v = entry.getValue();
                v.close();
            }
            Unit $i$a$-write-CatalogueV2$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2$Companion;", "", "()V", "CATALOGUE_HEADER_FIELD", "", "FILE_CATALOGUE", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2;", "getDbo", "()Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2;", "cleanup", "", "createSchema", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "dropSchema", "listSchemas", "", "schemaForName", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements CatalogueTx {
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = CatalogueV2.this.closeLock.readLock();
            if (CatalogueV2.this.getClosed()) {
                CatalogueV2.this.closeLock.unlockRead(this.closeStamp);
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), CatalogueV2.this);
            }
        }

        @Override
        @NotNull
        public CatalogueV2 getDbo() {
            return CatalogueV2.this;
        }

        @Override
        @NotNull
        public List<Name.SchemaName> listSchemas() {
            return CollectionsKt.toList((Iterable)CatalogueV2.this.registry.keySet());
        }

        @Override
        @NotNull
        public Schema schemaForName(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            SchemaV2 schemaV2 = (SchemaV2)CatalogueV2.this.registry.get(name);
            if (schemaV2 == null) {
                throw new DatabaseException.SchemaDoesNotExistException(name);
            }
            return schemaV2;
        }

        @Override
        @NotNull
        public Schema createSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void cleanup() {
            CatalogueV2.this.closeLock.unlockRead(this.closeStamp);
        }
    }
}

