/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v2.column;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnEngine;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.legacy.v2.column.ColumnV2Header;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializerFactory;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.MapDBSerializer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u000267B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00100\u001a\u000201H\u0016J\u001a\u00102\u001a\f03R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u000205H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00068"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/column/ColumnV2;", "T", "Lorg/vitrivr/cottontail/core/values/types/Value;", "Lorg/vitrivr/cottontail/dbms/column/Column;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/dbms/entity/Entity;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "columnDef", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumnDef$annotations", "()V", "getColumnDef", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "engine", "Lorg/vitrivr/cottontail/dbms/column/ColumnEngine;", "getEngine", "()Lorg/vitrivr/cottontail/dbms/column/ColumnEngine;", "header", "Lorg/vitrivr/cottontail/legacy/v2/column/ColumnV2Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v2/column/ColumnV2Header;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/entity/Entity;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/legacy/v2/column/ColumnV2$Tx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class ColumnV2<T extends Value>
implements Column<T>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final Entity parent;
    @NotNull
    private CottontailStoreWAL store;
    @NotNull
    private final ColumnDef<T> columnDef;
    @NotNull
    private final StampedLock closeLock;
    private static final long RECORD_ID_TUPLE_ID_SHIFT = 2L;
    private static final long HEADER_RECORD_ID = 1L;

    /*
     * WARNING - void declaration
     */
    public ColumnV2(@NotNull Path path, @NotNull Entity parent) {
        CottontailStoreWAL cottontailStoreWAL;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        ColumnV2 columnV2 = this;
        try {
            ColumnV2 columnV22 = columnV2;
            cottontailStoreWAL = this.getParent().getParent().getParent().getConfig().getMapdb().store(this.path);
        }
        catch (DBException dBException) {
            void e;
            ColumnV2 columnV23 = columnV2;
            throw new DatabaseException("Failed to open column at '" + this.path + "': " + e.getMessage() + '\'', null, 2, null);
        }
        columnV22.store = cottontailStoreWAL;
        ColumnDef<?> columnDef2 = this.getHeader().getColumnDef();
        Intrinsics.checkNotNull(columnDef2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.database.ColumnDef<T of org.vitrivr.cottontail.legacy.v2.column.ColumnV2>");
        this.columnDef = columnDef2;
        this.closeLock = new StampedLock();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    private final ColumnV2Header getHeader() {
        ColumnV2Header columnV2Header = (ColumnV2Header)this.store.get(1L, ColumnV2Header.Serializer);
        if (columnV2Header == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open header of column '" + this.getName() + "'!'");
        }
        return columnV2Header;
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    public static /* synthetic */ void getColumnDef$annotations() {
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.getColumnDef().getName();
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @NotNull
    public final ColumnEngine getEngine() {
        return ColumnEngine.MAPDB;
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            this.store.close();
        }
    }

    @Override
    @NotNull
    public Types<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/column/ColumnV2$Companion;", "", "()V", "HEADER_RECORD_ID", "", "RECORD_ID_TUPLE_ID_SHIFT", "initialize", "", "path", "Ljava/nio/file/Path;", "column", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "config", "Lorg/vitrivr/cottontail/config/MapDBConfig;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public final void initialize(@NotNull Path path, @NotNull ColumnDef<?> column, @NotNull MapDBConfig config) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (Files.exists(path, new LinkOption[0])) {
                throw new DatabaseException.InvalidFileException("Could not initialize column " + column.getName() + ". A file already exists under " + path + '.');
            }
            CottontailStoreWAL store = config.store(path);
            store.put(new ColumnV2Header(column, 0L, 0L, 0L, 14, null), ColumnV2Header.Serializer);
            store.commit();
            store.close();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J#\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0007j\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0014\u0010\u0017\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0007j\u0002`\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001aH\u0016J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0017\u0010\u001d\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u001eJ\f\u0010 \u001a\u00060\u0007j\u0002`\u0011H\u0016J\u0010\u0010!\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00110\"J\u0018\u0010!\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00110\"2\u0006\u0010#\u001a\u00020\u001cJ\f\u0010$\u001a\u00060\u0007j\u0002`\u0011H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016J!\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/column/ColumnV2$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v2/column/ColumnV2;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/column/Column;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/column/Column;", "serializer", "Lorg/vitrivr/cottontail/storage/serializers/values/mapdb/MapDBSerializer;", "add", "", "tupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "value", "(JLorg/vitrivr/cottontail/core/values/types/Value;)Z", "cleanup", "", "clear", "contains", "count", "cursor", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "partition", "Lkotlin/ranges/LongRange;", "delete", "(J)Lorg/vitrivr/cottontail/core/values/types/Value;", "get", "largestTupleId", "scan", "", "range", "smallestTupleId", "statistics", "Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "update", "(JLorg/vitrivr/cottontail/core/values/types/Value;)Lorg/vitrivr/cottontail/core/values/types/Value;", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements ColumnTx<T> {
        @NotNull
        private final MapDBSerializer<T> serializer;
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.serializer = ValueSerializerFactory.INSTANCE.mapdb(ColumnV2.this.getType());
            this.closeStamp = ColumnV2.this.closeLock.readLock();
            if (ColumnV2.this.getClosed()) {
                ColumnV2.this.closeLock.unlockRead(this.closeStamp);
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), ColumnV2.this);
            }
        }

        @Override
        @NotNull
        public Column<T> getDbo() {
            return ColumnV2.this;
        }

        @Override
        @Nullable
        public T get(long tupleId) {
            return (Value)ColumnV2.this.store.get(tupleId + 2L, this.serializer);
        }

        @Override
        public long count() {
            return ColumnV2.this.getHeader().getCount();
        }

        @Override
        public long smallestTupleId() {
            return 1L;
        }

        @Override
        public long largestTupleId() {
            return ColumnV2.this.store.getMaxRecid();
        }

        @NotNull
        public final Iterator<Long> scan() {
            return this.scan(new LongRange(this.smallestTupleId(), this.largestTupleId()));
        }

        @NotNull
        public final Iterator<Long> scan(@NotNull LongRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new Iterator<Long>(ColumnV2.this, range){
                @NotNull
                private final CottontailStoreWAL.RecordIdIterator wrapped;
                {
                    this.wrapped = new CottontailStoreWAL.RecordIdIterator(ColumnV2.access$getStore$p($receiver), new LongRange($range.getFirst() + 2L, $range.getLast() + 2L));
                }

                public boolean hasNext() {
                    return this.wrapped.hasNext();
                }

                @NotNull
                public Long next() {
                    return this.wrapped.next() - 2L;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        public boolean contains(long tupleId) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public boolean add(long tupleId, @Nullable T value) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @Nullable
        public T update(long tupleId, @Nullable T value) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @Nullable
        public T delete(long tupleId) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @NotNull
        public ValueStatistics<T> statistics() {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void cleanup() {
            ColumnV2.this.closeLock.unlockRead(this.closeStamp);
        }

        @Override
        @NotNull
        public Cursor<T> cursor() {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @NotNull
        public Cursor<T> cursor(@NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnTx.DefaultImpls.getColumnDef(this);
        }
    }
}

