/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v2.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.index.Index;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.statistics.entity.EntityStatistics;
import org.vitrivr.cottontail.legacy.v2.column.ColumnV2;
import org.vitrivr.cottontail.legacy.v2.entity.BrokenIndexV2;
import org.vitrivr.cottontail.legacy.v2.entity.EntityHeader;
import org.vitrivr.cottontail.legacy.v2.entity.EntityV2;
import org.vitrivr.cottontail.legacy.v2.schema.SchemaV2;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u00012\u00020\u0002:\u000223B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010,\u001a\u00020-H\u0016J\u0014\u0010.\u001a\u00060/R\u00020\u00002\u0006\u00100\u001a\u000201H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00064"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2;", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaV2;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaV2;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "columns", "", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "Lorg/vitrivr/cottontail/legacy/v2/column/ColumnV2;", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/legacy/v2/entity/EntityHeader;", "indexes", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "Lorg/vitrivr/cottontail/legacy/v2/entity/BrokenIndexV2;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "getParent", "()Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaV2;", "getPath", "()Ljava/nio/file/Path;", "statisticsField", "Lorg/vitrivr/cottontail/dbms/statistics/entity/EntityStatistics;", "store", "Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2$Tx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class EntityV2
implements Entity,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final SchemaV2 parent;
    @NotNull
    private final DB store;
    @NotNull
    private final Atomic.Var<EntityHeader> headerField;
    @NotNull
    private final Atomic.Var<EntityStatistics> statisticsField;
    @NotNull
    private final Name.EntityName name;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final Map<Name.ColumnName, ColumnV2<?>> columns;
    @NotNull
    private final Map<Name.IndexName, BrokenIndexV2> indexes;
    @NotNull
    public static final String CATALOGUE_FILE = "index.db";
    @NotNull
    public static final String ENTITY_HEADER_FIELD = "cdb_entity_header";
    @NotNull
    public static final String ENTITY_STATISTICS_FIELD = "cdb_entity_statistics";

    /*
     * WARNING - void declaration
     */
    public EntityV2(@NotNull Path path, @NotNull SchemaV2 parent) {
        void $this$mapTo$iv$iv;
        DB dB;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        Object object = this;
        try {
            EntityV2 entityV2 = object;
            MapDBConfig mapDBConfig = this.getParent().getParent().getConfig().getMapdb();
            Path path2 = this.path.resolve(CATALOGUE_FILE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.path.resolve(CATALOGUE_FILE)");
            dB = mapDBConfig.db(path2);
        }
        catch (DBException dBException) {
            void e;
            EntityV2 entityV2 = object;
            throw new DatabaseException("Failed to open entity at " + this.path + ": " + e.getMessage() + "'.", null, 2, null);
        }
        entityV2.store = dB;
        this.headerField = (Atomic.Var)this.store.atomicVar(ENTITY_HEADER_FIELD, (Serializer)EntityHeader.Serializer).createOrOpen();
        this.statisticsField = (Atomic.Var)this.store.atomicVar(ENTITY_STATISTICS_FIELD, (Serializer)EntityStatistics.Serializer).createOrOpen();
        this.name = this.getParent().getName().entity(((EntityHeader)this.headerField.get()).getName());
        this.closeLock = new StampedLock();
        this.columns = (Map)new Object2ObjectLinkedOpenHashMap();
        this.indexes = (Map)new Object2ObjectLinkedOpenHashMap();
        EntityHeader header = (EntityHeader)this.headerField.get();
        Iterable $this$map$iv = header.getColumns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EntityHeader.ColumnRef columnRef = (EntityHeader.ColumnRef)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Name.ColumnName columnName = this.getName().column(it.getName());
            Path path3 = this.path.resolve(it.getName() + ".col");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            this.columns.put(columnName, new ColumnV2(path3, this));
            object.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Iterable $this$forEach$iv = header.getIndexes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityHeader.IndexRef it = (EntityHeader.IndexRef)element$iv;
            boolean bl = false;
            Name.IndexName indexName = this.getName().index(it.getName());
            Path path4 = this.path.resolve(it.getName() + ".idx");
            Entity entity = this;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path");
            this.indexes.put(indexName, new BrokenIndexV2(indexName, entity, path4));
        }
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public SchemaV2 getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Name.EntityName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-EntityV2$close$22 = false;
            if (!this.getClosed()) {
                this.store.close();
                Iterable $this$forEach$iv = this.columns.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ColumnV2 it = (ColumnV2)element$iv;
                    boolean bl = false;
                    it.close();
                }
            }
            Unit $i$a$-write-EntityV2$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2$Companion;", "", "()V", "CATALOGUE_FILE", "", "ENTITY_HEADER_FIELD", "ENTITY_STATISTICS_FIELD", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0007j\u0002`\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J%\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0#H\u0016\u00a2\u0006\u0002\u0010%J-\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0#2\u0006\u0010&\u001a\u00020'H\u0016\u00a2\u0006\u0002\u0010(J\u0014\u0010)\u001a\u00020\r2\n\u0010\u0014\u001a\u00060\u0007j\u0002`\u0015H\u0016J\u0010\u0010*\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u0014\u0010,\u001a\u00060\u0007j\u0002`\u00152\u0006\u0010-\u001a\u00020\"H\u0016J\f\u0010.\u001a\u00060\u0007j\u0002`\u0015H\u0016J\u0012\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0\u001dH\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0016J\b\u00101\u001a\u00020\rH\u0016J+\u00102\u001a\u00020\"2\n\u0010\u0014\u001a\u00060\u0007j\u0002`\u00152\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0#H\u0016\u00a2\u0006\u0002\u00103J\f\u00104\u001a\u00060\u0007j\u0002`\u0015H\u0016J\u0010\u00105\u001a\u00020\r2\u0006\u0010-\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u00066"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/entity/EntityTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2;", "getDbo", "()Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2;", "cleanup", "", "columnForName", "Lorg/vitrivr/cottontail/dbms/column/Column;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "contains", "", "tupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "count", "createIndex", "Lorg/vitrivr/cottontail/dbms/index/Index;", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "columns", "", "configuration", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "cursor", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/basics/Record;", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/core/basics/Cursor;", "partition", "Lkotlin/ranges/LongRange;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;Lkotlin/ranges/LongRange;)Lorg/vitrivr/cottontail/core/basics/Cursor;", "delete", "dropIndex", "indexForName", "insert", "record", "largestTupleId", "listColumns", "listIndexes", "optimize", "read", "(J[Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/core/basics/Record;", "smallestTupleId", "update", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements EntityTx {
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = EntityV2.this.closeLock.readLock();
            if (EntityV2.this.getClosed()) {
                EntityV2.this.closeLock.unlockRead(this.closeStamp);
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), EntityV2.this);
            }
        }

        @Override
        @NotNull
        public EntityV2 getDbo() {
            return EntityV2.this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Record read(long tupleId, @NotNull ColumnDef<?>[] columns) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            ColumnDef<?>[] columnDefArray = columns;
            EntityV2 entityV2 = EntityV2.this;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                ColumnV2 column;
                void it;
                void item$iv$iv;
                void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if ((ColumnV2)entityV2.columns.get(it.getName()) == null) {
                    throw new IllegalArgumentException("Column " + it + " does not exist on entity " + entityV2.getName() + '.');
                }
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(column);
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                collection.add(((ColumnTx)tx).get(tupleId));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
            Intrinsics.checkNotNull((Object)valueArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            Value[] values = valueArray;
            return (Record)new StandaloneRecord(tupleId, columns, values);
        }

        public long count() {
            return ((EntityStatistics)EntityV2.this.statisticsField.get()).getCount();
        }

        @Override
        public long smallestTupleId() {
            return 0L;
        }

        @Override
        public long largestTupleId() {
            return ((EntityStatistics)EntityV2.this.statisticsField.get()).getMaximumTupleId();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> listColumns() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = EntityV2.this.columns.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColumnV2 columnV2 = (ColumnV2)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getColumnDef());
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        @Override
        @NotNull
        public Column<?> columnForName(@NotNull Name.ColumnName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            ColumnV2 columnV2 = (ColumnV2)EntityV2.this.columns.get(name);
            if (columnV2 == null) {
                throw new DatabaseException.ColumnDoesNotExistException(name);
            }
            return columnV2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Name.IndexName> listIndexes() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = EntityV2.this.indexes.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BrokenIndexV2 brokenIndexV2 = (BrokenIndexV2)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        @Override
        @NotNull
        public Index indexForName(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            BrokenIndexV2 brokenIndexV2 = (BrokenIndexV2)EntityV2.this.indexes.get(name);
            if (brokenIndexV2 == null) {
                throw new DatabaseException.IndexDoesNotExistException((Name)name);
            }
            return brokenIndexV2;
        }

        @Override
        public boolean contains(long tupleId) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @NotNull
        public Index createIndex(@NotNull Name.IndexName name, @NotNull IndexType type, @NotNull List<Name.ColumnName> columns, @NotNull IndexConfig<?> configuration) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropIndex(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void optimize() {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @NotNull
        public Cursor<Record> cursor(@NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            return this.cursor(columns, new LongRange(this.smallestTupleId(), this.largestTupleId()));
        }

        @NotNull
        public Cursor<Record> cursor(@NotNull ColumnDef<?>[] columns, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            return (Cursor)new Cursor<Record>(columns, partition, EntityV2.this, this){
                @NotNull
                private final List<ColumnV2.Tx> txs;
                @NotNull
                private final Iterator<Long> wrapped;
                @NotNull
                private final Value[] values;
                final /* synthetic */ ColumnDef<?>[] $columns;
                {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    this.$columns = $columns;
                    ColumnDef<?>[] columnDefArray = $columns;
                    cursor.1 var16_6 = this;
                    boolean $i$f$map = false;
                    void var7_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        ColumnV2 column;
                        void it;
                        void item$iv$iv;
                        void var13_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        if ((ColumnV2)EntityV2.access$getColumns$p($receiver).get(it.getName()) == null) {
                            throw new IllegalArgumentException("Column " + it + " does not exist on entity " + $receiver.getName() + '.');
                        }
                        org.vitrivr.cottontail.dbms.general.Tx tx = $receiver2.getContext().getTx(column);
                        Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.legacy.v2.column.ColumnV2.Tx<*>");
                        collection.add((ColumnV2.Tx)tx);
                    }
                    var16_6.txs = (List)destination$iv$iv;
                    this.wrapped = ((ColumnV2.Tx)CollectionsKt.first(this.txs)).scan($partition);
                    this.values = new Value[$columns.length];
                }

                @NotNull
                public Record value() {
                    long tupleId = ((Number)this.wrapped.next()).longValue();
                    Iterator<ColumnV2.Tx> iterator = this.txs.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        int i = n++;
                        ColumnV2.Tx tx = iterator.next();
                        this.values[i] = tx.get(tupleId);
                    }
                    return (Record)new StandaloneRecord(tupleId, this.$columns, this.values);
                }

                public long key() {
                    return ((Number)this.wrapped.next()).longValue();
                }

                public boolean moveNext() {
                    return this.wrapped.hasNext();
                }

                public void close() {
                }

                public boolean hasNext() {
                    return Cursor.DefaultImpls.hasNext((Cursor)this);
                }

                @NotNull
                public Record next() {
                    return (Record)Cursor.DefaultImpls.next((Cursor)this);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        public long insert(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        public void update(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        public void delete(long tupleId) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void cleanup() {
            EntityV2.this.closeLock.unlockRead(this.closeStamp);
        }
    }
}

