/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v2.schema;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;
import org.vitrivr.cottontail.legacy.v2.catalogue.CatalogueV2;
import org.vitrivr.cottontail.legacy.v2.entity.EntityV2;
import org.vitrivr.cottontail.legacy.v2.schema.SchemaHeader;
import org.vitrivr.cottontail.legacy.v2.schema.SchemaV2;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0002-.B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010'\u001a\u00020(H\u0016J\u0014\u0010)\u001a\u00060*R\u00020\u00002\u0006\u0010+\u001a\u00020,H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006/"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaV2;", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaHeader;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "getParent", "()Lorg/vitrivr/cottontail/legacy/v2/catalogue/CatalogueV2;", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2;", "store", "Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaV2$Tx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class SchemaV2
implements Schema,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final CatalogueV2 parent;
    @NotNull
    private final DB store;
    @NotNull
    private final Atomic.Var<SchemaHeader> headerField;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final Map<Name.EntityName, EntityV2> registry;
    @NotNull
    private final Name.SchemaName name;
    @NotNull
    private static final String SCHEMA_HEADER_FIELD = "cdb_entity_header";
    @NotNull
    private static final String FILE_CATALOGUE = "index.db";

    /*
     * WARNING - void declaration
     */
    public SchemaV2(@NotNull Path path, @NotNull CatalogueV2 parent) {
        void $this$mapTo$iv$iv;
        DB dB;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        Object object = this;
        try {
            SchemaV2 schemaV2 = object;
            MapDBConfig mapDBConfig = this.getParent().getConfig().getMapdb();
            Path path2 = this.path.resolve(FILE_CATALOGUE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.path.resolve(FILE_CATALOGUE)");
            dB = mapDBConfig.db(path2);
        }
        catch (DBException dBException) {
            void e;
            SchemaV2 schemaV2 = object;
            throw new DatabaseException("Failed to open schema at '" + this.path + "': " + e.getMessage() + '\'', null, 2, null);
        }
        schemaV2.store = dB;
        this.headerField = (Atomic.Var)this.store.atomicVar(SCHEMA_HEADER_FIELD, (Serializer)SchemaHeader.Serializer).createOrOpen();
        this.closeLock = new StampedLock();
        Map map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(Object2ObjectOpenHashMap())");
        this.registry = map2;
        this.name = Name.SchemaName.Companion.create(((SchemaHeader)this.headerField.get()).getName());
        Iterable $this$map$iv = ((SchemaHeader)this.headerField.get()).getEntities();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SchemaHeader.EntityRef entityRef = (SchemaHeader.EntityRef)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Path path3 = this.path.resolve("entity_" + it.getName());
            Name.EntityName entityName = this.getName().entity(it.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            this.registry.put(entityName, new EntityV2(path3, this));
            object.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public CatalogueV2 getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Name.SchemaName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-SchemaV2$close$22 = false;
            if (!this.getClosed()) {
                this.store.close();
                this.registry.entrySet().removeIf(arg_0 -> SchemaV2.close$lambda$2$lambda$1(close.1.1.INSTANCE, arg_0));
            }
            Unit $i$a$-write-SchemaV2$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    private static final boolean close$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaV2$Companion;", "", "()V", "FILE_CATALOGUE", "", "SCHEMA_HEADER_FIELD", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J1\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u001a\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013\"\u0006\u0012\u0002\b\u00030\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaV2$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v2/schema/SchemaV2;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/general/DBO;", "cleanup", "", "createEntity", "Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;[Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/legacy/v2/entity/EntityV2;", "dropEntity", "entityForName", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "listEntities", "", "truncateEntity", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements SchemaTx {
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = SchemaV2.this.closeLock.readLock();
            if (SchemaV2.this.getClosed()) {
                SchemaV2.this.closeLock.unlockRead(this.closeStamp);
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), SchemaV2.this);
            }
        }

        @Override
        @NotNull
        public DBO getDbo() {
            return SchemaV2.this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Name.EntityName> listEntities() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = SchemaV2.this.registry.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EntityV2 entityV2 = (EntityV2)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        @Override
        @NotNull
        public Entity entityForName(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            EntityV2 entityV2 = (EntityV2)SchemaV2.this.registry.get(name);
            if (entityV2 == null) {
                throw new DatabaseException.EntityDoesNotExistException(name);
            }
            return entityV2;
        }

        @Override
        @NotNull
        public EntityV2 createEntity(@NotNull Name.EntityName name, ColumnDef<?> ... columns) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void truncateEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void cleanup() {
            SchemaV2.this.closeLock.unlockRead(this.closeStamp);
        }
    }
}

