/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.lucene;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.File;
import jetbrains.exodus.vfs.VfsInputStream;
import jetbrains.exodus.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NoLockFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.storage.lucene.XodusDirectoryConfig;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00041234B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00060\u0010R\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\u00060\u0010R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0016J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001c\u0010 \u001a\u00060!R\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001d\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u001c\u0010'\u001a\u00060(R\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0016\u0010-\u001a\u00020\u000e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050/H\u0016J\b\u00100\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;", "Lorg/apache/lucene/store/Directory;", "vfs", "Ljetbrains/exodus/vfs/VirtualFileSystem;", "name", "", "txn", "Ljetbrains/exodus/env/Transaction;", "directoryConfig", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectoryConfig;", "(Ljetbrains/exodus/vfs/VirtualFileSystem;Ljava/lang/String;Ljetbrains/exodus/env/Transaction;Lorg/vitrivr/cottontail/storage/lucene/XodusDirectoryConfig;)V", "ticks", "Ljava/util/concurrent/atomic/AtomicLong;", "close", "", "createOutput", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$IndexOutput;", "context", "Lorg/apache/lucene/store/IOContext;", "createTempOutput", "prefix", "suffix", "deleteFile", "fileLength", "", "getPendingDeletions", "", "listAll", "", "()[Ljava/lang/String;", "obtainLock", "Lorg/apache/lucene/store/Lock;", "openChecksumInput", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$ChecksumIndexInput;", "openFileOrThrow", "Ljetbrains/exodus/vfs/File;", "Lorg/jetbrains/annotations/Nullable;", "create", "", "openInput", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$IndexInput;", "rename", "source", "dest", "resolve", "sync", "names", "", "syncMetaData", "ChecksumIndexInput", "IndexInput", "IndexOutput", "SlicedIndexInput", "cottontaildb-dbms"})
public final class XodusDirectory
extends Directory {
    @NotNull
    private final VirtualFileSystem vfs;
    @NotNull
    private final String name;
    @NotNull
    private final Transaction txn;
    @NotNull
    private final XodusDirectoryConfig directoryConfig;
    @NotNull
    private final AtomicLong ticks;

    public XodusDirectory(@NotNull VirtualFileSystem vfs, @NotNull String name, @NotNull Transaction txn, @NotNull XodusDirectoryConfig directoryConfig) {
        Intrinsics.checkNotNullParameter((Object)vfs, (String)"vfs");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Intrinsics.checkNotNullParameter((Object)directoryConfig, (String)"directoryConfig");
        this.vfs = vfs;
        this.name = name;
        this.txn = txn;
        this.directoryConfig = directoryConfig;
        if (!(!StringsKt.contains$default((CharSequence)this.name, (char)'/', (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Name of the XodusDirectory must not contain a path separator.";
            throw new IllegalArgumentException(string.toString());
        }
        this.ticks = new AtomicLong(System.currentTimeMillis());
    }

    public /* synthetic */ XodusDirectory(VirtualFileSystem virtualFileSystem, String string, Transaction transaction, XodusDirectoryConfig xodusDirectoryConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            xodusDirectoryConfig = new XodusDirectoryConfig(0, 0, 3, null);
        }
        this(virtualFileSystem, string, transaction, xodusDirectoryConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String[] listAll() {
        void $this$mapTo$iv$iv;
        File it;
        Iterable $this$filterTo$iv$iv;
        String fqn = this.resolve("");
        Iterable iterable = this.vfs.getFiles(this.txn);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"this@XodusDirectory.vfs.getFiles(this.txn)");
        Iterable $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
            if (!StringsKt.startsWith$default((String)string, (String)fqn, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            it = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getPath(), (String)"it.path");
            int n = fqn.length();
            int n2 = it.getPath().length();
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            collection.add(string2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return stringArray;
    }

    public void deleteFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.vfs.deleteFile(this.txn, this.resolve(name));
    }

    public void rename(@NotNull String source, @NotNull String dest) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        File file = this.openFileOrThrow(source, false);
        this.vfs.renameFile(this.txn, file, this.resolve(dest));
    }

    public long fileLength(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File file = this.openFileOrThrow(name, false);
        return this.vfs.getFileLength(this.txn, file);
    }

    @NotNull
    public IndexOutput createOutput(@NotNull String name, @NotNull IOContext context2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new IndexOutput(this.openFileOrThrow(name, true));
    }

    @NotNull
    public IndexOutput createTempOutput(@NotNull String prefix, @NotNull String suffix, @NotNull IOContext context2) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String filename = IndexFileNames.segmentFileName((String)prefix, (String)(suffix + '_' + this.ticks.getAndIncrement()), (String)"tmp");
        Intrinsics.checkNotNullExpressionValue((Object)filename, (String)"filename");
        return this.createOutput(filename, context2);
    }

    @NotNull
    public IndexInput openInput(@NotNull String name, @NotNull IOContext context2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IOContext.Context context3 = context2.context;
        int bufferSize = (context3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[context3.ordinal()]) == 1 ? this.directoryConfig.getInputMergeBufferSize() : this.directoryConfig.getInputBufferSize();
        return new IndexInput(this.openFileOrThrow(name, false), bufferSize);
    }

    @NotNull
    public ChecksumIndexInput openChecksumInput(@NotNull String name, @NotNull IOContext context2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new ChecksumIndexInput(this.openInput(name, context2));
    }

    @NotNull
    public Lock obtainLock(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Lock lock2 = NoLockFactory.INSTANCE.obtainLock((Directory)this, this.resolve(name));
        Intrinsics.checkNotNullExpressionValue((Object)lock2, (String)"INSTANCE.obtainLock(this, this.resolve(name))");
        return lock2;
    }

    @NotNull
    public Set<String> getPendingDeletions() {
        return new LinkedHashSet();
    }

    public void sync(@NotNull Collection<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
    }

    public void syncMetaData() {
    }

    public void close() {
    }

    private final File openFileOrThrow(String name, boolean create) {
        File file = this.vfs.openFile(this.txn, this.resolve(name), create);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file;
    }

    private final String resolve(String name) {
        return "lucene/" + this.name + '/' + name;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0096\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\r\u001a\u00060\u0000R\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\bH\u0014J$\u0010\u0017\u001a\u00060\u0018R\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$IndexInput;", "Lorg/apache/lucene/store/BufferedIndexInput;", "file", "Ljetbrains/exodus/vfs/File;", "bufferSize", "", "(Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;Ljetbrains/exodus/vfs/File;I)V", "currentPosition", "", "getFile", "()Ljetbrains/exodus/vfs/File;", "input", "Ljetbrains/exodus/vfs/VfsInputStream;", "clone", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;", "close", "", "length", "readInternal", "b", "Ljava/nio/ByteBuffer;", "seekInternal", "pos", "slice", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$SlicedIndexInput;", "sliceDescription", "", "offset", "cottontaildb-dbms"})
    public class IndexInput
    extends BufferedIndexInput {
        @NotNull
        private final File file;
        private volatile long currentPosition;
        @Nullable
        private volatile VfsInputStream input;

        public IndexInput(File file, int bufferSize) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super("XodusDirectory.IndexInput[" + XodusDirectory.this.name + ']', bufferSize);
            this.file = file;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public synchronized IndexInput clone() {
            IndexInput clone = new IndexInput(this.file, this.getBufferSize());
            clone.seek(this.getFilePointer());
            return clone;
        }

        public long length() {
            return XodusDirectory.this.vfs.getFileLength(XodusDirectory.this.txn, this.file);
        }

        protected synchronized void readInternal(@NotNull ByteBuffer b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (!b.hasArray()) {
                boolean $i$a$-require-XodusDirectory$IndexInput$readInternal$22 = false;
                String $i$a$-require-XodusDirectory$IndexInput$readInternal$22 = "IndexInput.readInternal() expects a byte buffer with accessible array.";
                throw new IllegalArgumentException($i$a$-require-XodusDirectory$IndexInput$readInternal$22.toString());
            }
            int offset = b.position();
            VfsInputStream input = this.input;
            if (input == null || input.available() <= 0) {
                VfsInputStream vfsInputStream = input;
                if (vfsInputStream != null) {
                    vfsInputStream.close();
                }
                this.input = input = XodusDirectory.this.vfs.readFile(XodusDirectory.this.txn, this.file, this.currentPosition);
            }
            int read = input.read(b.array(), offset, b.limit() - offset);
            b.position(offset + read);
            this.currentPosition += (long)read;
        }

        protected synchronized void seekInternal(long pos) {
            if (pos == this.currentPosition) {
                return;
            }
            VfsInputStream input = this.input;
            if (input == null) {
                this.currentPosition = pos;
                return;
            }
            if (pos > this.currentPosition) {
                ClusteringStrategy clusteringStrategy = XodusDirectory.this.vfs.getConfig().getClusteringStrategy();
                Intrinsics.checkNotNullExpressionValue((Object)clusteringStrategy, (String)"this@XodusDirectory.vfs.config.clusteringStrategy");
                ClusteringStrategy clusteringStrategy2 = clusteringStrategy;
                long bytesToSkip = pos - this.currentPosition;
                int clusterSize = clusteringStrategy2.getFirstClusterSize();
                if (!(clusteringStrategy2.isLinear() && this.currentPosition % (long)clusterSize + bytesToSkip >= (long)clusterSize || input.skip(bytesToSkip) != bytesToSkip)) {
                    this.currentPosition = pos;
                    return;
                }
            }
            input.close();
            this.input = null;
            this.currentPosition = pos;
        }

        @NotNull
        public SlicedIndexInput slice(@NotNull String sliceDescription, long offset, long length) {
            Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
            return new SlicedIndexInput(this, offset, length);
        }

        public synchronized void close() {
            VfsInputStream vfsInputStream = this.input;
            if (vfsInputStream != null) {
                vfsInputStream.close();
            }
            this.input = null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B!\u0012\n\u0010\u0003\u001a\u00060\u0001R\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\f\u0010\n\u001a\u00060\u0000R\u00020\u0002H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0014J$\u0010\u000e\u001a\u00060\u0000R\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016R\u0015\u0010\u0003\u001a\u00060\u0001R\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$SlicedIndexInput;", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$IndexInput;", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;", "base", "offset", "", "length", "(Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$IndexInput;JJ)V", "getBase", "()Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$IndexInput;", "clone", "seekInternal", "", "pos", "slice", "sliceDescription", "", "cottontaildb-dbms"})
    public final class SlicedIndexInput
    extends IndexInput {
        @NotNull
        private final IndexInput base;
        private final long offset;
        private final long length;

        public SlicedIndexInput(IndexInput base, long offset, long length) {
            Intrinsics.checkNotNullParameter((Object)((Object)base), (String)"base");
            super(base.getFile(), Integer.max((int)Long.min(base.getBufferSize(), length), 8));
            this.base = base;
            this.offset = offset;
            this.length = length;
        }

        @NotNull
        public final IndexInput getBase() {
            return this.base;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        @NotNull
        public SlicedIndexInput clone() {
            SlicedIndexInput clone = new SlicedIndexInput(this.base, this.offset, this.length);
            clone.seek(this.getFilePointer());
            return clone;
        }

        @Override
        protected void seekInternal(long pos) {
            super.seekInternal(pos + this.offset);
        }

        @Override
        @NotNull
        public SlicedIndexInput slice(@NotNull String sliceDescription, long offset, long length) {
            Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
            return this.base.slice(sliceDescription, this.offset + offset, length);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$IndexOutput;", "Lorg/apache/lucene/store/IndexOutput;", "file", "Ljetbrains/exodus/vfs/File;", "(Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;Ljetbrains/exodus/vfs/File;)V", "crc", "Lorg/apache/lucene/store/BufferedChecksum;", "currentPosition", "", "getFile", "()Ljetbrains/exodus/vfs/File;", "output", "Ljava/io/OutputStream;", "close", "", "getChecksum", "getFilePointer", "writeByte", "b", "", "writeBytes", "", "offset", "", "length", "cottontaildb-dbms"})
    public final class IndexOutput
    extends org.apache.lucene.store.IndexOutput {
        @NotNull
        private final File file;
        @NotNull
        private final OutputStream output;
        private long currentPosition;
        @NotNull
        private final BufferedChecksum crc;

        public IndexOutput(File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = "XodusDirectory.IndexOutput[" + file.getPath() + ']';
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            char[] cArray = new char[]{'/'};
            super(string, (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null)));
            this.file = file;
            OutputStream outputStream = XodusDirectory.this.vfs.writeFile(XodusDirectory.this.txn, this.file);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"this@XodusDirectory.vfs.\u2026Directory.txn, this.file)");
            this.output = outputStream;
            this.crc = new BufferedChecksum((Checksum)new CRC32());
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public long getChecksum() {
            return this.crc.getValue();
        }

        public long getFilePointer() {
            return this.currentPosition;
        }

        public void writeByte(byte b) {
            this.output.write(b);
            ++this.currentPosition;
            this.crc.update((int)b);
        }

        public void writeBytes(@NotNull byte[] b, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (length == 0) {
                return;
            }
            this.output.write(b, offset, length);
            this.currentPosition += (long)length;
            this.crc.update(b, offset, length);
        }

        public void close() {
            this.output.close();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$ChecksumIndexInput;", "Lorg/apache/lucene/store/BufferedChecksumIndexInput;", "wrapped", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$IndexInput;", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;", "(Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory$IndexInput;)V", "skipBytes", "", "numBytes", "", "cottontaildb-dbms"})
    public final class ChecksumIndexInput
    extends BufferedChecksumIndexInput {
        @NotNull
        private final IndexInput wrapped;

        public ChecksumIndexInput(IndexInput wrapped) {
            Intrinsics.checkNotNullParameter((Object)((Object)wrapped), (String)"wrapped");
            super((org.apache.lucene.store.IndexInput)wrapped);
            this.wrapped = wrapped;
        }

        public void skipBytes(long numBytes) {
            this.wrapped.seek(this.wrapped.getFilePointer() + numBytes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IOContext.Context.values().length];
            try {
                nArray[IOContext.Context.MERGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

