/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.statistics;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.statistics.columns.BooleanValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.BooleanVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ByteStringValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ByteValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.Complex32ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.Complex32VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.Complex64ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.Complex64VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.DateValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.DoubleValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.DoubleVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.FloatValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.FloatVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.IntValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.IntVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.LongValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.LongVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ShortValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.StringValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.xodus.XodusBinding;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0004\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/statistics/StatisticsSerializerFactory;", "", "()V", "xodus", "Lorg/vitrivr/cottontail/storage/serializers/statistics/xodus/XodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "T", "Lorg/vitrivr/cottontail/core/values/types/Value;", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "cottontaildb-dbms"})
public final class StatisticsSerializerFactory {
    @NotNull
    public static final StatisticsSerializerFactory INSTANCE = new StatisticsSerializerFactory();

    private StatisticsSerializerFactory() {
    }

    @NotNull
    public final <T extends Value> XodusBinding<ValueStatistics<T>> xodus(@NotNull Types<T> type) {
        XodusBinding xodusBinding;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Types<T> types = type;
        if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
            xodusBinding = BooleanValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
            xodusBinding = DateValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
            xodusBinding = ByteValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
            xodusBinding = Complex32ValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
            xodusBinding = Complex64ValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
            xodusBinding = DoubleValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
            xodusBinding = FloatValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
            xodusBinding = IntValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
            xodusBinding = LongValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
            xodusBinding = ShortValueStatistics.Binding.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
            xodusBinding = StringValueStatistics.Binding.INSTANCE;
        } else if (types instanceof Types.BooleanVector) {
            xodusBinding = new BooleanVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.Complex32Vector) {
            xodusBinding = new Complex32VectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.Complex64Vector) {
            xodusBinding = new Complex64VectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.DoubleVector) {
            xodusBinding = new DoubleVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.FloatVector) {
            xodusBinding = new FloatVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.IntVector) {
            xodusBinding = new IntVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.LongVector) {
            xodusBinding = new LongVectorValueStatistics.Binding(type.getLogicalSize());
        } else if (types instanceof Types.ByteString) {
            xodusBinding = ByteStringValueStatistics.Binding.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        XodusBinding xodusBinding2 = xodusBinding;
        Intrinsics.checkNotNull((Object)xodusBinding2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.statistics.xodus.XodusBinding<org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics<T of org.vitrivr.cottontail.storage.serializers.statistics.StatisticsSerializerFactory.xodus>>");
        return xodusBinding2;
    }
}

