/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.values;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.BooleanValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.BooleanVectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.ByteValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.Complex32ValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.Complex32VectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.Complex64ValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.Complex64VectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.DateValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.DoubleValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.DoubleVectorMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.FloatValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.FloatVectorMapDBValueSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.IntValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.IntVectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.LongValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.LongVectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.MapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.ShortValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.mapdb.StringValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.values.xodus.BooleanValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.BooleanVectorValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.ByteStringValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.ByteValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.Complex32ValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.Complex32VectorValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.Complex64ValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.Complex64VectorValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.DateValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.DoubleValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.DoubleVectorValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.FloatValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.FloatVectorValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.IntValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.IntVectorValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.LongValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.LongVectorValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.ShortValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.StringValueXodusBinding;
import org.vitrivr.cottontail.storage.serializers.values.xodus.XodusBinding;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bJ,\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/values/ValueSerializerFactory;", "", "()V", "mapdb", "Lorg/vitrivr/cottontail/storage/serializers/values/mapdb/MapDBSerializer;", "T", "Lorg/vitrivr/cottontail/core/values/types/Value;", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "xodus", "Lorg/vitrivr/cottontail/storage/serializers/values/xodus/XodusBinding;", "nullable", "", "cottontaildb-dbms"})
public final class ValueSerializerFactory {
    @NotNull
    public static final ValueSerializerFactory INSTANCE = new ValueSerializerFactory();

    private ValueSerializerFactory() {
    }

    @NotNull
    public final <T extends Value> MapDBSerializer<T> mapdb(@NotNull Types<T> type) {
        MapDBSerializer mapDBSerializer;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Types<T> types = type;
        if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
            mapDBSerializer = BooleanValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
            mapDBSerializer = DateValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
            mapDBSerializer = ByteValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
            mapDBSerializer = Complex32ValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
            mapDBSerializer = Complex64ValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
            mapDBSerializer = DoubleValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
            mapDBSerializer = FloatValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
            mapDBSerializer = IntValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
            mapDBSerializer = LongValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
            mapDBSerializer = ShortValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
            mapDBSerializer = StringValueMapDBSerializer.INSTANCE;
        } else if (types instanceof Types.BooleanVector) {
            mapDBSerializer = new BooleanVectorValueMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.Complex32Vector) {
            mapDBSerializer = new Complex32VectorValueMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.Complex64Vector) {
            mapDBSerializer = new Complex64VectorValueMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.DoubleVector) {
            mapDBSerializer = new DoubleVectorMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.FloatVector) {
            mapDBSerializer = new FloatVectorMapDBValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.IntVector) {
            mapDBSerializer = new IntVectorValueMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.LongVector) {
            mapDBSerializer = new LongVectorValueMapDBSerializer(type.getLogicalSize());
        } else {
            if (types instanceof Types.ByteString) {
                throw new UnsupportedOperationException("ByteString not supported by MapDB storage");
            }
            throw new NoWhenBranchMatchedException();
        }
        MapDBSerializer mapDBSerializer2 = mapDBSerializer;
        Intrinsics.checkNotNull((Object)mapDBSerializer2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.values.mapdb.MapDBSerializer<T of org.vitrivr.cottontail.storage.serializers.values.ValueSerializerFactory.mapdb>");
        return mapDBSerializer2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final <T extends Value> XodusBinding<T> xodus(@NotNull Types<T> type, boolean nullable) {
        XodusBinding xodusBinding;
        Types<T> types;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (nullable) {
            types = type;
            if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
                xodusBinding = BooleanValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
                xodusBinding = DateValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
                xodusBinding = ByteValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
                xodusBinding = Complex32ValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
                xodusBinding = Complex64ValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
                xodusBinding = DoubleValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
                xodusBinding = FloatValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
                xodusBinding = IntValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
                xodusBinding = LongValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
                xodusBinding = ShortValueXodusBinding.Nullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
                xodusBinding = StringValueXodusBinding.Nullable.INSTANCE;
            } else if (types instanceof Types.BooleanVector) {
                xodusBinding = new BooleanVectorValueXodusBinding.Nullable(type.getLogicalSize());
            } else if (types instanceof Types.Complex32Vector) {
                xodusBinding = new Complex32VectorValueXodusBinding.Nullable(type.getLogicalSize());
            } else if (types instanceof Types.Complex64Vector) {
                xodusBinding = new Complex64VectorValueXodusBinding.Nullable(type.getLogicalSize());
            } else if (types instanceof Types.DoubleVector) {
                xodusBinding = new DoubleVectorValueXodusBinding.Nullable(type.getLogicalSize());
            } else if (types instanceof Types.FloatVector) {
                xodusBinding = new FloatVectorValueXodusBinding.Nullable(type.getLogicalSize());
            } else if (types instanceof Types.IntVector) {
                xodusBinding = new IntVectorValueXodusBinding.Nullable(type.getLogicalSize());
            } else if (types instanceof Types.LongVector) {
                xodusBinding = new LongVectorValueXodusBinding.Nullable(type.getLogicalSize());
            } else {
                if (!(types instanceof Types.ByteString)) throw new NoWhenBranchMatchedException();
                xodusBinding = ByteStringValueXodusBinding.Nullable.INSTANCE;
            }
        } else {
            types = type;
            if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
                xodusBinding = BooleanValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
                xodusBinding = DateValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
                xodusBinding = ByteValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
                xodusBinding = Complex32ValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
                xodusBinding = Complex64ValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
                xodusBinding = DoubleValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
                xodusBinding = FloatValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
                xodusBinding = IntValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
                xodusBinding = LongValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
                xodusBinding = ShortValueXodusBinding.NonNullable.INSTANCE;
            } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
                xodusBinding = StringValueXodusBinding.NonNullable.INSTANCE;
            } else if (types instanceof Types.BooleanVector) {
                xodusBinding = new BooleanVectorValueXodusBinding.NonNullable(type.getLogicalSize());
            } else if (types instanceof Types.Complex32Vector) {
                xodusBinding = new Complex32VectorValueXodusBinding.NonNullable(type.getLogicalSize());
            } else if (types instanceof Types.Complex64Vector) {
                xodusBinding = new Complex64VectorValueXodusBinding.NonNullable(type.getLogicalSize());
            } else if (types instanceof Types.DoubleVector) {
                xodusBinding = new DoubleVectorValueXodusBinding.NonNullable(type.getLogicalSize());
            } else if (types instanceof Types.FloatVector) {
                xodusBinding = new FloatVectorValueXodusBinding.NonNullable(type.getLogicalSize());
            } else if (types instanceof Types.IntVector) {
                xodusBinding = new IntVectorValueXodusBinding.NonNullable(type.getLogicalSize());
            } else if (types instanceof Types.LongVector) {
                xodusBinding = new LongVectorValueXodusBinding.NonNullable(type.getLogicalSize());
            } else {
                if (!(types instanceof Types.ByteString)) throw new NoWhenBranchMatchedException();
                xodusBinding = ByteStringValueXodusBinding.NonNullable.INSTANCE;
            }
        }
        XodusBinding xodusBinding2 = xodusBinding;
        Intrinsics.checkNotNull((Object)xodusBinding2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.values.xodus.XodusBinding<T of org.vitrivr.cottontail.storage.serializers.values.ValueSerializerFactory.xodus>");
        return xodusBinding2;
    }
}

