/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.values.xodus;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.StringBinding;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.values.StringValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.storage.serializers.values.xodus.XodusBinding;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\n\u000b\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\f"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/values/xodus/StringValueXodusBinding;", "Lorg/vitrivr/cottontail/storage/serializers/values/xodus/XodusBinding;", "Lorg/vitrivr/cottontail/core/values/StringValue;", "()V", "type", "Lorg/vitrivr/cottontail/core/values/types/Types$String;", "getType", "()Lorg/vitrivr/cottontail/core/values/types/Types$String;", "NonNullable", "Nullable", "Lorg/vitrivr/cottontail/storage/serializers/values/xodus/StringValueXodusBinding$NonNullable;", "Lorg/vitrivr/cottontail/storage/serializers/values/xodus/StringValueXodusBinding$Nullable;", "cottontaildb-dbms"})
public abstract class StringValueXodusBinding
implements XodusBinding<StringValue> {
    @NotNull
    private final Types.String type = Types.String.INSTANCE;

    private StringValueXodusBinding() {
    }

    @NotNull
    public Types.String getType() {
        return this.type;
    }

    public /* synthetic */ StringValueXodusBinding(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/values/xodus/StringValueXodusBinding$NonNullable;", "Lorg/vitrivr/cottontail/storage/serializers/values/xodus/StringValueXodusBinding;", "()V", "type", "Lorg/vitrivr/cottontail/core/values/types/Types$String;", "getType", "()Lorg/vitrivr/cottontail/core/values/types/Types$String;", "entryToValue", "Lorg/vitrivr/cottontail/core/values/StringValue;", "entry", "Ljetbrains/exodus/ByteIterable;", "entryToValue-BYFzXKU", "(Ljetbrains/exodus/ByteIterable;)Ljava/lang/String;", "valueToEntry", "value", "valueToEntry-u_-PEX8", "(Ljava/lang/String;)Ljetbrains/exodus/ByteIterable;", "cottontaildb-dbms"})
    public static final class NonNullable
    extends StringValueXodusBinding {
        @NotNull
        public static final NonNullable INSTANCE = new NonNullable();
        @NotNull
        private static final Types.String type = Types.String.INSTANCE;

        private NonNullable() {
            super(null);
        }

        @Override
        @NotNull
        public Types.String getType() {
            return type;
        }

        @NotNull
        public String entryToValue-BYFzXKU(@NotNull ByteIterable entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            String string = StringBinding.entryToString((ByteIterable)entry);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entryToString(entry)");
            return StringValue.constructor-impl((String)string);
        }

        @NotNull
        public ByteIterable valueToEntry-u_-PEX8(@org.jetbrains.annotations.Nullable String value) {
            if (!(value != null)) {
                boolean bl = false;
                String string = "Serialization error: Value cannot be null.";
                throw new IllegalArgumentException(string.toString());
            }
            ArrayByteIterable arrayByteIterable = StringBinding.stringToEntry((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"stringToEntry(value.value)");
            return (ByteIterable)arrayByteIterable;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/values/xodus/StringValueXodusBinding$Nullable;", "Lorg/vitrivr/cottontail/storage/serializers/values/xodus/StringValueXodusBinding;", "()V", "NULL_VALUE", "", "NULL_VALUE_RAW", "Ljetbrains/exodus/ArrayByteIterable;", "kotlin.jvm.PlatformType", "entryToValue", "Lorg/vitrivr/cottontail/core/values/StringValue;", "entry", "Ljetbrains/exodus/ByteIterable;", "entryToValue-20uZBUg", "(Ljetbrains/exodus/ByteIterable;)Ljava/lang/String;", "valueToEntry", "value", "valueToEntry-u_-PEX8", "(Ljava/lang/String;)Ljetbrains/exodus/ByteIterable;", "cottontaildb-dbms"})
    public static final class Nullable
    extends StringValueXodusBinding {
        @NotNull
        public static final Nullable INSTANCE = new Nullable();
        @NotNull
        private static final String NULL_VALUE = "\u0000\u0000";
        private static final ArrayByteIterable NULL_VALUE_RAW = StringBinding.stringToEntry((String)"\u0000\u0000");

        private Nullable() {
            super(null);
        }

        @org.jetbrains.annotations.Nullable
        public String entryToValue-20uZBUg(@NotNull ByteIterable entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            if (Intrinsics.areEqual((Object)NULL_VALUE_RAW, (Object)entry)) {
                return null;
            }
            String string = StringBinding.entryToString((ByteIterable)entry);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entryToString(entry)");
            return StringValue.constructor-impl((String)string);
        }

        @NotNull
        public ByteIterable valueToEntry-u_-PEX8(@org.jetbrains.annotations.Nullable String value) {
            String string = value;
            if (string == null) {
                string = null;
            }
            if (Intrinsics.areEqual((Object)string, (Object)NULL_VALUE)) {
                String string2 = value;
                throw new DatabaseException.ReservedValueException("Cannot serialize value '" + (string2 == null ? "null" : StringValue.toString-impl((String)string2)) + "'! Value is reserved for NULL entries for type " + this.getType() + '.');
            }
            if (value == null) {
                ArrayByteIterable arrayByteIterable = NULL_VALUE_RAW;
                Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"NULL_VALUE_RAW");
                return (ByteIterable)arrayByteIterable;
            }
            ArrayByteIterable arrayByteIterable = StringBinding.stringToEntry((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"stringToEntry(value.value)");
            return (ByteIterable)arrayByteIterable;
        }
    }
}

