/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.io;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/vitrivr/cottontail/utilities/io/TxFileUtilities;", "", "()V", "TX_CREATED", "", "TX_DELETED", "TX_SEPARATOR", "logger", "Lorg/slf4j/Logger;", "createPath", "Ljava/nio/file/Path;", "path", "delete", "", "plainPath", "cottontaildb-dbms"})
public final class TxFileUtilities {
    @NotNull
    public static final TxFileUtilities INSTANCE = new TxFileUtilities();
    @NotNull
    public static final String TX_SEPARATOR = "~";
    @NotNull
    public static final String TX_CREATED = "~created";
    @NotNull
    public static final String TX_DELETED = "~deleted";
    @NotNull
    private static final Logger logger;

    private TxFileUtilities() {
    }

    @NotNull
    public final Path plainPath(@NotNull Path path) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.contains$default((CharSequence)((Object)path.getFileName()).toString(), (CharSequence)TX_SEPARATOR, (boolean)false, (int)2, null)) {
            String[] stringArray2 = new String[]{TX_SEPARATOR};
            String normalizedName = (String)StringsKt.split$default((CharSequence)((Object)path.getFileName()).toString(), (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(0);
            Path normalizedPath = path.getParent().resolve(normalizedName);
            stringArray = stringArray2;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"{\n        val normalized\u2026     normalizedPath\n    }");
        } else {
            stringArray = path;
        }
        return stringArray;
    }

    @NotNull
    public final Path createPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path.getParent().resolve(path.getFileName() + TX_CREATED + UUID.randomUUID());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.parent.resolve(\"${p\u2026ED}${UUID.randomUUID()}\")");
        return path2;
    }

    public final void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Files.exists(path, new LinkOption[0])) {
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(arg_0 -> TxFileUtilities.delete$lambda$0((Function1)new Function1<Path, Unit>(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(1);
                }

                public final void invoke(Path it) {
                    try {
                        Files.delete(it);
                    }
                    catch (IOException e) {
                        Logger logger = TxFileUtilities.access$getLogger$p();
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to delete ").append(this.$path).append(" (content: ");
                        List<Path> list = Files.list(this.$path).toList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"list(path).toList()");
                        logger.warn(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append(").").toString());
                    }
                }
            }, arg_0));
        } else {
            logger.warn("Noting to delete at " + path + '.');
        }
    }

    private static final void delete$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        Logger logger = LoggerFactory.getLogger(TxFileUtilities.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(TxFileUtilities::class.java)");
        TxFileUtilities.logger = logger;
    }
}

