/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.math.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.IntValue;
import org.vitrivr.cottontail.core.values.types.NumericValue;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.utilities.math.clustering.Cluster;
import org.vitrivr.cottontail.utilities.math.clustering.Clusterer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ0\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00132\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0010H\u0002J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00182\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0010H\u0002J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0010H\u0016J\"\u0010\u001b\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u001a\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/utilities/math/clustering/KMeansClusterer;", "Lorg/vitrivr/cottontail/utilities/math/clustering/Clusterer;", "k", "", "distance", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "random", "Lorg/apache/commons/math3/random/RandomGenerator;", "iterations", "(ILorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;Lorg/apache/commons/math3/random/RandomGenerator;I)V", "getDistance", "()Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "getK", "()I", "assignPointsToClusters", "clusters", "", "Lorg/vitrivr/cottontail/utilities/math/clustering/KMeansClusterer$KMeansCluster;", "points", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "assignments", "", "centroidOf", "chooseInitialCenters", "", "cluster", "Lorg/vitrivr/cottontail/utilities/math/clustering/Cluster;", "getNearestCluster", "point", "getNewCenter", "Companion", "KMeansCluster", "cottontaildb-dbms"})
public final class KMeansClusterer
implements Clusterer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int k;
    @NotNull
    private final VectorDistance<?> distance;
    @NotNull
    private final RandomGenerator random;
    private final int iterations;
    private static final int MAX_ITERATIONS = 250;

    public KMeansClusterer(int k, @NotNull VectorDistance<?> distance, @NotNull RandomGenerator random, int iterations) {
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.k = k;
        this.distance = distance;
        this.random = random;
        this.iterations = iterations;
        if (!(this.k > 0)) {
            boolean $i$a$-require-KMeansClusterer$32 = false;
            String $i$a$-require-KMeansClusterer$32 = "The number of cluster centers must be greater than zero.";
            throw new IllegalArgumentException($i$a$-require-KMeansClusterer$32.toString());
        }
        if (!(this.iterations > 0)) {
            boolean bl = false;
            String string = "The number of iterations must be greater than zero.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ KMeansClusterer(int n, VectorDistance vectorDistance, RandomGenerator randomGenerator, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n2 = 250;
        }
        this(n, vectorDistance, randomGenerator, n2);
    }

    public final int getK() {
        return this.k;
    }

    @Override
    @NotNull
    public VectorDistance<?> getDistance() {
        return this.distance;
    }

    @Override
    @NotNull
    public List<Cluster> cluster(@NotNull List<? extends VectorValue<?>> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (!(points.size() >= this.k)) {
            boolean $i$a$-require-KMeansClusterer$cluster$22 = false;
            String $i$a$-require-KMeansClusterer$cluster$22 = "Number of points must be larger than the desired number of cluster centers!";
            throw new IllegalArgumentException($i$a$-require-KMeansClusterer$cluster$22.toString());
        }
        List clusters = this.chooseInitialCenters(points);
        int[] assignments = new int[points.size()];
        this.assignPointsToClusters(clusters, points, assignments);
        int n = this.iterations;
        for (int i = 0; i < n; ++i) {
            boolean emptyCluster = false;
            List newClusters = new ArrayList(this.k);
            for (KMeansCluster cluster : clusters) {
                VectorValue<?> vectorValue;
                if (cluster.getPoints().isEmpty()) {
                    emptyCluster = true;
                    vectorValue = this.getNewCenter(clusters);
                } else {
                    vectorValue = this.centroidOf(cluster.getPoints());
                }
                VectorValue<?> newCenter = vectorValue;
                newClusters.add(new KMeansCluster(newCenter));
            }
            int changes = this.assignPointsToClusters(newClusters, points, assignments);
            clusters = newClusters;
            if (changes != 0 || emptyCluster) continue;
            return clusters;
        }
        return clusters;
    }

    private final int assignPointsToClusters(List<KMeansCluster> clusters, List<? extends VectorValue<?>> points, int[] assignments) {
        int assignedDifferently = 0;
        Iterator<VectorValue<?>> iterator = points.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int pointIndex = n++;
            VectorValue<?> p = iterator.next();
            int clusterIndex = this.getNearestCluster(clusters, p);
            if (clusterIndex != assignments[pointIndex]) {
                ++assignedDifferently;
            }
            KMeansCluster cluster = clusters.get(clusterIndex);
            cluster.addPoint(p);
            assignments[pointIndex] = clusterIndex;
        }
        return assignedDifferently;
    }

    private final int getNearestCluster(List<KMeansCluster> clusters, VectorValue<?> point) {
        double minDistance = Double.MAX_VALUE;
        int minCluster = 0;
        Iterator<KMeansCluster> iterator = clusters.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int clusterIndex = n++;
            KMeansCluster c = iterator.next();
            Value[] valueArray = new Value[]{(Value)c.getCenter(), (Value)point};
            Value value = this.getDistance().invoke(valueArray);
            Intrinsics.checkNotNull((Object)value);
            double distance = ((DoubleValue)value).unbox-impl();
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minCluster = clusterIndex;
        }
        return minCluster;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KMeansCluster> chooseInitialCenters(List<? extends VectorValue<?>> points) {
        boolean[] taken = new boolean[points.size()];
        List resultSet = new ArrayList(this.k);
        int firstPointIndex = this.random.nextInt(points.size());
        resultSet.add(new KMeansCluster(points.get(firstPointIndex)));
        taken[firstPointIndex] = true;
        int n = 0;
        int n2 = points.size();
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            Value[] valueArray = new Value[]{(Value)points.get(firstPointIndex), (Value)points.get(n3)};
            Value value = this.getDistance().invoke(valueArray);
            Intrinsics.checkNotNull((Object)value);
            double d = ((DoubleValue)value).unbox-impl();
            double d2 = 2.0;
            dArray[n3] = Math.pow(d, d2);
        }
        double[] minDistSquared = dArray;
        while (resultSet.size() < this.k) {
            int i;
            double d;
            void $this$filterIndexedTo$iv$iv;
            double[] $this$filterIndexed$iv = minDistSquared;
            boolean $i$f$filterIndexed = false;
            double[] dArray2 = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            int $i$f$forEachIndexed = 0;
            int index$iv$iv$iv = 0;
            for (void item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n4 = index$iv$iv$iv++;
                d = item$iv$iv$iv;
                int index$iv$iv = n4;
                boolean bl = false;
                int index = index$iv$iv;
                boolean bl2 = false;
                if (!(!taken[index])) continue;
                destination$iv$iv.add((double)element$iv$iv);
            }
            double distSqSum = CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
            double r = this.random.nextDouble() * distSqSum;
            int nextPointIndex = -1;
            double sum = 0.0;
            $i$f$forEachIndexed = points.size();
            for (i = 0; i < $i$f$forEachIndexed; ++i) {
                if (taken[i] || !((sum += minDistSquared[i]) >= r)) continue;
                nextPointIndex = i;
                break;
            }
            if (nextPointIndex == -1) {
                for (i = points.size() - 1; -1 < i; --i) {
                    if (taken[i]) continue;
                    nextPointIndex = i;
                    break;
                }
            }
            if (nextPointIndex < 0) break;
            VectorValue<?> p = points.get(nextPointIndex);
            resultSet.add(new KMeansCluster(p));
            taken[nextPointIndex] = true;
            if (resultSet.size() >= this.k) continue;
            int n5 = points.size();
            for (int j = 0; j < n5; ++j) {
                if (taken[j]) continue;
                Value[] valueArray = new Value[]{(Value)p, (Value)points.get(j)};
                Value value = this.getDistance().invoke(valueArray);
                Intrinsics.checkNotNull((Object)value);
                double d3 = ((DoubleValue)value).unbox-impl();
                d = 2.0;
                double d2 = Math.pow(d3, d);
                if (!(d2 < minDistSquared[j])) continue;
                minDistSquared[j] = d2;
            }
        }
        return resultSet;
    }

    private final VectorValue<?> getNewCenter(List<KMeansCluster> clusters) {
        double maxVariance = Double.NEGATIVE_INFINITY;
        Cluster selected = null;
        for (KMeansCluster cluster : clusters) {
            if (!(!((Collection)cluster.getPoints()).isEmpty())) continue;
            VectorValue<?> center = cluster.getCenter();
            Variance stat = new Variance();
            for (VectorValue<?> point : cluster.getPoints()) {
                Value[] valueArray = new Value[]{(Value)point, (Value)center};
                Value value = this.getDistance().invoke(valueArray);
                Intrinsics.checkNotNull((Object)value);
                stat.increment(((DoubleValue)value).unbox-impl());
            }
            double variance = stat.getResult();
            if (!(variance > maxVariance)) continue;
            maxVariance = variance;
            selected = cluster;
        }
        if (selected == null) {
            throw new ConvergenceException((Localizable)LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        List<VectorValue<?>> list = selected.getPoints();
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type java.util.LinkedList<org.vitrivr.cottontail.core.values.types.VectorValue<*>>");
        LinkedList selectedPoints = (LinkedList)list;
        Object e = selectedPoints.remove(this.random.nextInt(selectedPoints.size()));
        Intrinsics.checkNotNullExpressionValue(e, (String)"selectedPoints.removeAt(\u2026Int(selectedPoints.size))");
        return (VectorValue)e;
    }

    private final VectorValue<?> centroidOf(List<? extends VectorValue<?>> points) {
        VectorValue centroid = (VectorValue)CollectionsKt.first(points);
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            centroid = centroid.plus(points.get(i));
        }
        centroid = centroid.div((NumericValue)IntValue.box-impl((int)IntValue.constructor-impl((int)points.size())));
        return centroid;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/utilities/math/clustering/KMeansClusterer$Companion;", "", "()V", "MAX_ITERATIONS", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\r\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0017\u0010\u000f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/utilities/math/clustering/KMeansClusterer$KMeansCluster;", "Lorg/vitrivr/cottontail/utilities/math/clustering/Cluster;", "center", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "(Lorg/vitrivr/cottontail/core/values/types/VectorValue;)V", "getCenter", "()Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "points", "", "getPoints", "()Ljava/util/List;", "addPoint", "", "point", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cottontaildb-dbms"})
    public static final class KMeansCluster
    implements Cluster {
        @NotNull
        private final VectorValue<?> center;
        @NotNull
        private final List<VectorValue<?>> points;

        public KMeansCluster(@NotNull VectorValue<?> center) {
            Intrinsics.checkNotNullParameter(center, (String)"center");
            this.center = center;
            this.points = new LinkedList();
        }

        @Override
        @NotNull
        public VectorValue<?> getCenter() {
            return this.center;
        }

        @Override
        @NotNull
        public List<VectorValue<?>> getPoints() {
            return this.points;
        }

        @Override
        public void addPoint(@NotNull VectorValue<?> point) {
            Intrinsics.checkNotNullParameter(point, (String)"point");
            List<VectorValue<?>> list = this.getPoints();
            Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type java.util.LinkedList<org.vitrivr.cottontail.core.values.types.VectorValue<*>>");
            ((LinkedList)list).add(point);
        }

        @NotNull
        public final VectorValue<?> component1() {
            return this.getCenter();
        }

        @NotNull
        public final KMeansCluster copy(@NotNull VectorValue<?> center) {
            Intrinsics.checkNotNullParameter(center, (String)"center");
            return new KMeansCluster(center);
        }

        public static /* synthetic */ KMeansCluster copy$default(KMeansCluster kMeansCluster, VectorValue vectorValue, int n, Object object) {
            if ((n & 1) != 0) {
                vectorValue = kMeansCluster.getCenter();
            }
            return kMeansCluster.copy(vectorValue);
        }

        @NotNull
        public String toString() {
            return "KMeansCluster(center=" + this.getCenter() + ')';
        }

        public int hashCode() {
            return this.getCenter().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KMeansCluster)) {
                return false;
            }
            KMeansCluster kMeansCluster = (KMeansCluster)other;
            return Intrinsics.areEqual(this.getCenter(), kMeansCluster.getCenter());
        }
    }
}

