/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.math.random;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.apache.commons.math3.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u001a\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\b\u001a\u001a\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b\u00a8\u0006\t"}, d2={"nextDouble", "", "Lorg/apache/commons/math3/random/RandomGenerator;", "bounds", "origin", "nextInt", "", "nextLong", "", "cottontaildb-dbms"})
public final class RandomGeneratorExtensionKt {
    public static final int nextInt(@NotNull RandomGenerator $this$nextInt, int origin, int bounds) {
        Intrinsics.checkNotNullParameter((Object)$this$nextInt, (String)"<this>");
        if (!(bounds > origin)) {
            boolean bl = false;
            String string = "Bounds must be greater than origin.";
            throw new IllegalArgumentException(string.toString());
        }
        return origin + $this$nextInt.nextInt(Math.abs(bounds - origin));
    }

    public static final long nextLong(@NotNull RandomGenerator $this$nextLong, long bounds) {
        Intrinsics.checkNotNullParameter((Object)$this$nextLong, (String)"<this>");
        return RandomGeneratorExtensionKt.nextLong($this$nextLong, 0L, bounds);
    }

    public static final long nextLong(@NotNull RandomGenerator $this$nextLong, long origin, long bounds) {
        Intrinsics.checkNotNullParameter((Object)$this$nextLong, (String)"<this>");
        if (!(bounds > origin)) {
            boolean bl = false;
            String string = "Bounds must be greater than origin.";
            throw new IllegalArgumentException(string.toString());
        }
        long n = bounds - origin;
        long rnd = 0L;
        if (n > 0L) {
            if ((n & -n) == n) {
                long l;
                int bitCount;
                int nLow = (int)n;
                int nHigh = (int)(n >>> 32);
                if (nLow != 0) {
                    bitCount = 31 - Integer.numberOfLeadingZeros(nLow);
                    l = (long)Random.Default.nextBits(bitCount) & 0xFFFFFFFFL;
                } else if (nHigh == 1) {
                    l = (long)$this$nextLong.nextInt() & 0xFFFFFFFFL;
                } else {
                    bitCount = 31 - Integer.numberOfLeadingZeros(nHigh);
                    l = ((long)Random.Default.nextBits(bitCount) << 32) + ((long)$this$nextLong.nextInt() & 0xFFFFFFFFL);
                }
                rnd = l;
            } else {
                long bits;
                long v = 0L;
                while ((bits = $this$nextLong.nextLong() >>> 1) - (v = bits % n) + (n - 1L) < 0L) {
                }
                rnd = v;
            }
        } else {
            boolean bl;
            do {
                if (origin <= (rnd = $this$nextLong.nextLong())) {
                    if (rnd < bounds) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return rnd;
        }
        return origin + rnd;
    }

    public static final double nextDouble(@NotNull RandomGenerator $this$nextDouble, double bounds) {
        Intrinsics.checkNotNullParameter((Object)$this$nextDouble, (String)"<this>");
        return RandomGeneratorExtensionKt.nextDouble($this$nextDouble, 0.0, bounds);
    }

    public static final double nextDouble(@NotNull RandomGenerator $this$nextDouble, double origin, double bounds) {
        Intrinsics.checkNotNullParameter((Object)$this$nextDouble, (String)"<this>");
        if (!(bounds > origin)) {
            boolean bl = false;
            String string = "Bounds must be greater than origin.";
            throw new IllegalArgumentException(string.toString());
        }
        double r = (double)($this$nextDouble.nextLong() >>> 11) * (double)1.110223E-16f;
        if (origin < bounds && (r = r * (bounds - origin) + origin) >= bounds) {
            r = Double.longBitsToDouble(Double.doubleToLongBits(bounds) - 1L);
        }
        return r;
    }
}

