/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Bitmap;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.IntValue;
import org.vitrivr.cottontail.core.values.LongValue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnMetadata;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.column.FixedLengthColumn;
import org.vitrivr.cottontail.dbms.column.VariableLengthColumn;
import org.vitrivr.cottontail.dbms.entity.DefaultEntityCursor;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityMetadata;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.events.IndexEvent;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.index.basic.Index;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexMetadata;
import org.vitrivr.cottontail.dbms.index.basic.IndexState;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.schema.DefaultSchema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;
import org.vitrivr.cottontail.dbms.sequence.SequenceTx;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "parent", "Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "equals", "", "other", "", "hashCode", "", "newTx", "Lorg/vitrivr/cottontail/dbms/entity/EntityTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "Tx", "cottontaildb-dbms"})
public final class DefaultEntity
implements Entity {
    @NotNull
    private final Name.EntityName name;
    @NotNull
    private final DefaultSchema parent;

    public DefaultEntity(@NotNull Name.EntityName name, @NotNull DefaultSchema parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
    }

    @Override
    @NotNull
    public Name.EntityName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DefaultSchema getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.Companion.current();
    }

    @Override
    @NotNull
    public EntityTx newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        EntityTx entityTx = (EntityTx)context2.getTxn().getCachedTxForDBO(this);
        if (entityTx == null) {
            entityTx = new Tx(context2);
        }
        return entityTx;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DefaultEntity)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((DefaultEntity)other).getCatalogue(), (Object)this.getCatalogue())) {
            return false;
        }
        return Intrinsics.areEqual((Object)((DefaultEntity)other).getName(), (Object)this.getName());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getParent().hashCode();
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J2\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J3\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0'H\u0016\u00a2\u0006\u0002\u0010*J5\u0010$\u001a\u00020+2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'2\u0006\u0010,\u001a\u00020-2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0'H\u0016\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u0002002\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0016J\u0010\u00101\u001a\u0002002\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u00102\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u00103\u001a\u00020&2\u0006\u00104\u001a\u00020&H\u0016J\f\u00105\u001a\u00060\u001bj\u0002`\u001cH\u0016J\u0012\u00106\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0!H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0016J\f\u00108\u001a\u00060\u001bj\u0002`\u001cH\u0002J+\u00109\u001a\u00020&2\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'H\u0016\u00a2\u0006\u0002\u0010:J\f\u0010;\u001a\u00060\u001bj\u0002`\u001cH\u0016J\u0010\u0010<\u001a\u0002002\u0006\u00104\u001a\u00020&H\u0016R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/entity/EntityTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "bitmap", "Ljetbrains/exodus/env/Bitmap;", "Lorg/jetbrains/annotations/NotNull;", "getBitmap$cottontaildb_dbms", "()Ljetbrains/exodus/env/Bitmap;", "columns", "Lit/unimi/dsi/fastutil/objects/Object2ObjectLinkedOpenHashMap;", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "Lorg/vitrivr/cottontail/dbms/column/Column;", "dbo", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "indexes", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "Lorg/vitrivr/cottontail/dbms/index/basic/Index;", "columnForName", "name", "contains", "", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "count", "createIndex", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "", "configuration", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "cursor", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "rename", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;[Lorg/vitrivr/cottontail/core/database/Name$ColumnName;)Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntityCursor;", "partition", "Lkotlin/ranges/LongRange;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;Lkotlin/ranges/LongRange;[Lorg/vitrivr/cottontail/core/database/Name$ColumnName;)Lorg/vitrivr/cottontail/dbms/entity/DefaultEntityCursor;", "delete", "", "dropIndex", "indexForName", "insert", "tuple", "largestTupleId", "listColumns", "listIndexes", "nextTupleId", "read", "(J[Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/core/tuple/Tuple;", "smallestTupleId", "update", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nDefaultEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultEntity.kt\norg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,457:1\n1#2:458\n1549#3:459\n1620#3,3:460\n1549#3:463\n1620#3,3:464\n37#4,2:467\n*S KotlinDebug\n*F\n+ 1 DefaultEntity.kt\norg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx\n*L\n195#1:459\n195#1:460,3\n247#1:463\n247#1:464,3\n375#1:467,2\n*E\n"})
    public final class Tx
    extends AbstractTx
    implements EntityTx {
        @NotNull
        private final Bitmap bitmap;
        @NotNull
        private final Object2ObjectLinkedOpenHashMap<Name.ColumnName, Column<?>> columns;
        @NotNull
        private final Object2ObjectLinkedOpenHashMap<Name.IndexName, Index> indexes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Tx(QueryContext context2) {
            Object object;
            block20: {
                block19: {
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    super(context2);
                    Bitmap bitmap = DefaultEntity.this.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openBitmap(ExtensionsKt.storeName(DefaultEntity.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getTxn().getXodusTx());
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"openBitmap(...)");
                    this.bitmap = bitmap;
                    this.columns = new Object2ObjectLinkedOpenHashMap();
                    this.indexes = new Object2ObjectLinkedOpenHashMap();
                    context2.getTxn().cacheTx(this);
                    Store entityMetadataStore = EntityMetadata.Companion.store(DefaultEntity.this.getCatalogue(), this.getContext().getTxn().getXodusTx());
                    object = entityMetadataStore.get(this.getContext().getTxn().getXodusTx(), NameBinding.Entity.INSTANCE.toEntry(DefaultEntity.this.getName()));
                    if (object == null) break block19;
                    ByteIterable it = object;
                    boolean bl = false;
                    EntityMetadata entityMetadata = EntityMetadata.Companion.fromEntry(it);
                    object = entityMetadata;
                    if (entityMetadata != null) break block20;
                }
                throw new DatabaseException.EntityDoesNotExistException(DefaultEntity.this.getName());
            }
            Object entityMetadata = object;
            Store columnMetadataStore = ColumnMetadata.Companion.store$cottontaildb_dbms(DefaultEntity.this.getCatalogue(), this.getContext().getTxn().getXodusTx());
            for (String c : ((EntityMetadata)entityMetadata).getColumns()) {
                Object object2;
                Name.ColumnName columnName;
                block22: {
                    block21: {
                        columnName = DefaultEntity.this.getName().column(c);
                        object2 = columnMetadataStore.get(this.getContext().getTxn().getXodusTx(), NameBinding.Column.INSTANCE.toEntry(columnName));
                        if (object2 == null) break block21;
                        ByteIterable it = object2;
                        boolean bl = false;
                        ColumnMetadata columnMetadata = ColumnMetadata.Companion.fromEntry(it);
                        object2 = columnMetadata;
                        if (columnMetadata != null) break block22;
                    }
                    throw new DatabaseException.DataCorruptionException("Failed to load specified column " + columnName + " for entity " + DefaultEntity.this.getName());
                }
                Object columnEntry = object2;
                ColumnDef columnDef2 = new ColumnDef(columnName, ((ColumnMetadata)columnEntry).getType(), ((ColumnMetadata)columnEntry).getNullable(), ((ColumnMetadata)columnEntry).getPrimary(), ((ColumnMetadata)columnEntry).getAutoIncrement());
                if (columnDef2.getType() instanceof Types.String || columnDef2.getType() instanceof Types.ByteString) {
                    ((Map)this.columns).put(columnName, new VariableLengthColumn(columnDef2, DefaultEntity.this));
                    continue;
                }
                ((Map)this.columns).put(columnName, new FixedLengthColumn(columnDef2, DefaultEntity.this, ((ColumnMetadata)columnEntry).getCompression()));
            }
            Store indexMetadataStore = IndexMetadata.Companion.store$cottontaildb_dbms(DefaultEntity.this.getCatalogue(), this.getContext().getTxn().getXodusTx());
            Closeable closeable = (Closeable)indexMetadataStore.openCursor(this.getContext().getTxn().getXodusTx());
            DefaultEntity defaultEntity = DefaultEntity.this;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl = false;
                if (it.getSearchKeyRange(NameBinding.Entity.INSTANCE.toEntry(defaultEntity.getName())) != null) {
                    do {
                        ByteIterable byteIterable = it.getKey();
                        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getKey(...)");
                        Name.IndexName indexName = NameBinding.Index.INSTANCE.fromEntry(byteIterable);
                        if (!Intrinsics.areEqual((Object)indexName.entity(), (Object)defaultEntity.getName())) break;
                        ByteIterable byteIterable2 = it.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)byteIterable2, (String)"getValue(...)");
                        IndexMetadata indexEntry = IndexMetadata.Companion.fromEntry(byteIterable2);
                        ((Map)this.indexes).put(indexName, indexEntry.getType().getDescriptor().open(indexName, this.getDbo()));
                    } while (it.getNext());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @Override
        @NotNull
        public DefaultEntity getDbo() {
            return DefaultEntity.this;
        }

        @NotNull
        public final Bitmap getBitmap$cottontaildb_dbms() {
            return this.bitmap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(long tupleId) {
            boolean bl;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl2 = false;
                bl = this.bitmap.get(this.getContext().getTxn().getXodusTx(), tupleId);
            }
            finally {
                lock2.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Tuple read(long tupleId, @NotNull ColumnDef<?>[] columns2) {
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!this.bitmap.get(this.getContext().getTxn().getXodusTx(), tupleId)) {
                    boolean bl2 = false;
                    String string = "Tuple with ID " + tupleId + " does not exist.";
                    throw new IllegalArgumentException(string.toString());
                }
                int n = 0;
                int n2 = columns2.length;
                Value[] valueArray = new Value[n2];
                while (n < n2) {
                    int n3;
                    Name.ColumnName column;
                    Object object;
                    if ((object = (Column)this.columns.get((Object)(column = columns2[n3 = n++].getName()))) == null || (object = object.newTx(this.getContext())) == null) {
                        throw new IllegalArgumentException("Column " + column + " does not exist on entity " + defaultEntity.getName() + ".");
                    }
                    Object columnTx = object;
                    valueArray[n3] = columnTx.read(tupleId);
                }
                Value[] values = valueArray;
                Tuple tuple = (Tuple)new StandaloneTuple(tupleId, columns2, values);
                return tuple;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.bitmap.count(this.getContext().getTxn().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long smallestTupleId() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.bitmap.getFirst(this.getContext().getTxn().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long largestTupleId() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.bitmap.getLast(this.getContext().getTxn().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> listColumns() {
            List list;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                void $this$mapTo$iv$iv;
                boolean bl = false;
                Collection collection = this.columns.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Column column = (Column)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(it.getColumnDef());
                }
                list = (List)destination$iv$iv;
            }
            finally {
                lock2.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Column<?> columnForName(@NotNull Name.ColumnName name) {
            Column column;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                Name.ColumnName fqn = defaultEntity.getName().column(name.getSimple());
                Column column2 = (Column)this.columns.get((Object)fqn);
                if (column2 == null) {
                    throw new DatabaseException.ColumnDoesNotExistException(fqn);
                }
                Column column3 = column2;
                column = column3;
            }
            finally {
                lock2.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)column, (String)"withLock(...)");
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Name.IndexName> listIndexes() {
            List list;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Set set = this.indexes.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                list = CollectionsKt.toList((Iterable)set);
            }
            finally {
                lock2.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Index indexForName(@NotNull Name.IndexName name) {
            Index index;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Index index2 = (Index)this.indexes.get((Object)name);
                if (index2 == null) {
                    throw new DatabaseException.IndexDoesNotExistException((Name)name);
                }
                Index index3 = index2;
                index = index3;
            }
            finally {
                lock2.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"withLock(...)");
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Index createIndex(@NotNull Name.IndexName name, @NotNull IndexType type, @NotNull List<Name.ColumnName> columns2, @NotNull IndexConfig<?> configuration) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)name.entity(), (Object)defaultEntity.getName())) {
                    boolean $i$a$-require-DefaultEntity$Tx$createIndex$1$22 = false;
                    String $i$a$-require-DefaultEntity$Tx$createIndex$1$22 = "Index " + name + " does not belong to entity! This is a programmer's error!";
                    throw new IllegalArgumentException($i$a$-require-DefaultEntity$Tx$createIndex$1$22.toString());
                }
                Store store = IndexMetadata.Companion.store$cottontaildb_dbms(defaultEntity.getCatalogue(), this.getContext().getTxn().getXodusTx());
                IndexState state = this.count() == 0L ? type.getDefaultEmptyState() : IndexState.DIRTY;
                Iterable iterable = columns2;
                IndexState indexState = state;
                IndexType indexType = type;
                boolean $i$f$map = false;
                void var14_17 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Name.ColumnName columnName = (Name.ColumnName)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getColumn());
                }
                collection = (List)destination$iv$iv;
                IndexConfig<?> indexConfig = configuration;
                List list = collection;
                IndexState indexState2 = indexState;
                IndexType indexType2 = indexType;
                IndexMetadata indexEntry = new IndexMetadata(indexType2, indexState2, list, indexConfig);
                if (!store.add(this.getContext().getTxn().getXodusTx(), NameBinding.Index.INSTANCE.toEntry(name), IndexMetadata.Companion.toEntry(indexEntry))) {
                    throw new DatabaseException.IndexAlreadyExistsException(name);
                }
                if (!type.getDescriptor().initialize(name, this.getDbo().getCatalogue(), this.getContext().getTxn())) {
                    throw new DatabaseException.DataCorruptionException("CREATE index " + name + " failed: Failed to initialize store.");
                }
                Object ret = type.getDescriptor().open(name, defaultEntity);
                ((Map)this.indexes).put(name, ret);
                this.getContext().getTxn().signalEvent(new IndexEvent.Created(name, type));
                Object obj = ret;
                return obj;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropIndex(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = IndexMetadata.Companion.store$cottontaildb_dbms(defaultEntity.getCatalogue(), this.getContext().getTxn().getXodusTx());
                ByteIterable byteIterable = store.get(this.getContext().getTxn().getXodusTx(), NameBinding.Index.INSTANCE.toEntry(name));
                if (byteIterable == null) {
                    throw new DatabaseException.IndexDoesNotExistException((Name)name);
                }
                ByteIterable byteIterable2 = byteIterable;
                Intrinsics.checkNotNull((Object)byteIterable2);
                ByteIterable metadataRaw = byteIterable2;
                IndexMetadata metadata = IndexMetadata.Companion.fromEntry(metadataRaw);
                if (!store.delete(this.getContext().getTxn().getXodusTx(), NameBinding.Index.INSTANCE.toEntry(name))) {
                    throw new DatabaseException.IndexDoesNotExistException((Name)name);
                }
                if (!metadata.getType().getDescriptor().deinitialize(name, this.getDbo().getCatalogue(), this.getContext().getTxn())) {
                    throw new DatabaseException.DataCorruptionException("DROP index " + name + " failed: Failed to de-initialize store.");
                }
                this.indexes.remove((Object)name);
                this.getContext().getTxn().signalEvent(new IndexEvent.Dropped(name, metadata.getType()));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Tuple> cursor(@NotNull ColumnDef<?>[] columns2, @NotNull Name.ColumnName[] rename) {
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)rename, (String)"rename");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                org.vitrivr.cottontail.core.basics.Cursor cursor = this.cursor((ColumnDef[])columns2, new LongRange(this.smallestTupleId(), this.largestTupleId()), rename);
                return cursor;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public DefaultEntityCursor cursor(@NotNull ColumnDef<?>[] columns2, @NotNull LongRange partition, @NotNull Name.ColumnName[] rename) {
            DefaultEntityCursor defaultEntityCursor;
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Intrinsics.checkNotNullParameter((Object)rename, (String)"rename");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                defaultEntityCursor = new DefaultEntityCursor(this, columns2, partition, rename);
            }
            finally {
                lock2.unlock();
            }
            return defaultEntityCursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public Tuple insert(@NotNull Tuple tuple) {
            Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                long tupleId = this.nextTupleId();
                Object2ObjectArrayMap inserts = new Object2ObjectArrayMap(this.columns.size());
                this.bitmap.set(this.getContext().getTxn().getXodusTx(), tupleId, true);
                for (Column column : (ObjectCollection)this.columns.values()) {
                    Value value;
                    if (column.getColumnDef().getAutoIncrement()) {
                        Name.SequenceName sequenceName;
                        if (column.getName().autoincrement() == null) {
                            throw new IllegalStateException("");
                        }
                        SchemaTx schemaTx = defaultEntity.getParent().newTx(this.getContext());
                        SequenceTx sequenceTx = schemaTx.sequenceForName(sequenceName).newTx(this.getContext());
                        Types types = column.getType();
                        if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
                            value = IntValue.box-impl((int)LongValue.asInt-XzlYvWs((long)sequenceTx.next-hRrSGgQ()));
                        } else {
                            if (!Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) throw new IllegalStateException("Columns of types " + column.getType() + " do not allow for serial values. This is a programmer's error!");
                            value = LongValue.box-impl((long)sequenceTx.next-hRrSGgQ());
                        }
                    } else if (column.getColumnDef().getNullable()) {
                        value = tuple.get(column.getColumnDef());
                    } else {
                        value = tuple.get(column.getColumnDef());
                        if (value == null) {
                            throw new DatabaseException.ValidationException("Cannot INSERT a NULL value into column " + column.getColumnDef() + ".");
                        }
                    }
                    Value value2 = value;
                    ((Map)inserts).put(column.getColumnDef(), value2);
                    if (value2 == null) continue;
                    ColumnTx<Value> columnTx = column.newTx(this.getContext());
                    Intrinsics.checkNotNull(columnTx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<org.vitrivr.cottontail.core.types.Value>");
                    columnTx.write(tupleId, value2);
                }
                DataEvent.Insert event = new DataEvent.Insert(defaultEntity.getName(), tupleId, (Map)inserts);
                for (Index index : (ObjectCollection)this.indexes.values()) {
                    index.newTx(this.getContext()).insert(event);
                }
                this.getContext().getTxn().signalEvent(event);
                Set set = inserts.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                Collection $this$toTypedArray$iv = set;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Collection collection = inserts.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
                $this$toTypedArray$iv = collection;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                Tuple tuple2 = (Tuple)new StandaloneTuple(tupleId, thisCollection$iv.toArray(new ColumnDef[0]), thisCollection$iv.toArray(new Value[0]));
                return tuple2;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(@NotNull Tuple tuple) {
            Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                Object2ObjectArrayMap updates = new Object2ObjectArrayMap(tuple.getColumns().length);
                for (ColumnDef def : tuple.getColumns()) {
                    Object object;
                    ColumnTx<Value> columnTx;
                    Column column;
                    if ((Column)this.columns.get((Object)def.getName()) == null) {
                        throw new DatabaseException.ColumnDoesNotExistException(def.getName());
                    }
                    Intrinsics.checkNotNull((Object)column);
                    Column column2 = column;
                    Intrinsics.checkNotNull(column2.newTx(this.getContext()), (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<org.vitrivr.cottontail.core.types.Value>");
                    Value value = tuple.get(def);
                    if (value == null) {
                        if (!def.getNullable()) {
                            throw new DatabaseException.ValidationException("Record " + tuple.getTupleId() + " cannot be updated with NULL value for column " + def + ", because column is not nullable.");
                        }
                        object = columnTx.delete(tuple.getTupleId());
                    } else {
                        object = columnTx.write(tuple.getTupleId(), value);
                    }
                    Value oldValue = object;
                    ((Map)updates).put(def, new Pair((Object)oldValue, (Object)value));
                }
                DataEvent.Update event = new DataEvent.Update(defaultEntity.getName(), tuple.getTupleId(), (Map)updates);
                for (Index index : (ObjectCollection)this.indexes.values()) {
                    index.newTx(this.getContext()).update(event);
                }
                this.getContext().getTxn().signalEvent(event);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete(long tupleId) {
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                Object2ObjectArrayMap deleted = new Object2ObjectArrayMap(this.columns.size());
                for (Column column : (ObjectCollection)this.columns.values()) {
                    ((Map)deleted).put(column.getColumnDef(), column.newTx(this.getContext()).delete(tupleId));
                }
                this.bitmap.set(this.getContext().getTxn().getXodusTx(), tupleId, false);
                DataEvent.Delete event = new DataEvent.Delete(defaultEntity.getName(), tupleId, (Map)deleted);
                for (Index index : (ObjectCollection)this.indexes.values()) {
                    index.newTx(this.getContext()).delete(event);
                }
                this.getContext().getTxn().signalEvent(event);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final long nextTupleId() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                long next;
                boolean bl = false;
                Transaction txn = this.getContext().getTxn().getXodusTx();
                long smallest = this.bitmap.getFirst(txn);
                l = next = smallest == -1L ? 0L : (smallest > 0L ? smallest - 1L : this.bitmap.getLast(txn) + 1L);
            }
            finally {
                lock2.unlock();
            }
            return l;
        }
    }
}

