/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.execution.operators.basics;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.dbms.execution.exceptions.OperatorSetupException;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H&R\u001c\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00060\rj\u0002`\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0001\u0004\u001c\u001d\u001e\u001f\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "", "()V", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumns", "()Ljava/util/List;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "getContext", "()Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "groupId", "", "Lorg/vitrivr/cottontail/core/queries/GroupId;", "getGroupId", "()I", "identifier", "", "getIdentifier", "()Ljava/lang/CharSequence;", "toFlow", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "MergingPipelineOperator", "PipelineOperator", "SinkOperator", "SourceOperator", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator$MergingPipelineOperator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator$PipelineOperator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator$SinkOperator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator$SourceOperator;", "cottontaildb-dbms"})
public abstract class Operator {
    @NotNull
    private final CharSequence identifier = UUID.randomUUID().toString().subSequence(0, 7);

    private Operator() {
    }

    @NotNull
    public abstract QueryContext getContext();

    public abstract int getGroupId();

    @NotNull
    public abstract List<ColumnDef<?>> getColumns();

    @NotNull
    public final CharSequence getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public abstract Flow<Tuple> toFlow();

    public /* synthetic */ Operator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator$MergingPipelineOperator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "parents", "", "(Ljava/util/List;)V", "breaker", "", "getBreaker", "()Z", "groupId", "", "Lorg/vitrivr/cottontail/core/queries/GroupId;", "getGroupId", "()I", "getParents", "()Ljava/util/List;", "cottontaildb-dbms"})
    public static abstract class MergingPipelineOperator
    extends Operator {
        @NotNull
        private final List<Operator> parents;

        public MergingPipelineOperator(@NotNull List<? extends Operator> parents) {
            Intrinsics.checkNotNullParameter(parents, (String)"parents");
            super(null);
            this.parents = parents;
            if (this.parents.size() <= 1) {
                throw new OperatorSetupException(this, "The use of an MergingPipelineOperator requires at least two inputs.");
            }
        }

        @NotNull
        public final List<Operator> getParents() {
            return this.parents;
        }

        public abstract boolean getBreaker();

        @Override
        public int getGroupId() {
            return this.parents.get(0).getGroupId();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator$PipelineOperator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "parent", "(Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;)V", "breaker", "", "getBreaker", "()Z", "groupId", "", "Lorg/vitrivr/cottontail/core/queries/GroupId;", "getGroupId", "()I", "getParent", "()Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "cottontaildb-dbms"})
    public static abstract class PipelineOperator
    extends Operator {
        @NotNull
        private final Operator parent;

        public PipelineOperator(@NotNull Operator parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(null);
            this.parent = parent;
        }

        @NotNull
        public final Operator getParent() {
            return this.parent;
        }

        public abstract boolean getBreaker();

        @Override
        public int getGroupId() {
            return this.parent.getGroupId();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator$SinkOperator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "parent", "(Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;)V", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumns", "()Ljava/util/List;", "groupId", "", "Lorg/vitrivr/cottontail/core/queries/GroupId;", "getGroupId", "()I", "getParent", "()Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "cottontaildb-dbms"})
    public static abstract class SinkOperator
    extends Operator {
        @NotNull
        private final Operator parent;
        @NotNull
        private final List<ColumnDef<?>> columns;

        public SinkOperator(@NotNull Operator parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(null);
            this.parent = parent;
            this.columns = CollectionsKt.emptyList();
        }

        @NotNull
        public final Operator getParent() {
            return this.parent;
        }

        @Override
        @NotNull
        public final List<ColumnDef<?>> getColumns() {
            return this.columns;
        }

        @Override
        public int getGroupId() {
            return this.parent.getGroupId();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator$SourceOperator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "groupId", "", "Lorg/vitrivr/cottontail/core/queries/GroupId;", "(I)V", "getGroupId", "()I", "cottontaildb-dbms"})
    public static abstract class SourceOperator
    extends Operator {
        private final int groupId;

        public SourceOperator(int groupId) {
            super(null);
            this.groupId = groupId;
        }

        public /* synthetic */ SourceOperator(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            this(n);
        }

        @Override
        public int getGroupId() {
            return this.groupId;
        }

        public SourceOperator() {
            this(0, 1, null);
        }
    }
}

