/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.basic;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexState;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\r\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\nH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\b\u0002\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/index/basic/IndexMetadata;", "", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "state", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexState;", "columns", "", "", "config", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "(Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;Lorg/vitrivr/cottontail/dbms/index/basic/IndexState;Ljava/util/List;Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;)V", "getColumns", "()Ljava/util/List;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "getState", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexState;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "cottontaildb-dbms"})
public final class IndexMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    @NotNull
    private final IndexState state;
    @NotNull
    private final List<String> columns;
    @NotNull
    private final IndexConfig<?> config;
    @NotNull
    private static final String CATALOGUE_INDEX_STORE_NAME = "org.vitrivr.cottontail.indexes";

    public IndexMetadata(@NotNull IndexType type, @NotNull IndexState state, @NotNull List<String> columns2, @NotNull IndexConfig<?> config) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.type = type;
        this.state = state;
        this.columns = columns2;
        this.config = config;
    }

    @NotNull
    public final IndexType getType() {
        return this.type;
    }

    @NotNull
    public final IndexState getState() {
        return this.state;
    }

    @NotNull
    public final List<String> getColumns() {
        return this.columns;
    }

    @NotNull
    public final IndexConfig<?> getConfig() {
        return this.config;
    }

    @NotNull
    public final IndexType component1() {
        return this.type;
    }

    @NotNull
    public final IndexState component2() {
        return this.state;
    }

    @NotNull
    public final List<String> component3() {
        return this.columns;
    }

    @NotNull
    public final IndexConfig<?> component4() {
        return this.config;
    }

    @NotNull
    public final IndexMetadata copy(@NotNull IndexType type, @NotNull IndexState state, @NotNull List<String> columns2, @NotNull IndexConfig<?> config) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        return new IndexMetadata(type, state, columns2, config);
    }

    public static /* synthetic */ IndexMetadata copy$default(IndexMetadata indexMetadata, IndexType indexType, IndexState indexState, List list, IndexConfig indexConfig, int n, Object object) {
        if ((n & 1) != 0) {
            indexType = indexMetadata.type;
        }
        if ((n & 2) != 0) {
            indexState = indexMetadata.state;
        }
        if ((n & 4) != 0) {
            list = indexMetadata.columns;
        }
        if ((n & 8) != 0) {
            indexConfig = indexMetadata.config;
        }
        return indexMetadata.copy(indexType, indexState, list, indexConfig);
    }

    @NotNull
    public String toString() {
        return "IndexMetadata(type=" + this.type + ", state=" + this.state + ", columns=" + this.columns + ", config=" + this.config + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.state.hashCode();
        result = result * 31 + ((Object)this.columns).hashCode();
        result = result * 31 + this.config.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexMetadata)) {
            return false;
        }
        IndexMetadata indexMetadata = (IndexMetadata)other;
        if (this.type != indexMetadata.type) {
            return false;
        }
        if (this.state != indexMetadata.state) {
            return false;
        }
        if (!Intrinsics.areEqual(this.columns, indexMetadata.columns)) {
            return false;
        }
        return Intrinsics.areEqual(this.config, indexMetadata.config);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/dbms/index/basic/IndexMetadata$Companion;", "", "()V", "CATALOGUE_INDEX_STORE_NAME", "", "fromEntry", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexMetadata;", "entry", "Ljetbrains/exodus/ByteIterable;", "init", "", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "transaction", "Ljetbrains/exodus/env/Transaction;", "init$cottontaildb_dbms", "store", "Ljetbrains/exodus/env/Store;", "store$cottontaildb_dbms", "toEntry", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nIndexMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexMetadata.kt\norg/vitrivr/cottontail/dbms/index/basic/IndexMetadata$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1549#2:87\n1620#2,3:88\n*S KotlinDebug\n*F\n+ 1 IndexMetadata.kt\norg/vitrivr/cottontail/dbms/index/basic/IndexMetadata$Companion\n*L\n57#1:87\n57#1:88,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void init$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(IndexMetadata.CATALOGUE_INDEX_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to create store for index catalogue.");
            }
        }

        @NotNull
        public final Store store$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(IndexMetadata.CATALOGUE_INDEX_STORE_NAME, StoreConfig.USE_EXISTING, transaction, false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open store for index catalogue.");
            }
            return store;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IndexMetadata fromEntry(@NotNull ByteIterable entry) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            ByteArraySizedInputStream stream = new ByteArraySizedInputStream(entry.getBytesUnsafe(), 0, entry.getLength());
            IndexType type = IndexType.values()[IntegerBinding.readCompressed((ByteArrayInputStream)((ByteArrayInputStream)stream))];
            IndexState state = IndexState.values()[IntegerBinding.readCompressed((ByteArrayInputStream)((ByteArrayInputStream)stream))];
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)IntegerBinding.readCompressed((ByteArrayInputStream)((ByteArrayInputStream)stream)));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringBinding.BINDING.readObject((ByteArrayInputStream)stream));
            }
            List columns2 = (List)destination$iv$iv;
            Comparable comparable = type.getDescriptor().configBinding().readObject((ByteArrayInputStream)stream);
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.basic.IndexConfig<*>");
            IndexConfig config = (IndexConfig)comparable;
            return new IndexMetadata(type, state, columns2, config);
        }

        @NotNull
        public final ByteIterable toEntry(@NotNull IndexMetadata entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            LightOutputStream output = new LightOutputStream();
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)entry.getType().ordinal());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)entry.getState().ordinal());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)entry.getColumns().size());
            for (String columnName : entry.getColumns()) {
                StringBinding.BINDING.writeObject(output, (Comparable)((Object)columnName));
            }
            entry.getType().getDescriptor().configBinding().writeObject(output, (Comparable)entry.getConfig());
            ArrayByteIterable arrayByteIterable = output.asArrayByteIterable();
            Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"asArrayByteIterable(...)");
            return (ByteIterable)arrayByteIterable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

