/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lsh;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.binding.Binding;
import org.vitrivr.cottontail.core.queries.binding.BindingContext;
import org.vitrivr.cottontail.core.queries.binding.MissingTuple;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.CosineDistance;
import org.vitrivr.cottontail.core.queries.nodes.traits.LimitTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.NotPartitionableTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.OrderTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.Trait;
import org.vitrivr.cottontail.core.queries.nodes.traits.TraitType;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.index.basic.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.basic.IndexConfig;
import org.vitrivr.cottontail.dbms.index.basic.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.basic.IndexTx;
import org.vitrivr.cottontail.dbms.index.basic.IndexType;
import org.vitrivr.cottontail.dbms.index.basic.rebuilder.AsyncIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.lsh.LSHDataStore;
import org.vitrivr.cottontail.dbms.index.lsh.LSHIndexConfig;
import org.vitrivr.cottontail.dbms.index.lsh.LSHIndexRebuilder;
import org.vitrivr.cottontail.dbms.index.lsh.signature.LSHSignature;
import org.vitrivr.cottontail.dbms.index.lsh.signature.LSHSignatureGenerator;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "type", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/basic/IndexType;", "newAsyncRebuilder", "Lorg/vitrivr/cottontail/dbms/index/basic/rebuilder/AsyncIndexRebuilder;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "newRebuilder", "Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndexRebuilder;", "newTx", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexTx;", "Companion", "Tx", "cottontaildb-dbms"})
public final class LSHIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    @NotNull
    private static final Logger LOGGER;
    private static final boolean supportsIncrementalUpdate;
    private static final boolean supportsAsyncRebuild;
    private static final boolean supportsPartitioning;

    public LSHIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.type = IndexType.LSH;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IndexTx indexTx = (IndexTx)context2.getTxn().getCachedTxForDBO(this);
        if (indexTx == null) {
            indexTx = new Tx(context2);
        }
        return indexTx;
    }

    @NotNull
    public LSHIndexRebuilder newRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new LSHIndexRebuilder(this, context2);
    }

    @Override
    @NotNull
    public AsyncIndexRebuilder<?> newAsyncRebuilder(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        throw new UnsupportedOperationException("LSHIndex does not support asynchronous index rebuilding.");
    }

    static {
        Logger logger = LoggerFactory.getLogger(LSHIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        supportsIncrementalUpdate = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "supportsAsyncRebuild", "", "getSupportsAsyncRebuild", "()Z", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "supportsPartitioning", "getSupportsPartitioning", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/basic/IndexConfig;", "parameters", "", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "initialize", "open", "entity", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nLSHIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LSHIndex.kt\norg/vitrivr/cottontail/dbms/index/lsh/LSHIndex$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,361:1\n1#2:362\n*E\n"})
    public static final class Companion
    implements IndexDescriptor<LSHIndex> {
        private Companion() {
        }

        @Override
        public boolean getSupportsIncrementalUpdate() {
            return supportsIncrementalUpdate;
        }

        @Override
        public boolean getSupportsAsyncRebuild() {
            return supportsAsyncRebuild;
        }

        @Override
        public boolean getSupportsPartitioning() {
            return supportsPartitioning;
        }

        @Override
        @NotNull
        public LSHIndex open(@NotNull Name.IndexName name, @NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new LSHIndex(name, (DefaultEntity)entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull org.vitrivr.cottontail.dbms.execution.transactions.Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(name), StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, context2.getXodusTx(), true);
                bl = store != null;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to initialize LSH index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull Catalogue catalogue, @NotNull org.vitrivr.cottontail.dbms.execution.transactions.Transaction context2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            try {
                catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(name), context2.getXodusTx());
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to de-initialize LSH index " + name + " due to an exception: " + e.getMessage() + ".");
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<LSHIndex> buildConfig(@NotNull Map<String, String> parameters) {
            String string;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                    string = parameters.get("lsh.distance");
                    if (string == null) break block2;
                    String it = string;
                    boolean bl = false;
                    Name.FunctionName functionName = Name.FunctionName.Companion.create(it);
                    string = functionName;
                    if (functionName != null) break block3;
                }
                string = LSHIndexConfig.Companion.getDEFAULT_DISTANCE();
            }
            String string2 = parameters.get("lsh.buckets");
            String string3 = parameters.get("lsh.stages");
            String string4 = parameters.get("lsh.seed");
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 16;
            LSHSignatureGenerator lSHSignatureGenerator = null;
            long l = string4 != null ? Long.parseLong(string4) : System.currentTimeMillis();
            int n2 = string3 != null ? Integer.parseInt(string3) : 5;
            int n3 = string2 != null ? Integer.parseInt(string2) : 50;
            String string5 = string;
            return new LSHIndexConfig((Name.FunctionName)string5, n3, n2, l, lSHSignatureGenerator, n, defaultConstructorMarker);
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return LSHIndexConfig.Binding.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\"H\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020#H\u0016R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/basic/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "store", "Lorg/vitrivr/cottontail/dbms/index/lsh/LSHDataStore;", "Ljetbrains/exodus/env/Store;", "canProcess", "", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "partition", "Lkotlin/ranges/LongRange;", "traitsFor", "", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/TraitType;", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/Trait;", "tryApply", "event", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Delete;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Insert;", "Lorg/vitrivr/cottontail/dbms/events/DataEvent$Update;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nLSHIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LSHIndex.kt\norg/vitrivr/cottontail/dbms/index/lsh/LSHIndex$Tx\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,361:1\n1#2:362\n*E\n"})
    private final class Tx
    extends AbstractIndex.Tx {
        @NotNull
        private final Store store;

        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(LSHIndex.this, context2);
            this.store = LSHDataStore.Companion.open-J-uqb8w$cottontaildb_dbms(this.getContext().getTxn().getXodusTx(), LSHIndex.this);
        }

        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof ProximityPredicate)) {
                boolean bl = false;
                String string = "LSHIndex can only process proximity predicates.";
                throw new IllegalArgumentException(string.toString());
            }
            return CollectionsKt.emptyList();
        }

        public boolean canProcess(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return predicate instanceof ProximityPredicate && ((ProximityPredicate)predicate).getDistance() instanceof CosineDistance && Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn().getPhysical(), this.getColumns()[0]);
        }

        @Override
        @NotNull
        public Map<TraitType<?>, Trait> traitsFor(@NotNull Predicate predicate) {
            Map map2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Predicate predicate2 = predicate;
            if (predicate2 instanceof ProximityPredicate.NNS) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)OrderTrait.Companion, (Object)new OrderTrait(CollectionsKt.listOf((Object)TuplesKt.to((Object)((ProximityPredicate.NNS)predicate).getDistanceColumn(), (Object)SortOrder.ASCENDING)))), TuplesKt.to((Object)LimitTrait.Companion, (Object)new LimitTrait(((ProximityPredicate.NNS)predicate).getK())), TuplesKt.to((Object)NotPartitionableTrait.INSTANCE, (Object)NotPartitionableTrait.INSTANCE)};
                map2 = MapsKt.mutableMapOf((Pair[])pairArray);
            } else if (predicate2 instanceof ProximityPredicate.FNS) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)OrderTrait.Companion, (Object)new OrderTrait(CollectionsKt.listOf((Object)TuplesKt.to((Object)((ProximityPredicate.FNS)predicate).getDistanceColumn(), (Object)SortOrder.DESCENDING)))), TuplesKt.to((Object)LimitTrait.Companion, (Object)new LimitTrait(((ProximityPredicate.FNS)predicate).getK())), TuplesKt.to((Object)NotPartitionableTrait.INSTANCE, (Object)NotPartitionableTrait.INSTANCE)};
                map2 = MapsKt.mutableMapOf((Pair[])pairArray);
            } else {
                throw new IllegalArgumentException("Unsupported predicate for high-dimensional index. This is a programmer's error!");
            }
            return map2;
        }

        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryApply(@NotNull DataEvent.Insert event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Lock lock2 = this.getTxLatch();
            LSHIndex lSHIndex = LSHIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                IndexConfig<?> indexConfig = this.getConfig();
                Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.lsh.LSHIndexConfig");
                LSHSignatureGenerator lSHSignatureGenerator = ((LSHIndexConfig)indexConfig).getGenerator();
                if (lSHSignatureGenerator == null) {
                    throw new IllegalStateException("Failed to obtain LSHSignatureGenerator for index " + lSHIndex.getName() + ". This is a programmer's error!");
                }
                LSHSignatureGenerator generator = lSHSignatureGenerator;
                Value value = event.getData().get(this.getColumns()[0]);
                if (!(value instanceof VectorValue)) {
                    boolean bl2 = false;
                    String string = "Failed to add " + value + " to LSHIndex. Incoming value is not a vector! This is a programmer's error!";
                    throw new IllegalStateException(string.toString());
                }
                boolean bl3 = LSHDataStore.addMapping-VIKXU4c(this.store, this.getContext().getTxn().getXodusTx(), generator.generate-dna7En8((VectorValue)value), event.getTupleId());
                return bl3;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean tryApply(@NotNull DataEvent.Update event) {
            Pair<Value, Value> value;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            IndexConfig<?> indexConfig = this.getConfig();
            Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.lsh.LSHIndexConfig");
            LSHSignatureGenerator lSHSignatureGenerator = ((LSHIndexConfig)indexConfig).getGenerator();
            if (lSHSignatureGenerator == null) {
                throw new IllegalStateException("Failed to obtain LSHSignatureGenerator for index " + LSHIndex.this.getName() + ". This is a programmer's error!");
            }
            LSHSignatureGenerator generator = lSHSignatureGenerator;
            Pair<Value, Value> pair = value = event.getData().get(this.getColumns()[0]);
            if (!((pair != null ? (Value)pair.getFirst() : null) instanceof VectorValue)) {
                boolean $i$a$-check-LSHIndex$Tx$tryApply$42 = false;
                String $i$a$-check-LSHIndex$Tx$tryApply$42 = "Failed to add " + value + " to LSHIndex. Incoming value is not a vector! This is a programmer's error!";
                throw new IllegalStateException($i$a$-check-LSHIndex$Tx$tryApply$42.toString());
            }
            Pair<Value, Value> pair2 = value;
            if (!((pair2 != null ? (Value)pair2.getSecond() : null) instanceof VectorValue)) {
                boolean bl = false;
                String string = "Failed to add " + value + " to LSHIndex. Incoming value is not a vector! This is a programmer's error!";
                throw new IllegalStateException(string.toString());
            }
            Transaction transaction = this.getContext().getTxn().getXodusTx();
            Pair<Value, Value> pair3 = value;
            Intrinsics.checkNotNull(pair3);
            Object object = pair3.getFirst();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.types.VectorValue<*>");
            if (!LSHDataStore.removeMapping-VIKXU4c(this.store, transaction, generator.generate-dna7En8((VectorValue)object), event.getTupleId())) return false;
            Transaction transaction2 = this.getContext().getTxn().getXodusTx();
            Object object2 = value.getSecond();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.types.VectorValue<*>");
            if (!LSHDataStore.addMapping-VIKXU4c(this.store, transaction2, generator.generate-dna7En8((VectorValue)object2), event.getTupleId())) return false;
            return true;
        }

        @Override
        public boolean tryApply(@NotNull DataEvent.Delete event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            IndexConfig<?> indexConfig = this.getConfig();
            Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.lsh.LSHIndexConfig");
            LSHSignatureGenerator lSHSignatureGenerator = ((LSHIndexConfig)indexConfig).getGenerator();
            if (lSHSignatureGenerator == null) {
                throw new IllegalStateException("Failed to obtain LSHSignatureGenerator for index " + LSHIndex.this.getName() + ". This is a programmer's error!");
            }
            LSHSignatureGenerator generator = lSHSignatureGenerator;
            Value value = event.getData().get(this.getColumns()[0]);
            if (!(value instanceof VectorValue)) {
                boolean bl = false;
                String string = "Failed to add " + value + " to LSHIndex. Incoming value is not a vector! This is a programmer's error!";
                throw new IllegalStateException(string.toString());
            }
            return LSHDataStore.removeMapping-VIKXU4c(this.store, this.getContext().getTxn().getXodusTx(), generator.generate-dna7En8((VectorValue)value), event.getTupleId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.store.count(this.getContext().getTxn().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Tuple> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return (org.vitrivr.cottontail.core.basics.Cursor)new org.vitrivr.cottontail.core.basics.Cursor<Tuple>(predicate, LSHIndex.this, this){
                @NotNull
                private final ProximityPredicate predicate;
                private final Transaction subTx;
                private final Cursor cursor;
                {
                    IndexConfig<?> config;
                    block7: {
                        block6: {
                            if (!($predicate instanceof ProximityPredicate)) {
                                throw new QueryException.UnsupportedPredicateException("Index '" + $receiver.getName() + "' (LSH Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($predicate.getClass()).getSimpleName() + "'.");
                            }
                            this.predicate = (ProximityPredicate)$predicate;
                            this.subTx = $receiver2.getContext().getTxn().getXodusTx().getReadonlySnapshot();
                            this.cursor = Tx.access$getStore$p($receiver2).openCursor(this.subTx);
                            config = $receiver2.getConfig();
                            if (!Intrinsics.areEqual((Object)((Binding.Column)CollectionsKt.first((Iterable)this.predicate.getColumns())).getPhysical(), $receiver2.getColumns()[0])) break block6;
                            Name.FunctionName functionName = this.predicate.getDistance().getName();
                            Intrinsics.checkNotNull(config, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.lsh.LSHIndexConfig");
                            if (Intrinsics.areEqual((Object)functionName, (Object)((LSHIndexConfig)config).getDistance())) break block7;
                        }
                        throw new QueryException.UnsupportedPredicateException("Index '" + $receiver.getName() + "' (lsh-index) does not support the provided predicate.");
                    }
                    MissingTuple $this$_init__u24lambda_u243 = MissingTuple.INSTANCE;
                    boolean bl = false;
                    BindingContext $this$lambda_u243_u24lambda_u242 = $receiver2.getContext().getBindings();
                    boolean bl2 = false;
                    Value value = ((ProximityPredicate)$predicate).getQuery().getValue($this$lambda_u243_u24lambda_u242, (Tuple)$this$_init__u24lambda_u243);
                    if (!(value instanceof VectorValue)) {
                        boolean bl3 = false;
                        Value value2 = value;
                        String string = "Bound value for query vector has wrong type (found = " + (Types)(value2 != null ? value2.getType() : null) + ").";
                        throw new IllegalStateException(string.toString());
                    }
                    LSHSignatureGenerator lSHSignatureGenerator = ((LSHIndexConfig)config).getGenerator();
                    int[] signature = lSHSignatureGenerator != null ? lSHSignatureGenerator.generate-dna7En8((VectorValue)value) : null;
                    if (!(signature != null)) {
                        boolean bl4 = false;
                        String string = "Failed to generate signature for query vector.";
                        throw new IllegalStateException(string.toString());
                    }
                    this.cursor.getSearchKey((ByteIterable)LSHSignature.Binding.INSTANCE.objectToEntry(signature != null ? LSHSignature.box-impl(signature) : null));
                }

                public boolean moveNext() {
                    return this.cursor.getNextDup();
                }

                @NotNull
                public Tuple next() {
                    return this.value();
                }

                @NotNull
                public Tuple value() {
                    boolean $i$f$emptyArray = false;
                    $i$f$emptyArray = false;
                    return (Tuple)new StandaloneTuple(this.key(), new ColumnDef[0], new Value[0]);
                }

                public long key() {
                    return LongBinding.compressedEntryToLong((ByteIterable)this.cursor.getValue());
                }

                public void close() {
                    this.cursor.close();
                    this.subTx.commit();
                }

                public boolean hasNext() {
                    return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
                }

                public boolean movePrevious() {
                    return Cursor.DefaultImpls.movePrevious((org.vitrivr.cottontail.core.basics.Cursor)this);
                }

                public boolean moveTo(long tupleId) {
                    return Cursor.DefaultImpls.moveTo((org.vitrivr.cottontail.core.basics.Cursor)this, (long)tupleId);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Tuple> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("The LSHIndex does not support ranged filtering!");
        }

        public static final /* synthetic */ Store access$getStore$p(Tx $this) {
            return $this.store;
        }
    }
}

