/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lucene;

import java.io.Closeable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.storage.lucene.XodusDirectory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\b\u0010!\u001a\u00020\u0019H\u0002J\b\u0010\"\u001a\u00020\u0019H\u0016J\u0012\u0010#\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cJ&\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J$\u0010(\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u00f8\u0001\u0000\u00a2\u0006\u0004\b)\u0010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006*"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndexDataStore;", "Ljava/io/Closeable;", "directory", "Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;", "indexedColumn", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "(Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;Lorg/vitrivr/cottontail/core/database/Name$ColumnName;)V", "closed", "", "getDirectory", "()Lorg/vitrivr/cottontail/storage/lucene/XodusDirectory;", "indexReader", "Lorg/apache/lucene/index/IndexReader;", "getIndexReader", "()Lorg/apache/lucene/index/IndexReader;", "indexReader$delegate", "Lkotlin/Lazy;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "getIndexWriter", "()Lorg/apache/lucene/index/IndexWriter;", "indexWriter$delegate", "readerInitialized", "writerInitialized", "addDocument", "", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "value", "Lorg/vitrivr/cottontail/core/values/StringValue;", "addDocument-2g0_blE", "(JLjava/lang/String;)V", "checkAndFlush", "close", "deleteDocument", "documentFromValue", "Lorg/apache/lucene/document/Document;", "documentFromValue-RAUCjew", "(Ljava/lang/String;J)Lorg/apache/lucene/document/Document;", "updateDocument", "updateDocument-2g0_blE", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nLuceneIndexDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneIndexDataStore.kt\norg/vitrivr/cottontail/dbms/index/lucene/LuceneIndexDataStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class LuceneIndexDataStore
implements Closeable {
    @NotNull
    private final XodusDirectory directory;
    @NotNull
    private final Name.ColumnName indexedColumn;
    private volatile boolean readerInitialized;
    private volatile boolean writerInitialized;
    private volatile boolean closed;
    @NotNull
    private final Lazy indexWriter$delegate;
    @NotNull
    private final Lazy indexReader$delegate;

    public LuceneIndexDataStore(@NotNull XodusDirectory directory, @NotNull Name.ColumnName indexedColumn) {
        Intrinsics.checkNotNullParameter((Object)((Object)directory), (String)"directory");
        Intrinsics.checkNotNullParameter((Object)indexedColumn, (String)"indexedColumn");
        this.directory = directory;
        this.indexedColumn = indexedColumn;
        this.indexWriter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IndexWriter>(this){
            final /* synthetic */ LuceneIndexDataStore this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IndexWriter invoke() {
                IndexWriterConfig config = new IndexWriterConfig().setOpenMode(IndexWriterConfig.OpenMode.APPEND).setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                LuceneIndexDataStore.access$setWriterInitialized$p(this.this$0, true);
                return new IndexWriter((Directory)this.this$0.getDirectory(), config);
            }
        }));
        this.indexReader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DirectoryReader>(this){
            final /* synthetic */ LuceneIndexDataStore this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DirectoryReader invoke() {
                LuceneIndexDataStore.access$setReaderInitialized$p(this.this$0, true);
                return DirectoryReader.open((Directory)this.this$0.getDirectory());
            }
        }));
    }

    @NotNull
    public final XodusDirectory getDirectory() {
        return this.directory;
    }

    @NotNull
    public final IndexWriter getIndexWriter() {
        Lazy lazy = this.indexWriter$delegate;
        return (IndexWriter)lazy.getValue();
    }

    @NotNull
    public final IndexReader getIndexReader() {
        Lazy lazy = this.indexReader$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (IndexReader)object;
    }

    public final void addDocument-2g0_blE(long tupleId, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "Cannot add document to a closed LuceneIndexDataStore. This is a programmer's error!";
            throw new IllegalArgumentException(string.toString());
        }
        this.getIndexWriter().addDocument((Iterable)this.documentFromValue-RAUCjew(value, tupleId));
        this.checkAndFlush();
    }

    public final void updateDocument-2g0_blE(long tupleId, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "Cannot add document to a closed LuceneIndexDataStore. This is a programmer's error!";
            throw new IllegalArgumentException(string.toString());
        }
        this.getIndexWriter().updateDocument(new Term("_tid", String.valueOf(tupleId)), (Iterable)this.documentFromValue-RAUCjew(value, tupleId));
        this.checkAndFlush();
    }

    public final void deleteDocument(long tupleId) {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "Cannot add document to a closed LuceneIndexDataStore. This is a programmer's error!";
            throw new IllegalArgumentException(string.toString());
        }
        Term[] termArray = new Term[]{new Term("_tid", String.valueOf(tupleId))};
        this.getIndexWriter().deleteDocuments(termArray);
        this.checkAndFlush();
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.writerInitialized) {
                if (this.getIndexWriter().hasUncommittedChanges()) {
                    this.getIndexWriter().commit();
                }
                this.getIndexWriter().close();
            }
            if (this.readerInitialized) {
                this.getIndexReader().close();
            }
            this.directory.close();
            this.closed = true;
        }
    }

    private final void checkAndFlush() {
        if (this.getIndexWriter().getPendingNumDocs() % 1000000L == 0L) {
            this.getIndexWriter().flush();
        }
    }

    private final Document documentFromValue-RAUCjew(String value, long tupleId) {
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField("_tid", tupleId));
        doc.add((IndexableField)new StoredField("_tid", tupleId));
        doc.add((IndexableField)new TextField(this.indexedColumn.getColumn() + "_txt", value, Field.Store.NO));
        doc.add((IndexableField)new StringField(this.indexedColumn.getColumn() + "_str", value, Field.Store.NO));
        return doc;
    }

    public static final /* synthetic */ void access$setWriterInitialized$p(LuceneIndexDataStore $this, boolean bl) {
        $this.writerInitialized = bl;
    }

    public static final /* synthetic */ void access$setReaderInitialized$p(LuceneIndexDataStore $this, boolean bl) {
        $this.readerInitialized = bl;
    }
}

