/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.quantizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.SquaredEuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.PQCodebook;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.SerializableSingleStageProductQuantizer;
import org.vitrivr.cottontail.dbms.index.pq.signature.PQLookupTable;
import org.vitrivr.cottontail.dbms.index.pq.signature.SPQSignature;
import org.vitrivr.cottontail.utilities.math.clustering.Cluster;
import org.vitrivr.cottontail.utilities.math.clustering.KMeansClusterer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\nH\u0016J\u001f\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0013\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer;", "", "codebooks", "", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "([Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;)V", "getCodebooks", "()[Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "[Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "numberOfSubspaces", "", "getNumberOfSubspaces", "()I", "component1", "copy", "([Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;)Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer;", "createLookupTable", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable;", "query", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "equals", "", "other", "hashCode", "quantize", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/SPQSignature;", "vector", "quantize-54_lylY", "(Lorg/vitrivr/cottontail/core/types/VectorValue;)[S", "toSerializableProductQuantizer", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SerializableSingleStageProductQuantizer;", "toString", "", "Companion", "cottontaildb-dbms"})
public final class SingleStageQuantizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PQCodebook[] codebooks;

    public SingleStageQuantizer(@NotNull PQCodebook[] codebooks) {
        Intrinsics.checkNotNullParameter((Object)codebooks, (String)"codebooks");
        this.codebooks = codebooks;
    }

    @NotNull
    public final PQCodebook[] getCodebooks() {
        return this.codebooks;
    }

    private final int getNumberOfSubspaces() {
        return this.codebooks.length;
    }

    @NotNull
    public final short[] quantize-54_lylY(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        int n = 0;
        int n2 = this.getNumberOfSubspaces();
        short[] sArray = new short[n2];
        while (n < n2) {
            int n3 = n++;
            PQCodebook codebook = this.codebooks[n3];
            sArray[n3] = (short)codebook.quantize(vector.slice(n3 * codebook.getSubspaceSize(), codebook.getSubspaceSize()));
        }
        short[] subspaces = sArray;
        return SPQSignature.constructor-impl(subspaces);
    }

    @NotNull
    public final PQLookupTable createLookupTable(@NotNull VectorValue<?> query2) {
        PQLookupTable pQLookupTable;
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        VectorDistance<?> value = ((PQCodebook)ArraysKt.first((Object[])this.codebooks)).getDistance();
        if (value instanceof ManhattanDistance) {
            pQLookupTable = new PQLookupTable.Manhattan(query2, this.codebooks);
        } else if (value instanceof EuclideanDistance) {
            pQLookupTable = new PQLookupTable.Euclidean(query2, this.codebooks);
        } else if (value instanceof SquaredEuclideanDistance) {
            pQLookupTable = new PQLookupTable.SquaredEuclidean(query2, this.codebooks);
        } else {
            throw new IllegalStateException("The distance function " + value.getSignature() + " us not supported for product quantization.");
        }
        return pQLookupTable;
    }

    @NotNull
    public final SerializableSingleStageProductQuantizer toSerializableProductQuantizer() {
        int n = this.getNumberOfSubspaces();
        double[][][] dArrayArray = new double[n][][];
        for (int j = 0; j < n; ++j) {
            int n2 = j;
            int n3 = this.codebooks[n2].getNumberOfCentroids();
            double[][] dArrayArray2 = new double[n3][];
            int n4 = n2;
            double[][][] dArrayArray3 = dArrayArray;
            for (int k = 0; k < n3; ++k) {
                int n5 = k;
                int n6 = 0;
                int n7 = this.codebooks[n2].getSubspaceSize();
                double[] dArray = new double[n7];
                int n8 = n5;
                double[][] dArrayArray4 = dArrayArray2;
                while (n6 < n7) {
                    int n9 = n6++;
                    dArray[n9] = this.codebooks[n2].getCentroids()[n5].get(n9).getValue().doubleValue();
                }
                dArrayArray4[n8] = dArray;
            }
            dArrayArray3[n4] = dArrayArray2;
        }
        double[][][] dArrayArray5 = dArrayArray;
        return new SerializableSingleStageProductQuantizer(dArrayArray5);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingleStageQuantizer)) {
            return false;
        }
        return Arrays.equals(this.codebooks, ((SingleStageQuantizer)other).codebooks);
    }

    public int hashCode() {
        return Arrays.hashCode(this.codebooks);
    }

    @NotNull
    public final PQCodebook[] component1() {
        return this.codebooks;
    }

    @NotNull
    public final SingleStageQuantizer copy(@NotNull PQCodebook[] codebooks) {
        Intrinsics.checkNotNullParameter((Object)codebooks, (String)"codebooks");
        return new SingleStageQuantizer(codebooks);
    }

    public static /* synthetic */ SingleStageQuantizer copy$default(SingleStageQuantizer singleStageQuantizer, PQCodebook[] pQCodebookArray, int n, Object object) {
        if ((n & 1) != 0) {
            pQCodebookArray = singleStageQuantizer.codebooks;
        }
        return singleStageQuantizer.copy(pQCodebookArray);
    }

    @NotNull
    public String toString() {
        return "SingleStageQuantizer(codebooks=" + Arrays.toString(this.codebooks) + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer$Companion;", "", "()V", "learnFromData", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer;", "distance", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "data", "", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "config", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nSingleStageQuantizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleStageQuantizer.kt\norg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,119:1\n1726#2,3:120\n1549#2:124\n1620#2,3:125\n1549#2:128\n1620#2,3:129\n1#3:123\n37#4,2:132\n*S KotlinDebug\n*F\n+ 1 SingleStageQuantizer.kt\norg/vitrivr/cottontail/dbms/index/pq/quantizer/SingleStageQuantizer$Companion\n*L\n42#1:120,3\n53#1:124\n53#1:125,3\n54#1:128\n54#1:129,3\n54#1:132,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SingleStageQuantizer learnFromData(@NotNull VectorDistance<?> distance, @NotNull List<? extends VectorValue<?>> data, @NotNull PQIndexConfig config) {
            boolean bl;
            int dimensionsPerSubspace;
            int subspaces;
            int logicalSize;
            block9: {
                Intrinsics.checkNotNullParameter(distance, (String)"distance");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                logicalSize = distance.getType().getLogicalSize();
                subspaces = config.numberOfSubspaces(logicalSize);
                dimensionsPerSubspace = logicalSize / subspaces;
                Iterable $this$all$iv = data;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        VectorValue it = (VectorValue)element$iv;
                        boolean bl2 = false;
                        if (it.getLogicalSize() == logicalSize) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                boolean $i$a$-require-SingleStageQuantizer$Companion$learnFromData$52 = false;
                String $i$a$-require-SingleStageQuantizer$Companion$learnFromData$52 = "Training of product quantizer not possible; dimensionality of training data and distance function don't match.";
                throw new IllegalArgumentException($i$a$-require-SingleStageQuantizer$Companion$learnFromData$52.toString());
            }
            if (!(logicalSize >= subspaces)) {
                boolean $i$a$-require-SingleStageQuantizer$Companion$learnFromData$62 = false;
                String $i$a$-require-SingleStageQuantizer$Companion$learnFromData$62 = "Training of product quantizer not possible; logical size of data must be greater or equal to number of subspaces.";
                throw new IllegalArgumentException($i$a$-require-SingleStageQuantizer$Companion$learnFromData$62.toString());
            }
            if (!(dimensionsPerSubspace * subspaces == logicalSize)) {
                boolean $i$a$-require-SingleStageQuantizer$Companion$learnFromData$72 = false;
                String $i$a$-require-SingleStageQuantizer$Companion$learnFromData$72 = "Training of product quantizer not possible; vector size of " + logicalSize + " does not allow for equally spaced subspaces.";
                throw new IllegalArgumentException($i$a$-require-SingleStageQuantizer$Companion$learnFromData$72.toString());
            }
            VectorDistance reshape = distance.copy(dimensionsPerSubspace);
            SplittableRandom random = new SplittableRandom(System.currentTimeMillis());
            KMeansClusterer clusterer = new KMeansClusterer(config.getNumCentroids(), reshape, (RandomGenerator)random, 0, 8, null);
            PQCodebook[] pQCodebookArray = new PQCodebook[subspaces];
            for (int j = 0; j < subspaces; ++j) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Collection<VectorValue> $this$map$iv;
                Collection<VectorValue> collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                int n = j;
                Iterable iterable = data;
                int n2 = n;
                PQCodebook[] pQCodebookArray2 = pQCodebookArray;
                boolean $i$f$map22 = false;
                void var17_25 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void v;
                    VectorValue vectorValue = (VectorValue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(v.slice(n * dimensionsPerSubspace, dimensionsPerSubspace));
                }
                collection = (List)destination$iv$iv;
                List subspaceData = collection;
                Iterable $i$f$map22 = clusterer.cluster(subspaceData);
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Cluster bl3 = (Cluster)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(it.getCenter());
                }
                $this$map$iv = collection = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                VectorValue[] clusters = thisCollection$iv.toArray(new VectorValue[0]);
                pQCodebookArray2[n2] = new PQCodebook(reshape, clusters);
            }
            PQCodebook[] codebooks = pQCodebookArray;
            return new SingleStageQuantizer(codebooks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

