/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.rebuilder;

import java.util.LinkedList;
import java.util.List;
import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.dbms.column.ColumnTx;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/rebuilder/DataCollectionUtilities;", "", "()V", "acquireLearningData", "", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "txn", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "fraction", "", "seed", "", "cottontaildb-dbms"})
public final class DataCollectionUtilities {
    @NotNull
    public static final DataCollectionUtilities INSTANCE = new DataCollectionUtilities();

    private DataCollectionUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<VectorValue<?>> acquireLearningData(@NotNull ColumnTx<?> txn, float fraction, long seed) {
        Intrinsics.checkNotNullParameter(txn, (String)"txn");
        SplittableRandom random = new SplittableRandom(seed);
        LinkedList<Value> learningData = new LinkedList<Value>();
        AutoCloseable autoCloseable = (AutoCloseable)txn.cursor();
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)autoCloseable;
            boolean bl = false;
            while (cursor.hasNext()) {
                Value value;
                if (!(random.nextDouble() <= (double)fraction) || !((value = (Value)cursor.value()) instanceof VectorValue)) continue;
                learningData.add(value);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return learningData;
    }
}

