/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.signature;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.dbms.index.pq.quantizer.PQCodebook;
import org.vitrivr.cottontail.dbms.index.pq.signature.PQSignature;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u000b\f\rJ\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable;", "", "data", "", "", "getData", "()[[D", "approximateDistance", "", "signature", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQSignature;", "Euclidean", "Manhattan", "SquaredEuclidean", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable$Euclidean;", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable$Manhattan;", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable$SquaredEuclidean;", "cottontaildb-dbms"})
public interface PQLookupTable {
    @NotNull
    public double[][] getData();

    public double approximateDistance(@NotNull PQSignature var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable$Euclidean;", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable;", "query", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "codebooks", "", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "(Lorg/vitrivr/cottontail/core/types/VectorValue;[Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;)V", "data", "", "getData", "()[[D", "[[D", "approximateDistance", "", "signature", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQSignature;", "cottontaildb-dbms"})
    public static final class Euclidean
    implements PQLookupTable {
        @NotNull
        private final double[][] data;

        public Euclidean(@NotNull VectorValue<?> query2, @NotNull PQCodebook[] codebooks) {
            Intrinsics.checkNotNullParameter(query2, (String)"query");
            Intrinsics.checkNotNullParameter((Object)codebooks, (String)"codebooks");
            int n = codebooks.length;
            double[][] dArrayArray = new double[n][];
            Euclidean euclidean = this;
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                PQCodebook codebook = codebooks[n2];
                VectorValue subspaceQuery = query2.slice(n2 * codebook.getSubspaceSize(), codebook.getSubspaceSize());
                int n3 = 0;
                int n4 = codebook.getNumberOfCentroids();
                double[] dArray = new double[n4];
                int n5 = n2;
                double[][] dArrayArray2 = dArrayArray;
                while (n3 < n4) {
                    int n6 = n3++;
                    dArray[n6] = Math.pow(codebook.distanceFrom(subspaceQuery, n6), 2);
                }
                dArrayArray2[n5] = dArray;
            }
            euclidean.data = dArrayArray;
        }

        @Override
        @NotNull
        public double[][] getData() {
            return this.data;
        }

        @Override
        public double approximateDistance(@NotNull PQSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            double sum = 0.0;
            short[] sArray = signature.getCells();
            int n = sArray.length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                short c = sArray[j];
                sum += this.getData()[i2][c];
            }
            return Math.sqrt(sum);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable$Manhattan;", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable;", "query", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "codebooks", "", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "(Lorg/vitrivr/cottontail/core/types/VectorValue;[Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;)V", "data", "", "getData", "()[[D", "[[D", "approximateDistance", "", "signature", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQSignature;", "cottontaildb-dbms"})
    public static final class Manhattan
    implements PQLookupTable {
        @NotNull
        private final double[][] data;

        public Manhattan(@NotNull VectorValue<?> query2, @NotNull PQCodebook[] codebooks) {
            Intrinsics.checkNotNullParameter(query2, (String)"query");
            Intrinsics.checkNotNullParameter((Object)codebooks, (String)"codebooks");
            int n = codebooks.length;
            double[][] dArrayArray = new double[n][];
            Manhattan manhattan = this;
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                PQCodebook codebook = codebooks[n2];
                VectorValue subspaceQuery = query2.slice(n2 * codebook.getSubspaceSize(), codebook.getSubspaceSize());
                int n3 = 0;
                int n4 = codebook.getNumberOfCentroids();
                double[] dArray = new double[n4];
                int n5 = n2;
                double[][] dArrayArray2 = dArrayArray;
                while (n3 < n4) {
                    int n6 = n3++;
                    dArray[n6] = codebook.distanceFrom(subspaceQuery, n6);
                }
                dArrayArray2[n5] = dArray;
            }
            manhattan.data = dArrayArray;
        }

        @Override
        @NotNull
        public double[][] getData() {
            return this.data;
        }

        @Override
        public double approximateDistance(@NotNull PQSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            double sum = 0.0;
            short[] sArray = signature.getCells();
            int n = sArray.length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                short c = sArray[j];
                sum += this.getData()[i2][c];
            }
            return sum;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable$SquaredEuclidean;", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQLookupTable;", "query", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "codebooks", "", "Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;", "(Lorg/vitrivr/cottontail/core/types/VectorValue;[Lorg/vitrivr/cottontail/dbms/index/pq/quantizer/PQCodebook;)V", "data", "", "getData", "()[[D", "[[D", "approximateDistance", "", "signature", "Lorg/vitrivr/cottontail/dbms/index/pq/signature/PQSignature;", "cottontaildb-dbms"})
    public static final class SquaredEuclidean
    implements PQLookupTable {
        @NotNull
        private final double[][] data;

        public SquaredEuclidean(@NotNull VectorValue<?> query2, @NotNull PQCodebook[] codebooks) {
            Intrinsics.checkNotNullParameter(query2, (String)"query");
            Intrinsics.checkNotNullParameter((Object)codebooks, (String)"codebooks");
            int n = codebooks.length;
            double[][] dArrayArray = new double[n][];
            SquaredEuclidean squaredEuclidean = this;
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                PQCodebook codebook = codebooks[n2];
                VectorValue subspaceQuery = query2.slice(n2 * codebook.getSubspaceSize(), codebook.getSubspaceSize());
                int n3 = 0;
                int n4 = codebook.getNumberOfCentroids();
                double[] dArray = new double[n4];
                int n5 = n2;
                double[][] dArrayArray2 = dArrayArray;
                while (n3 < n4) {
                    int n6 = n3++;
                    dArray[n6] = Math.pow(codebook.distanceFrom(subspaceQuery, n6), 2);
                }
                dArrayArray2[n5] = dArray;
            }
            squaredEuclidean.data = dArrayArray;
        }

        @Override
        @NotNull
        public double[][] getData() {
            return this.data;
        }

        @Override
        public double approximateDistance(@NotNull PQSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            double sum = 0.0;
            short[] sArray = signature.getCells();
            int n = sArray.length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                short c = sArray[j];
                sum += this.getData()[i2][c];
            }
            return sum;
        }
    }
}

