/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.va;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiFunction;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Transaction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.binding.Binding;
import org.vitrivr.cottontail.core.queries.binding.BindingContext;
import org.vitrivr.cottontail.core.queries.binding.MissingTuple;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.SquaredEuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.RealVectorValue;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.execution.operators.sort.RecordComparator;
import org.vitrivr.cottontail.dbms.index.cache.CacheKey;
import org.vitrivr.cottontail.dbms.index.cache.InMemoryIndexCache;
import org.vitrivr.cottontail.dbms.index.va.VAFIndex;
import org.vitrivr.cottontail.dbms.index.va.bounds.Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L1Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L2Bounds;
import org.vitrivr.cottontail.dbms.index.va.signature.EquidistantVAFMarks;
import org.vitrivr.cottontail.dbms.index.va.signature.VAFSignature;
import org.vitrivr.cottontail.utilities.selection.HeapSelection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0004BCDEB#\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\n\u0010\b\u001a\u00060\tR\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010@\u001a\u00020AH\u0016R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0018\u0010\b\u001a\u00060\tR\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0016\u0010\u0007\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u00100\u001a\u0004\b.\u0010/R \u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030302X\u0084\u0004\u00a2\u0006\n\n\u0002\u00106\u001a\u0004\b4\u00105R\u0018\u00107\u001a\u0006\u0012\u0002\b\u00030\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010%R\u001c\u0010<\u001a\n \u001f*\u0004\u0018\u00010=0=X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?\u0082\u0001\u0002FG\u00a8\u0006H"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor;", "T", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate;", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "boc", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getBoc", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "bounds", "Lorg/vitrivr/cottontail/dbms/index/va/bounds/Bounds;", "getBounds", "()Lorg/vitrivr/cottontail/dbms/index/va/bounds/Bounds;", "cache", "Lorg/vitrivr/cottontail/dbms/index/cache/InMemoryIndexCache;", "getCache", "()Lorg/vitrivr/cottontail/dbms/index/cache/InMemoryIndexCache;", "columnTx", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "Lorg/vitrivr/cottontail/core/types/RealVectorValue;", "getColumnTx", "()Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "cursor", "Ljetbrains/exodus/env/Cursor;", "kotlin.jvm.PlatformType", "getCursor", "()Ljetbrains/exodus/env/Cursor;", "endKey", "Ljetbrains/exodus/ArrayByteIterable;", "getEndKey", "()Ljetbrains/exodus/ArrayByteIterable;", "getIndex", "()Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "marks", "Lorg/vitrivr/cottontail/dbms/index/va/signature/EquidistantVAFMarks;", "getMarks", "()Lorg/vitrivr/cottontail/dbms/index/va/signature/EquidistantVAFMarks;", "getPartition", "()Lkotlin/ranges/LongRange;", "getPredicate", "()Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate;", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate;", "produces", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "query", "getQuery", "()Lorg/vitrivr/cottontail/core/types/RealVectorValue;", "startKey", "getStartKey", "subTx", "Ljetbrains/exodus/env/Transaction;", "getSubTx", "()Ljetbrains/exodus/env/Transaction;", "close", "", "ENN", "FNS", "KLimited", "NNS", "Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$ENN;", "Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$KLimited;", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nCachedVAFCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedVAFCursor.kt\norg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n37#2,2:314\n1#3:316\n*S KotlinDebug\n*F\n+ 1 CachedVAFCursor.kt\norg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor\n*L\n67#1:314,2\n*E\n"})
public abstract class CachedVAFCursor<T extends ProximityPredicate>
implements org.vitrivr.cottontail.core.basics.Cursor<Tuple> {
    @NotNull
    private final LongRange partition;
    @NotNull
    private final T predicate;
    @NotNull
    private final VAFIndex.Tx index;
    @NotNull
    private final RealVectorValue<?> query;
    @NotNull
    private final Bounds bounds;
    private final Transaction subTx;
    private final Cursor cursor;
    @NotNull
    private final AtomicBoolean boc;
    @NotNull
    private final ColumnTx<RealVectorValue<?>> columnTx;
    @NotNull
    private final ArrayByteIterable startKey;
    @NotNull
    private final ArrayByteIterable endKey;
    @NotNull
    private final EquidistantVAFMarks marks;
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final InMemoryIndexCache cache;

    private CachedVAFCursor(LongRange partition, T predicate, VAFIndex.Tx index) {
        Bounds bounds;
        this.partition = partition;
        this.predicate = predicate;
        this.index = index;
        this.subTx = this.index.getContext().getTxn().getXodusTx().getReadonlySnapshot();
        this.cursor = this.index.getDataStore$cottontaildb_dbms().openCursor(this.subTx);
        this.boc = new AtomicBoolean(false);
        this.startKey = ExtensionsKt.toKey(this.partition.getFirst());
        this.endKey = ExtensionsKt.toKey(this.partition.getLast());
        this.marks = this.index.getMarks$cottontaildb_dbms();
        Collection $this$toTypedArray$iv = this.index.columnsFor((Predicate)this.predicate);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.produces = thisCollection$iv.toArray(new ColumnDef[0]);
        this.cache = this.index.getDbo().getCatalogue().getCache();
        Binding queryVectorBinding = this.predicate.getQuery();
        MissingTuple $this$_init__u24lambda_u242 = MissingTuple.INSTANCE;
        boolean bl = false;
        BindingContext $this$lambda_u242_u24lambda_u241 = this.index.getContext().getBindings();
        boolean bl2 = false;
        Value value = queryVectorBinding.getValue($this$lambda_u242_u24lambda_u241, (Tuple)$this$_init__u24lambda_u242);
        if (!(value instanceof RealVectorValue)) {
            boolean bl3 = false;
            Value value2 = value;
            String string = "Bound value for query vector has wrong type (found = " + (Types)(value2 != null ? value2.getType() : null) + ").";
            throw new IllegalStateException(string.toString());
        }
        this.query = (RealVectorValue)value;
        VectorDistance $i$f$toTypedArray22 = this.predicate.getDistance();
        if ($i$f$toTypedArray22 instanceof ManhattanDistance) {
            bounds = new L1Bounds(this.query, this.marks);
        } else if ($i$f$toTypedArray22 instanceof EuclideanDistance ? true : $i$f$toTypedArray22 instanceof SquaredEuclideanDistance) {
            bounds = new L2Bounds(this.query, this.marks);
        } else {
            throw new IllegalArgumentException("The " + this.predicate.getDistance() + " distance kernel is not supported by VAFIndex.");
        }
        this.bounds = bounds;
        EntityTx entityTx = this.index.getDbo().getParent().newTx(this.index.getContext());
        ColumnTx<?> columnTx = entityTx.columnForName(this.index.getColumns()[0].getName()).newTx(this.index.getContext());
        Intrinsics.checkNotNull(columnTx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<org.vitrivr.cottontail.core.types.RealVectorValue<*>>");
        this.columnTx = columnTx;
    }

    @NotNull
    protected final LongRange getPartition() {
        return this.partition;
    }

    @NotNull
    protected final T getPredicate() {
        return this.predicate;
    }

    @NotNull
    protected final VAFIndex.Tx getIndex() {
        return this.index;
    }

    @NotNull
    protected final RealVectorValue<?> getQuery() {
        return this.query;
    }

    @NotNull
    protected final Bounds getBounds() {
        return this.bounds;
    }

    protected final Transaction getSubTx() {
        return this.subTx;
    }

    protected final Cursor getCursor() {
        return this.cursor;
    }

    @NotNull
    protected final AtomicBoolean getBoc() {
        return this.boc;
    }

    @NotNull
    protected final ColumnTx<RealVectorValue<?>> getColumnTx() {
        return this.columnTx;
    }

    @NotNull
    protected final ArrayByteIterable getStartKey() {
        return this.startKey;
    }

    @NotNull
    protected final ArrayByteIterable getEndKey() {
        return this.endKey;
    }

    @NotNull
    protected final EquidistantVAFMarks getMarks() {
        return this.marks;
    }

    @NotNull
    protected final ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @NotNull
    protected final InMemoryIndexCache getCache() {
        return this.cache;
    }

    public void close() {
        this.cursor.close();
        this.subTx.abort();
    }

    public boolean hasNext() {
        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean movePrevious() {
        return Cursor.DefaultImpls.movePrevious((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean moveTo(long tupleId) {
        return Cursor.DefaultImpls.moveTo((org.vitrivr.cottontail.core.basics.Cursor)this, (long)tupleId);
    }

    @NotNull
    public Tuple next() {
        return (Tuple)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public /* synthetic */ CachedVAFCursor(LongRange partition, ProximityPredicate predicate, VAFIndex.Tx index, DefaultConstructorMarker $constructor_marker) {
        this(partition, predicate, index);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$ENN;", "Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor;", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$ENN;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$ENN;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "key", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "moveNext", "", "value", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "cottontaildb-dbms"})
    public static final class ENN
    extends CachedVAFCursor<ProximityPredicate.ENN> {
        public ENN(@NotNull LongRange partition, @NotNull ProximityPredicate.ENN predicate, @NotNull VAFIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(partition, (ProximityPredicate)predicate, index, null);
        }

        public boolean moveNext() {
            while (this.getBoc().compareAndExchange(true, false) || this.getCursor().getNext() && this.getCursor().getKey().compareTo((Object)this.getEndKey()) < 0) {
                ByteIterable byteIterable = this.getCursor().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
                byte[] signature = VAFSignature.Companion.fromEntry-lsqBzE4(byteIterable);
                Pair<Double, Double> pair = this.getBounds().bounds-s1HmYNQ(signature);
                double lb = ((Number)pair.component1()).doubleValue();
                double ub = ((Number)pair.component2()).doubleValue();
                if (!(((ProximityPredicate.ENN)this.getPredicate()).getEMin-5B6OyQQ() >= lb) || !(((ProximityPredicate.ENN)this.getPredicate()).getEMax-5B6OyQQ() < ub)) continue;
                return true;
            }
            return false;
        }

        public long key() {
            return LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey());
        }

        @NotNull
        public Tuple value() {
            long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey());
            RealVectorValue<?> value = this.getColumnTx().read(tupleId);
            Value[] valueArray = new Value[]{this.getQuery(), value};
            Value value2 = ((ProximityPredicate.ENN)this.getPredicate()).getDistance().invoke(valueArray);
            Intrinsics.checkNotNull((Object)value2);
            double distance = ((DoubleValue)value2).unbox-impl();
            valueArray = new Value[]{DoubleValue.box-impl((double)distance), value};
            return (Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$FNS;", "Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$KLimited;", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$FNS;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$FNS;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "prepareVASSA", "Lorg/vitrivr/cottontail/utilities/selection/HeapSelection;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "cottontaildb-dbms"})
    public static final class FNS
    extends KLimited<ProximityPredicate.FNS> {
        public FNS(@NotNull LongRange partition, @NotNull ProximityPredicate.FNS predicate, @NotNull VAFIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(partition, (ProximityPredicate.KLimitedSearch)predicate, index, null);
        }

        @Override
        @NotNull
        protected HeapSelection<Tuple> prepareVASSA() {
            HeapSelection<Tuple> selection2 = new HeapSelection<Tuple>((int)((ProximityPredicate.FNS)this.getPredicate()).getK(), new RecordComparator.SingleNonNullColumnComparator(((ProximityPredicate.FNS)this.getPredicate()).getDistanceColumn().getColumn(), SortOrder.DESCENDING));
            try {
                double threshold = 0.0;
                do {
                    long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey());
                    RealVectorValue<?> value = this.getColumnTx().read(tupleId);
                    Value[] valueArray = new Value[]{this.getQuery(), value};
                    Value value2 = ((ProximityPredicate.FNS)this.getPredicate()).getDistance().invoke(valueArray);
                    Intrinsics.checkNotNull((Object)value2);
                    double distance = ((DoubleValue)value2).unbox-impl();
                    valueArray = new Value[]{DoubleValue.box-impl((double)distance), value};
                    selection2.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray));
                } while (this.getCursor().getNext() && this.getCursor().getKey().compareTo((Object)this.getEndKey()) < 0 && selection2.getSize() < selection2.getK());
                Tuple tuple = selection2.peek();
                Intrinsics.checkNotNull((Object)tuple);
                Value value = tuple.get(0);
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
                threshold = ((DoubleValue)value).unbox-impl();
                do {
                    ByteIterable byteIterable = this.getCursor().getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
                    byte[] signature = VAFSignature.Companion.fromEntry-lsqBzE4(byteIterable);
                    if (!(this.getBounds().ub-tU6kMXU(signature, threshold) < threshold)) continue;
                    long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey());
                    RealVectorValue<?> value3 = this.getColumnTx().read(tupleId);
                    Value[] valueArray = new Value[]{this.getQuery(), value3};
                    Value value4 = ((ProximityPredicate.FNS)this.getPredicate()).getDistance().invoke(valueArray);
                    Intrinsics.checkNotNull((Object)value4);
                    double distance = ((DoubleValue)value4).unbox-impl();
                    Value[] valueArray2 = new Value[]{DoubleValue.box-impl((double)distance), value3};
                    Value value5 = selection2.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray2)).get(0);
                    Intrinsics.checkNotNull((Object)value5, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
                    threshold = ((DoubleValue)value5).unbox-impl();
                } while (this.getCursor().getNext() && this.getCursor().getKey().compareTo((Object)this.getEndKey()) < 0);
                VAFIndex.Companion.getLOGGER$cottontaildb_dbms().debug("VA-SSA Scan: Read " + selection2.getAdded() + " and skipped over " + (1.0 - (double)selection2.getAdded() / (double)this.getIndex().count()) * (double)100 + "% of entries.");
                return selection2;
            }
            catch (Throwable e) {
                VAFIndex.Companion.getLOGGER$cottontaildb_dbms().error("VA-SSA Scan: Error while scanning VAF index: " + e.getMessage());
                return selection2;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\n\u0010\u0007\u001a\u00060\bR\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001dH$J\b\u0010\u001e\u001a\u00020\fH\u0016R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00128DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u0082\u0001\u0002\u001f \u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$KLimited;", "T", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$KLimitedSearch;", "Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$KLimitedSearch;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "current", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "getCurrent", "()Lorg/vitrivr/cottontail/core/tuple/Tuple;", "setCurrent", "(Lorg/vitrivr/cottontail/core/tuple/Tuple;)V", "selection", "", "getSelection", "()Ljava/util/Iterator;", "selection$delegate", "Lkotlin/Lazy;", "key", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "moveNext", "", "prepareVASSA", "Lorg/vitrivr/cottontail/utilities/selection/HeapSelection;", "value", "Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$FNS;", "Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$NNS;", "cottontaildb-dbms"})
    public static abstract class KLimited<T extends ProximityPredicate.KLimitedSearch>
    extends CachedVAFCursor<T> {
        @NotNull
        private final Lazy selection$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Iterator<? extends Tuple>>(this){
            final /* synthetic */ KLimited<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Iterator<Tuple> invoke() {
                return this.this$0.getBoc().compareAndExchange(true, false) ? this.this$0.prepareVASSA().iterator() : CollectionsKt.emptyList().iterator();
            }
        }));
        @Nullable
        private Tuple current;

        private KLimited(LongRange partition, T predicate, VAFIndex.Tx index) {
            super(partition, (ProximityPredicate)predicate, index, null);
        }

        @NotNull
        protected final Iterator<Tuple> getSelection() {
            Lazy lazy = this.selection$delegate;
            return (Iterator)lazy.getValue();
        }

        @Nullable
        protected final Tuple getCurrent() {
            return this.current;
        }

        protected final void setCurrent(@Nullable Tuple tuple) {
            this.current = tuple;
        }

        public boolean moveNext() {
            if (!this.getSelection().hasNext()) {
                return false;
            }
            this.current = this.getSelection().next();
            return true;
        }

        public long key() {
            long l;
            try {
                Tuple tuple = this.current;
                Intrinsics.checkNotNull((Object)tuple);
                l = tuple.getTupleId();
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("VAFCursor is not currently pointing to a record.");
            }
            return l;
        }

        @NotNull
        public Tuple value() {
            Tuple tuple;
            try {
                Tuple tuple2 = this.current;
                Intrinsics.checkNotNull((Object)tuple2);
                tuple = tuple2;
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("VAFCursor is not currently pointing to a record.");
            }
            return tuple;
        }

        @NotNull
        protected abstract HeapSelection<Tuple> prepareVASSA();

        public /* synthetic */ KLimited(LongRange partition, ProximityPredicate.KLimitedSearch predicate, VAFIndex.Tx index, DefaultConstructorMarker $constructor_marker) {
            this(partition, predicate, index);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$NNS;", "Lorg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$KLimited;", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$NNS;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$NNS;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "prepareVASSA", "Lorg/vitrivr/cottontail/utilities/selection/HeapSelection;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "prepareVASSAFromDisk", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nCachedVAFCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedVAFCursor.kt\norg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$NNS\n+ 2 InMemoryIndexCache.kt\norg/vitrivr/cottontail/dbms/index/cache/InMemoryIndexCache\n+ 3 StampedLocksExtensions.kt\norg/vitrivr/cottontail/utilities/extensions/StampedLocksExtensionsKt\n*L\n1#1,313:1\n28#2:314\n29#2,8:318\n38#2:329\n47#2:330\n48#2:334\n53#2:338\n12#3,3:315\n18#3:326\n15#3,2:327\n49#3,3:331\n55#3:335\n52#3,2:336\n*S KotlinDebug\n*F\n+ 1 CachedVAFCursor.kt\norg/vitrivr/cottontail/dbms/index/va/CachedVAFCursor$NNS\n*L\n172#1:314\n172#1:318,8\n172#1:329\n238#1:330\n238#1:334\n238#1:338\n172#1:315,3\n172#1:326\n172#1:327,2\n238#1:331,3\n238#1:335\n238#1:336,2\n*E\n"})
    public static final class NNS
    extends KLimited<ProximityPredicate.NNS> {
        public NNS(@NotNull LongRange partition, @NotNull ProximityPredicate.NNS predicate, @NotNull VAFIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(partition, (ProximityPredicate.KLimitedSearch)predicate, index, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected HeapSelection<Tuple> prepareVASSA() {
            int i2;
            Object $i$a$-read-InMemoryIndexCache$get$1$iv22;
            void this_$iv;
            InMemoryIndexCache cache;
            InMemoryIndexCache inMemoryIndexCache = cache = this.getIndex().getDbo().getCatalogue().getCache();
            CacheKey key$iv = new CacheKey(this.getIndex().getDbo().getName(), this.getPartition());
            boolean $i$f$get = false;
            StampedLock $this$read$iv$iv = this_$iv.getLock();
            boolean $i$f$read = false;
            long stamp$iv$iv = $this$read$iv$iv.readLock();
            try {
                Object v1;
                boolean $i$a$-read-InMemoryIndexCache$get$1$iv22 = false;
                Map map2 = (Map)this_$iv.getCache().get((Object)key$iv.getName());
                if (map2 == null) {
                    v1 = null;
                } else {
                    Map map3 = map2;
                    Intrinsics.checkNotNull((Object)map3);
                    Map dboRef$iv = map3;
                    SoftReference softReference = (SoftReference)dboRef$iv.get(key$iv.getRange());
                    if (softReference == null) {
                        v1 = null;
                    } else {
                        SoftReference rangeRef$iv = softReference;
                        Object value$iv = rangeRef$iv.get();
                        if (value$iv instanceof List) {
                            v1 = value$iv;
                        } else {
                            dboRef$iv.remove(key$iv.getRange());
                            v1 = null;
                        }
                    }
                }
                $i$a$-read-InMemoryIndexCache$get$1$iv22 = v1;
            }
            catch (Throwable e$iv$iv) {
                throw e$iv$iv;
            }
            finally {
                $this$read$iv$iv.unlock(stamp$iv$iv);
            }
            List list = $i$a$-read-InMemoryIndexCache$get$1$iv22;
            if (list == null) {
                return this.prepareVASSAFromDisk();
            }
            List signatures = list;
            HeapSelection<Tuple> localSelection = new HeapSelection<Tuple>((int)((ProximityPredicate.NNS)this.getPredicate()).getK(), new RecordComparator.SingleNonNullColumnComparator(((ProximityPredicate.NNS)this.getPredicate()).getDistanceColumn().getColumn(), SortOrder.ASCENDING));
            double threshold = 0.0;
            int n = localSelection.getK();
            for (i2 = 0; i2 < n; ++i2) {
                long tupleId = ((Number)((Pair)signatures.get(i2)).getFirst()).longValue();
                RealVectorValue<?> value = this.getColumnTx().read(tupleId);
                Value[] valueArray = new Value[]{this.getQuery(), value};
                Value value2 = ((ProximityPredicate.NNS)this.getPredicate()).getDistance().invoke(valueArray);
                Intrinsics.checkNotNull((Object)value2);
                double distance = ((DoubleValue)value2).unbox-impl();
                valueArray = new Value[]{DoubleValue.box-impl((double)distance), value};
                localSelection.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray));
            }
            Object t = localSelection.peek();
            Intrinsics.checkNotNull(t);
            Value value = ((Tuple)t).get(0);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
            threshold = ((DoubleValue)value).unbox-impl();
            n = signatures.size();
            for (i2 = localSelection.getK(); i2 < n; ++i2) {
                Pair entry = (Pair)signatures.get(i2);
                if (!(this.getBounds().lb-tU6kMXU(((VAFSignature)entry.getSecond()).unbox-impl(), threshold) < threshold)) continue;
                long tupleId = ((Number)entry.getFirst()).longValue();
                RealVectorValue<?> value3 = this.getColumnTx().read(tupleId);
                Value[] valueArray = new Value[]{this.getQuery(), value3};
                Value value4 = ((ProximityPredicate.NNS)this.getPredicate()).getDistance().invoke(valueArray);
                Intrinsics.checkNotNull((Object)value4);
                double distance = ((DoubleValue)value4).unbox-impl();
                Value[] valueArray2 = new Value[]{DoubleValue.box-impl((double)distance), value3};
                Value value5 = localSelection.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray2)).get(0);
                Intrinsics.checkNotNull((Object)value5, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
                threshold = ((DoubleValue)value5).unbox-impl();
            }
            long count = this.getPartition().getLast() - this.getPartition().getFirst() + 1L;
            VAFIndex.Companion.getLOGGER$cottontaildb_dbms().debug("VA-SSA Scan (Cache): Read " + localSelection.getAdded() + " and skipped over " + (1.0 - (double)localSelection.getAdded() / (double)count) * (double)100 + "% of entries.");
            return localSelection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final HeapSelection<Tuple> prepareVASSAFromDisk() {
            HeapSelection<Tuple> localSelection = new HeapSelection<Tuple>((int)((ProximityPredicate.NNS)this.getPredicate()).getK(), new RecordComparator.SingleNonNullColumnComparator(((ProximityPredicate.NNS)this.getPredicate()).getDistanceColumn().getColumn(), SortOrder.ASCENDING));
            ArrayList<Pair> signatures = new ArrayList<Pair>((int)(this.getPartition().getLast() - this.getPartition().getFirst()));
            try {
                void this_$iv;
                Object signature;
                double distance;
                Value[] valueArray;
                RealVectorValue<?> value;
                double threshold = 0.0;
                do {
                    ByteIterable byteIterable = this.getCursor().getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
                    byte[] signature2 = VAFSignature.Companion.fromEntry-lsqBzE4(byteIterable);
                    long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey());
                    signatures.add(TuplesKt.to((Object)tupleId, (Object)VAFSignature.box-impl(signature2)));
                    value = this.getColumnTx().read(tupleId);
                    valueArray = new Value[]{this.getQuery(), value};
                    Value value2 = ((ProximityPredicate.NNS)this.getPredicate()).getDistance().invoke(valueArray);
                    Intrinsics.checkNotNull((Object)value2);
                    distance = ((DoubleValue)value2).unbox-impl();
                    valueArray = new Value[]{DoubleValue.box-impl((double)distance), value};
                    localSelection.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray));
                } while (this.getCursor().getNext() && this.getCursor().getKey().compareTo((Object)this.getEndKey()) < 0 && localSelection.getSize() < localSelection.getK());
                Tuple tuple = localSelection.peek();
                Intrinsics.checkNotNull((Object)tuple);
                Value value3 = tuple.get(0);
                Intrinsics.checkNotNull((Object)value3, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
                threshold = ((DoubleValue)value3).unbox-impl();
                do {
                    long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey());
                    ByteIterable byteIterable = this.getCursor().getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
                    signature = VAFSignature.Companion.fromEntry-lsqBzE4(byteIterable);
                    signatures.add(TuplesKt.to((Object)tupleId, (Object)VAFSignature.box-impl(signature)));
                    if (!(this.getBounds().lb-tU6kMXU((byte[])signature, threshold) < threshold)) continue;
                    value = this.getColumnTx().read(tupleId);
                    valueArray = new Value[]{this.getQuery(), value};
                    Value value4 = ((ProximityPredicate.NNS)this.getPredicate()).getDistance().invoke(valueArray);
                    Intrinsics.checkNotNull((Object)value4);
                    distance = ((DoubleValue)value4).unbox-impl();
                    Value[] valueArray2 = new Value[]{DoubleValue.box-impl((double)distance), value};
                    Value value5 = localSelection.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray2)).get(0);
                    Intrinsics.checkNotNull((Object)value5, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
                    threshold = ((DoubleValue)value5).unbox-impl();
                } while (this.getCursor().getNext() && this.getCursor().getKey().compareTo((Object)this.getEndKey()) < 0);
                long count = this.getPartition().getLast() - this.getPartition().getFirst() + 1L;
                VAFIndex.Companion.getLOGGER$cottontaildb_dbms().debug("VA-SSA Scan: Read " + localSelection.getAdded() + " and skipped over " + (1.0 - (double)localSelection.getAdded() / (double)count) * (double)100 + "% of entries.");
                signature = this.getCache();
                CacheKey key$iv = new CacheKey(this.getIndex().getDbo().getName(), this.getPartition());
                boolean $i$f$put = false;
                StampedLock $this$write$iv$iv = this_$iv.getLock();
                boolean $i$f$write = false;
                long stamp$iv$iv = $this$write$iv$iv.writeLock();
                try {
                    boolean bl = false;
                    Function2 function2 = new Function2<Name.IndexName, Map<LongRange, SoftReference<?>>, Map<LongRange, SoftReference<?>>>(key$iv, signatures){
                        final /* synthetic */ CacheKey $key;
                        final /* synthetic */ T $value;
                        {
                            this.$key = $key;
                            this.$value = $value;
                            super(2);
                        }

                        @Nullable
                        public final Map<LongRange, SoftReference<?>> invoke(Name.IndexName indexName, @Nullable Map<LongRange, SoftReference<?>> v) {
                            Map map2 = v;
                            if (map2 == null) {
                                map2 = (Map)new Object2ObjectLinkedOpenHashMap();
                            }
                            Map map3 = map2;
                            map3.put(this.$key.getRange(), new SoftReference<T>(this.$value));
                            return map3;
                        }
                    };
                    Map map2 = (Map)this_$iv.getCache().compute((Object)key$iv.getName(), new BiFunction(function2){
                        private final /* synthetic */ Function2 function;
                        {
                            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                            this.function = function;
                        }

                        public final /* synthetic */ Object apply(Object p0, Object p1) {
                            return this.function.invoke(p0, p1);
                        }
                    });
                }
                catch (Throwable e$iv$iv) {
                    throw e$iv$iv;
                }
                finally {
                    $this$write$iv$iv.unlock(stamp$iv$iv);
                }
            }
            catch (Throwable e) {
                VAFIndex.Companion.getLOGGER$cottontaildb_dbms().error("VA-SSA Scan: Error while scanning VAF index: " + e.getMessage());
            }
            return localSelection;
        }
    }
}

