/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.va;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Transaction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.binding.Binding;
import org.vitrivr.cottontail.core.queries.binding.BindingContext;
import org.vitrivr.cottontail.core.queries.binding.MissingTuple;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.SquaredEuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.RealVectorValue;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.execution.operators.sort.RecordComparator;
import org.vitrivr.cottontail.dbms.index.va.VAFIndex;
import org.vitrivr.cottontail.dbms.index.va.bounds.Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L1Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L2Bounds;
import org.vitrivr.cottontail.dbms.index.va.signature.EquidistantVAFMarks;
import org.vitrivr.cottontail.dbms.index.va.signature.VAFSignature;
import org.vitrivr.cottontail.utilities.selection.HeapSelection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0004>?@AB#\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\n\u0010\b\u001a\u00060\tR\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0004R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\b\u001a\u00060\tR\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0016\u0010\u0007\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010+\u001a\u0004\b)\u0010*R \u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030.0-X\u0084\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b/\u00100R\u0018\u00102\u001a\u0006\u0012\u0002\b\u000303X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\n  *\u0004\u0018\u00010808X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002BC\u00a8\u0006D"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor;", "T", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate;", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "boc", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getBoc", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "bounds", "Lorg/vitrivr/cottontail/dbms/index/va/bounds/Bounds;", "getBounds", "()Lorg/vitrivr/cottontail/dbms/index/va/bounds/Bounds;", "columnCursor", "Lorg/vitrivr/cottontail/core/types/Value;", "getColumnCursor", "()Lorg/vitrivr/cottontail/core/basics/Cursor;", "endKey", "Ljetbrains/exodus/ArrayByteIterable;", "getEndKey", "()Ljetbrains/exodus/ArrayByteIterable;", "getIndex", "()Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "indexCursor", "Ljetbrains/exodus/env/Cursor;", "kotlin.jvm.PlatformType", "getIndexCursor", "()Ljetbrains/exodus/env/Cursor;", "marks", "Lorg/vitrivr/cottontail/dbms/index/va/signature/EquidistantVAFMarks;", "getMarks", "()Lorg/vitrivr/cottontail/dbms/index/va/signature/EquidistantVAFMarks;", "getPartition", "()Lkotlin/ranges/LongRange;", "getPredicate", "()Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate;", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate;", "produces", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "query", "Lorg/vitrivr/cottontail/core/types/RealVectorValue;", "getQuery", "()Lorg/vitrivr/cottontail/core/types/RealVectorValue;", "startKey", "subTx", "Ljetbrains/exodus/env/Transaction;", "close", "", "reportAndUpdateEfficiency", "retrieved", "", "ENN", "FNS", "KLimited", "NNS", "Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$ENN;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$KLimited;", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nVAFCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VAFCursor.kt\norg/vitrivr/cottontail/dbms/index/va/VAFCursor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n37#2,2:293\n1#3:295\n*S KotlinDebug\n*F\n+ 1 VAFCursor.kt\norg/vitrivr/cottontail/dbms/index/va/VAFCursor\n*L\n65#1:293,2\n*E\n"})
public abstract class VAFCursor<T extends ProximityPredicate>
implements org.vitrivr.cottontail.core.basics.Cursor<Tuple> {
    @NotNull
    private final LongRange partition;
    @NotNull
    private final T predicate;
    @NotNull
    private final VAFIndex.Tx index;
    @NotNull
    private final RealVectorValue<?> query;
    @NotNull
    private final Bounds bounds;
    private final Transaction subTx;
    private final Cursor indexCursor;
    @NotNull
    private final org.vitrivr.cottontail.core.basics.Cursor<Value> columnCursor;
    @NotNull
    private final AtomicBoolean boc;
    @NotNull
    private final ArrayByteIterable startKey;
    @NotNull
    private final ArrayByteIterable endKey;
    @NotNull
    private final EquidistantVAFMarks marks;
    @NotNull
    private final ColumnDef<?>[] produces;

    private VAFCursor(LongRange partition, T predicate, VAFIndex.Tx index) {
        Bounds bounds;
        this.partition = partition;
        this.predicate = predicate;
        this.index = index;
        this.subTx = this.index.getContext().getTxn().getXodusTx().getReadonlySnapshot();
        this.indexCursor = this.index.getDataStore$cottontaildb_dbms().openCursor(this.subTx);
        this.boc = new AtomicBoolean(true);
        this.startKey = ExtensionsKt.toKey(this.partition.getFirst());
        this.endKey = ExtensionsKt.toKey(this.partition.getLast());
        this.marks = this.index.getMarks$cottontaildb_dbms();
        Collection $this$toTypedArray$iv = this.index.columnsFor((Predicate)this.predicate);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.produces = thisCollection$iv.toArray(new ColumnDef[0]);
        Binding queryVectorBinding = this.predicate.getQuery();
        MissingTuple $this$_init__u24lambda_u242 = MissingTuple.INSTANCE;
        boolean bl = false;
        BindingContext $this$lambda_u242_u24lambda_u241 = this.index.getContext().getBindings();
        boolean bl2 = false;
        Value value = queryVectorBinding.getValue($this$lambda_u242_u24lambda_u241, (Tuple)$this$_init__u24lambda_u242);
        if (!(value instanceof RealVectorValue)) {
            boolean bl3 = false;
            Value value2 = value;
            String string = "Bound value for query vector has wrong type (found = " + (Types)(value2 != null ? value2.getType() : null) + ").";
            throw new IllegalStateException(string.toString());
        }
        this.query = (RealVectorValue)value;
        VectorDistance $i$f$toTypedArray22 = this.predicate.getDistance();
        if ($i$f$toTypedArray22 instanceof ManhattanDistance) {
            bounds = new L1Bounds(this.query, this.marks);
        } else if ($i$f$toTypedArray22 instanceof EuclideanDistance ? true : $i$f$toTypedArray22 instanceof SquaredEuclideanDistance) {
            bounds = new L2Bounds(this.query, this.marks);
        } else {
            throw new IllegalArgumentException("The " + this.predicate.getDistance() + " distance kernel is not supported by VAFIndex.");
        }
        this.bounds = bounds;
        EntityTx entityTx = this.index.getDbo().getParent().newTx(this.index.getContext());
        ColumnDef columnDef2 = this.predicate.getColumn().getPhysical();
        Intrinsics.checkNotNull((Object)columnDef2);
        org.vitrivr.cottontail.core.basics.Cursor<?> cursor = entityTx.columnForName(columnDef2.getName()).newTx(this.index.getContext()).cursor();
        Intrinsics.checkNotNull(cursor, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.basics.Cursor<org.vitrivr.cottontail.core.types.Value?>");
        this.columnCursor = cursor;
        if (this.indexCursor.getSearchKeyRange((ByteIterable)this.startKey) == null) {
            this.boc.set(false);
        }
    }

    @NotNull
    protected final LongRange getPartition() {
        return this.partition;
    }

    @NotNull
    protected final T getPredicate() {
        return this.predicate;
    }

    @NotNull
    protected final VAFIndex.Tx getIndex() {
        return this.index;
    }

    @NotNull
    protected final RealVectorValue<?> getQuery() {
        return this.query;
    }

    @NotNull
    protected final Bounds getBounds() {
        return this.bounds;
    }

    protected final Cursor getIndexCursor() {
        return this.indexCursor;
    }

    @NotNull
    protected final org.vitrivr.cottontail.core.basics.Cursor<Value> getColumnCursor() {
        return this.columnCursor;
    }

    @NotNull
    protected final AtomicBoolean getBoc() {
        return this.boc;
    }

    @NotNull
    protected final ArrayByteIterable getEndKey() {
        return this.endKey;
    }

    @NotNull
    protected final EquidistantVAFMarks getMarks() {
        return this.marks;
    }

    @NotNull
    protected final ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    public void close() {
        this.columnCursor.close();
        this.indexCursor.close();
        this.subTx.abort();
    }

    protected final void reportAndUpdateEfficiency(long retrieved) {
        long partitionSize = this.partition.getLast() - this.partition.getFirst() + 1L;
        float efficiency = 1.0f - (float)retrieved / (float)partitionSize;
        this.index.updateEfficiency$cottontaildb_dbms(efficiency);
        Logger logger = VAFIndex.Companion.getLOGGER$cottontaildb_dbms();
        String string = "%.2f";
        Object[] objectArray = new Object[]{Float.valueOf(efficiency * 100.0f)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        logger.debug("VA-SSA Scan: Read " + retrieved + " and skipped over " + string2 + "% of entries.");
    }

    public boolean hasNext() {
        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean movePrevious() {
        return Cursor.DefaultImpls.movePrevious((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public boolean moveTo(long tupleId) {
        return Cursor.DefaultImpls.moveTo((org.vitrivr.cottontail.core.basics.Cursor)this, (long)tupleId);
    }

    @NotNull
    public Tuple next() {
        return (Tuple)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public /* synthetic */ VAFCursor(LongRange partition, ProximityPredicate predicate, VAFIndex.Tx index, DefaultConstructorMarker $constructor_marker) {
        this(partition, predicate, index);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$ENN;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor;", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$ENN;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$ENN;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "key", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "moveNext", "", "value", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "cottontaildb-dbms"})
    public static final class ENN
    extends VAFCursor<ProximityPredicate.ENN> {
        public ENN(@NotNull LongRange partition, @NotNull ProximityPredicate.ENN predicate, @NotNull VAFIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(partition, (ProximityPredicate)predicate, index, null);
        }

        public boolean moveNext() {
            while (this.getBoc().compareAndExchange(true, false) || this.getIndexCursor().getNext() && this.getIndexCursor().getKey().compareTo((Object)this.getEndKey()) < 0) {
                ByteIterable byteIterable = this.getIndexCursor().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
                byte[] signature = VAFSignature.Companion.fromEntry-lsqBzE4(byteIterable);
                Pair<Double, Double> pair = this.getBounds().bounds-s1HmYNQ(signature);
                double lb = ((Number)pair.component1()).doubleValue();
                double ub = ((Number)pair.component2()).doubleValue();
                if (!(((ProximityPredicate.ENN)this.getPredicate()).getEMin-5B6OyQQ() >= lb) || !(((ProximityPredicate.ENN)this.getPredicate()).getEMax-5B6OyQQ() < ub)) continue;
                return true;
            }
            return false;
        }

        public long key() {
            return LongBinding.compressedEntryToLong((ByteIterable)this.getIndexCursor().getKey());
        }

        @NotNull
        public Tuple value() {
            long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getIndexCursor().getKey());
            this.getColumnCursor().moveTo(tupleId);
            Value value = (Value)this.getColumnCursor().value();
            Value[] valueArray = new Value[]{this.getQuery(), value};
            Value value2 = ((ProximityPredicate.ENN)this.getPredicate()).getDistance().invoke(valueArray);
            Intrinsics.checkNotNull((Object)value2);
            double distance = ((DoubleValue)value2).unbox-impl();
            valueArray = new Value[]{DoubleValue.box-impl((double)distance), value};
            return (Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$FNS;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$KLimited;", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$FNS;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$FNS;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "prepareVASSA", "Lorg/vitrivr/cottontail/utilities/selection/HeapSelection;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "cottontaildb-dbms"})
    public static final class FNS
    extends KLimited<ProximityPredicate.FNS> {
        public FNS(@NotNull LongRange partition, @NotNull ProximityPredicate.FNS predicate, @NotNull VAFIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(partition, (ProximityPredicate.KLimitedSearch)predicate, index, null);
        }

        @Override
        @NotNull
        protected HeapSelection<Tuple> prepareVASSA() {
            HeapSelection<Tuple> localSelection = new HeapSelection<Tuple>((int)((ProximityPredicate.FNS)this.getPredicate()).getK(), new RecordComparator.SingleNonNullColumnComparator(((ProximityPredicate.FNS)this.getPredicate()).getDistanceColumn().getColumn(), SortOrder.DESCENDING));
            try {
                double threshold = 0.0;
                do {
                    long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getIndexCursor().getKey());
                    this.getColumnCursor().moveTo(tupleId);
                    Value value = (Value)this.getColumnCursor().value();
                    Value[] valueArray = new Value[]{this.getQuery(), value};
                    Value value2 = ((ProximityPredicate.FNS)this.getPredicate()).getDistance().invoke(valueArray);
                    Intrinsics.checkNotNull((Object)value2);
                    double distance = ((DoubleValue)value2).unbox-impl();
                    valueArray = new Value[]{DoubleValue.box-impl((double)distance), value};
                    localSelection.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray));
                } while (localSelection.getSize() < localSelection.getK() && this.getIndexCursor().getNext() && this.getIndexCursor().getKey().compareTo((Object)this.getEndKey()) <= 0);
                Tuple tuple = localSelection.peek();
                Intrinsics.checkNotNull((Object)tuple);
                Value value = tuple.get(0);
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
                threshold = ((DoubleValue)value).unbox-impl();
                while (this.getIndexCursor().getNext() && this.getIndexCursor().getKey().compareTo((Object)this.getEndKey()) <= 0) {
                    ByteIterable byteIterable = this.getIndexCursor().getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
                    byte[] signature = VAFSignature.Companion.fromEntry-lsqBzE4(byteIterable);
                    if (!(this.getBounds().ub-tU6kMXU(signature, threshold) < threshold)) continue;
                    long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getIndexCursor().getKey());
                    this.getColumnCursor().moveTo(tupleId);
                    Value value3 = (Value)this.getColumnCursor().value();
                    Value[] valueArray = new Value[]{this.getQuery(), value3};
                    Value value4 = ((ProximityPredicate.FNS)this.getPredicate()).getDistance().invoke(valueArray);
                    Intrinsics.checkNotNull((Object)value4);
                    double distance = ((DoubleValue)value4).unbox-impl();
                    Value[] valueArray2 = new Value[]{DoubleValue.box-impl((double)distance), value3};
                    Value value5 = localSelection.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray2)).get(0);
                    Intrinsics.checkNotNull((Object)value5, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
                    threshold = ((DoubleValue)value5).unbox-impl();
                }
                this.reportAndUpdateEfficiency(localSelection.getAdded());
            }
            catch (Throwable e) {
                VAFIndex.Companion.getLOGGER$cottontaildb_dbms().error("VA-SSA Scan: Error while scanning VAF index: " + e.getMessage());
                e.printStackTrace();
            }
            return localSelection;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\n\u0010\u0007\u001a\u00060\bR\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001dH$J\b\u0010\u001e\u001a\u00020\fH\u0016R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00128DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u0082\u0001\u0002\u001f \u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$KLimited;", "T", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$KLimitedSearch;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$KLimitedSearch;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "current", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "getCurrent", "()Lorg/vitrivr/cottontail/core/tuple/Tuple;", "setCurrent", "(Lorg/vitrivr/cottontail/core/tuple/Tuple;)V", "selection", "", "getSelection", "()Ljava/util/Iterator;", "selection$delegate", "Lkotlin/Lazy;", "key", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "moveNext", "", "prepareVASSA", "Lorg/vitrivr/cottontail/utilities/selection/HeapSelection;", "value", "Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$FNS;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$NNS;", "cottontaildb-dbms"})
    public static abstract class KLimited<T extends ProximityPredicate.KLimitedSearch>
    extends VAFCursor<T> {
        @NotNull
        private final Lazy selection$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Iterator<? extends Tuple>>(this){
            final /* synthetic */ KLimited<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Iterator<Tuple> invoke() {
                return this.this$0.getBoc().compareAndExchange(true, false) ? this.this$0.prepareVASSA().iterator() : CollectionsKt.emptyList().iterator();
            }
        }));
        @Nullable
        private Tuple current;

        private KLimited(LongRange partition, T predicate, VAFIndex.Tx index) {
            super(partition, (ProximityPredicate)predicate, index, null);
        }

        @NotNull
        protected final Iterator<Tuple> getSelection() {
            Lazy lazy = this.selection$delegate;
            return (Iterator)lazy.getValue();
        }

        @Nullable
        protected final Tuple getCurrent() {
            return this.current;
        }

        protected final void setCurrent(@Nullable Tuple tuple) {
            this.current = tuple;
        }

        public boolean moveNext() {
            if (!this.getSelection().hasNext()) {
                return false;
            }
            this.current = this.getSelection().next();
            return true;
        }

        public long key() {
            long l;
            try {
                Tuple tuple = this.current;
                Intrinsics.checkNotNull((Object)tuple);
                l = tuple.getTupleId();
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("VAFCursor is not currently pointing to a record.");
            }
            return l;
        }

        @NotNull
        public Tuple value() {
            Tuple tuple;
            try {
                Tuple tuple2 = this.current;
                Intrinsics.checkNotNull((Object)tuple2);
                tuple = tuple2;
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("VAFCursor is not currently pointing to a record.");
            }
            return tuple;
        }

        @NotNull
        protected abstract HeapSelection<Tuple> prepareVASSA();

        public /* synthetic */ KLimited(LongRange partition, ProximityPredicate.KLimitedSearch predicate, VAFIndex.Tx index, DefaultConstructorMarker $constructor_marker) {
            this(partition, predicate, index);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$NNS;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFCursor$KLimited;", "Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$NNS;", "partition", "Lkotlin/ranges/LongRange;", "predicate", "index", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "(Lkotlin/ranges/LongRange;Lorg/vitrivr/cottontail/core/queries/predicates/ProximityPredicate$NNS;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;)V", "prepareVASSA", "Lorg/vitrivr/cottontail/utilities/selection/HeapSelection;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "cottontaildb-dbms"})
    public static final class NNS
    extends KLimited<ProximityPredicate.NNS> {
        public NNS(@NotNull LongRange partition, @NotNull ProximityPredicate.NNS predicate, @NotNull VAFIndex.Tx index) {
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(partition, (ProximityPredicate.KLimitedSearch)predicate, index, null);
        }

        @Override
        @NotNull
        protected HeapSelection<Tuple> prepareVASSA() {
            HeapSelection<Tuple> localSelection = new HeapSelection<Tuple>((int)((ProximityPredicate.NNS)this.getPredicate()).getK(), new RecordComparator.SingleNonNullColumnComparator(((ProximityPredicate.NNS)this.getPredicate()).getDistanceColumn().getColumn(), SortOrder.ASCENDING));
            try {
                double threshold = 0.0;
                do {
                    long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getIndexCursor().getKey());
                    if (!this.getColumnCursor().moveTo(tupleId)) continue;
                    Value value = (Value)this.getColumnCursor().value();
                    Value[] valueArray = new Value[]{this.getQuery(), value};
                    Value value2 = ((ProximityPredicate.NNS)this.getPredicate()).getDistance().invoke(valueArray);
                    Intrinsics.checkNotNull((Object)value2);
                    double distance = ((DoubleValue)value2).unbox-impl();
                    valueArray = new Value[]{DoubleValue.box-impl((double)distance), value};
                    localSelection.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray));
                } while (localSelection.getSize() < localSelection.getK() && this.getIndexCursor().getNext() && this.getIndexCursor().getKey().compareTo((Object)this.getEndKey()) <= 0);
                Tuple tuple = localSelection.peek();
                Intrinsics.checkNotNull((Object)tuple);
                Value value = tuple.get(0);
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
                threshold = ((DoubleValue)value).unbox-impl();
                while (this.getIndexCursor().getNext() && this.getIndexCursor().getKey().compareTo((Object)this.getEndKey()) <= 0) {
                    ByteIterable byteIterable = this.getIndexCursor().getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
                    byte[] signature = VAFSignature.Companion.fromEntry-lsqBzE4(byteIterable);
                    if (!(this.getBounds().lb-tU6kMXU(signature, threshold) < threshold)) continue;
                    long tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.getIndexCursor().getKey());
                    this.getColumnCursor().moveTo(tupleId);
                    Value value3 = (Value)this.getColumnCursor().value();
                    Value[] valueArray = new Value[]{this.getQuery(), value3};
                    Value value4 = ((ProximityPredicate.NNS)this.getPredicate()).getDistance().invoke(valueArray);
                    Intrinsics.checkNotNull((Object)value4);
                    double distance = ((DoubleValue)value4).unbox-impl();
                    Value[] valueArray2 = new Value[]{DoubleValue.box-impl((double)distance), value3};
                    Value value5 = localSelection.offer((Tuple)new StandaloneTuple(tupleId, this.getProduces(), valueArray2)).get(0);
                    Intrinsics.checkNotNull((Object)value5, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleValue");
                    threshold = ((DoubleValue)value5).unbox-impl();
                }
                this.reportAndUpdateEfficiency(localSelection.getAdded());
            }
            catch (Throwable e) {
                VAFIndex.Companion.getLOGGER$cottontaildb_dbms().error("VA-SSA Scan: Error while scanning VAF index: " + e.getMessage());
                e.printStackTrace();
            }
            return localSelection;
        }
    }
}

