/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.va.bounds;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.RealVectorValue;
import org.vitrivr.cottontail.dbms.index.va.bounds.Bounds;
import org.vitrivr.cottontail.dbms.index.va.signature.EquidistantVAFMarks;
import org.vitrivr.cottontail.dbms.index.va.signature.VAFSignature;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\"\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\"\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001bR\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u0002\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/bounds/L2Bounds;", "Lorg/vitrivr/cottontail/dbms/index/va/bounds/Bounds;", "query", "Lorg/vitrivr/cottontail/core/types/RealVectorValue;", "marks", "Lorg/vitrivr/cottontail/dbms/index/va/signature/EquidistantVAFMarks;", "(Lorg/vitrivr/cottontail/core/types/RealVectorValue;Lorg/vitrivr/cottontail/dbms/index/va/signature/EquidistantVAFMarks;)V", "lat", "", "", "[[D", "getQuery", "()[D", "rq", "Lorg/vitrivr/cottontail/dbms/index/va/signature/VAFSignature;", "getRq-YXmdpLY", "()[B", "[B", "bounds", "Lkotlin/Pair;", "", "signature", "bounds-s1HmYNQ", "([B)Lkotlin/Pair;", "lb", "threshold", "lb-tU6kMXU", "([BD)D", "ub", "ub-tU6kMXU", "cottontaildb-dbms"})
public final class L2Bounds
extends Bounds {
    @NotNull
    private final double[] query;
    @NotNull
    private final byte[] rq;
    @NotNull
    private final double[][] lat;

    public L2Bounds(@NotNull RealVectorValue<?> query2, @NotNull EquidistantVAFMarks marks2) {
        int n;
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        Intrinsics.checkNotNullParameter((Object)marks2, (String)"marks");
        super(null);
        int n2 = 0;
        int n3 = query2.getLogicalSize();
        Object object = new double[n3];
        L2Bounds l2Bounds = this;
        while (n2 < n3) {
            n = n2++;
            object[n] = query2.get(n).asDouble-5B6OyQQ();
        }
        l2Bounds.query = object;
        this.rq = marks2.getSignature-lsqBzE4(query2);
        n3 = query2.getLogicalSize();
        object = new double[n3][];
        l2Bounds = this;
        for (n2 = 0; n2 < n3; ++n2) {
            n = n2;
            double qj = query2.get(n).getValue().doubleValue();
            int n4 = 0;
            int n5 = marks2.getMarks()[n].length;
            double[] dArray = new double[n5];
            int n6 = n;
            Object object2 = object;
            while (n4 < n5) {
                int n7 = n4++;
                dArray[n7] = Math.pow(qj - marks2.getMarks()[n][n7], 2);
            }
            object2[n6] = (double)dArray;
        }
        l2Bounds.lat = (double[][])object;
    }

    @Override
    @NotNull
    protected double[] getQuery() {
        return this.query;
    }

    @Override
    @NotNull
    protected byte[] getRq-YXmdpLY() {
        return this.rq;
    }

    @Override
    public double lb-tU6kMXU(@NotNull byte[] signature, double threshold) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        double t = Math.pow(threshold, 2);
        double sum = 0.0;
        int n = VAFSignature.size-impl(signature);
        for (int i2 = 0; i2 < n; ++i2) {
            int rij = VAFSignature.get-impl(signature, i2);
            int rq = VAFSignature.get-impl(this.getRq-YXmdpLY(), i2);
            double[] lat = this.lat[i2];
            if (rij >= rq ? rij > rq && (sum += lat[rij]) > t : (sum += lat[rij + 1]) > t) break;
        }
        return Math.sqrt(sum);
    }

    @Override
    public double ub-tU6kMXU(@NotNull byte[] signature, double threshold) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        double t = Math.pow(threshold, 2);
        double sum = 0.0;
        int n = VAFSignature.size-impl(signature);
        for (int i2 = 0; i2 < n; ++i2) {
            int rij = VAFSignature.get-impl(signature, i2);
            int rq = VAFSignature.get-impl(this.getRq-YXmdpLY(), i2);
            double[] lat = this.lat[i2];
            if ((sum += rij < rq ? lat[rij] : (rij > rq ? lat[rij + 1] : Math.max(lat[rij + 1], lat[rij]))) > t) break;
        }
        return Math.sqrt(sum);
    }

    @Override
    @NotNull
    public Pair<Double, Double> bounds-s1HmYNQ(@NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        double lb = 0.0;
        double ub = 0.0;
        int n = VAFSignature.size-impl(signature);
        for (int i2 = 0; i2 < n; ++i2) {
            int rij = VAFSignature.get-impl(signature, i2);
            int rq = VAFSignature.get-impl(this.getRq-YXmdpLY(), i2);
            double[] lat = this.lat[i2];
            if (rij < rq) {
                lb += lat[rij + 1];
                ub += lat[rij];
                continue;
            }
            if (rij > rq) {
                lb += lat[rij];
                ub += lat[rij + 1];
                continue;
            }
            ub += Math.max(lat[rij + 1], lat[rij]);
        }
        return new Pair((Object)Math.sqrt(lb), (Object)Math.sqrt(ub));
    }
}

