/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.schema;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.column.ColumnMetadata;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityMetadata;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.events.EntityEvent;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.index.basic.IndexTx;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;
import org.vitrivr.cottontail.dbms.sequence.DefaultSequence;
import org.vitrivr.cottontail.dbms.sequence.Sequence;
import org.vitrivr.cottontail.dbms.sequence.SequenceTx;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "parent", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "(Lorg/vitrivr/cottontail/core/database/Name$SchemaName;Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;)V", "catalogue", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "getParent", "newTx", "Lorg/vitrivr/cottontail/dbms/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "Tx", "cottontaildb-dbms"})
public final class DefaultSchema
implements Schema {
    @NotNull
    private final Name.SchemaName name;
    @NotNull
    private final DefaultCatalogue parent;
    @NotNull
    private final DefaultCatalogue catalogue;

    public DefaultSchema(@NotNull Name.SchemaName name, @NotNull DefaultCatalogue parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        this.catalogue = this.getParent();
    }

    @Override
    @NotNull
    public Name.SchemaName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DefaultCatalogue getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public SchemaTx newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SchemaTx schemaTx = (SchemaTx)context2.getTxn().getCachedTxForDBO(this);
        if (schemaTx == null) {
            schemaTx = new Tx(context2);
        }
        return schemaTx;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return Schema.DefaultImpls.getVersion(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "dbo", "Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "createEntity", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "columns", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "Lorg/vitrivr/cottontail/dbms/column/ColumnMetadata;", "createSequence", "Lorg/vitrivr/cottontail/dbms/sequence/Sequence;", "Lorg/vitrivr/cottontail/core/database/Name$SequenceName;", "dropEntity", "", "dropSequence", "entityForName", "listEntities", "listSequence", "sequenceForName", "truncateEntity", "cottontaildb-dbms"})
    @SourceDebugExtension(value={"SMAP\nDefaultSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSchema.kt\norg/vitrivr/cottontail/dbms/schema/DefaultSchema$Tx\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,276:1\n1549#2:277\n1620#2,3:278\n1549#2:281\n1620#2,3:282\n1855#2,2:287\n1549#2:289\n1620#2,3:290\n1855#2,2:295\n1855#2,2:297\n37#3,2:285\n37#3,2:293\n*S KotlinDebug\n*F\n+ 1 DefaultSchema.kt\norg/vitrivr/cottontail/dbms/schema/DefaultSchema$Tx\n*L\n142#1:277\n142#1:278,3\n151#1:281\n151#1:282,3\n192#1:287,2\n196#1:289\n196#1:290,3\n232#1:295,2\n241#1:297,2\n168#1:285,2\n220#1:293,2\n*E\n"})
    public final class Tx
    extends AbstractTx
    implements SchemaTx {
        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            context2.getTxn().cacheTx(this);
        }

        @Override
        @NotNull
        public DefaultSchema getDbo() {
            return DefaultSchema.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Name.EntityName> listEntities() {
            List list;
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = EntityMetadata.Companion.store(defaultSchema.getCatalogue(), this.getContext().getTxn().getXodusTx());
                List list2 = new ArrayList();
                Closeable closeable = (Closeable)store.openCursor(this.getContext().getTxn().getXodusTx());
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)closeable;
                    boolean bl2 = false;
                    if (cursor.getSearchKeyRange(NameBinding.Schema.INSTANCE.toEntry(defaultSchema.getName())) != null) {
                        do {
                            ByteIterable byteIterable = cursor.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getKey(...)");
                            Name.EntityName name = NameBinding.Entity.INSTANCE.fromEntry(byteIterable);
                            if (!Intrinsics.areEqual((Object)name.schema(), (Object)defaultSchema.getName())) break;
                            list2.add(name);
                        } while (cursor.getNext());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                list = list2;
            }
            finally {
                lock2.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Name.SequenceName> listSequence() {
            Store store = DefaultSequence.Companion.store(DefaultSchema.this.getCatalogue(), this.getContext().getTxn().getXodusTx());
            List list = new ArrayList();
            Closeable closeable = (Closeable)store.openCursor(this.getContext().getTxn().getXodusTx());
            DefaultSchema defaultSchema = DefaultSchema.this;
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                if (cursor.getSearchKeyRange(NameBinding.Schema.INSTANCE.toEntry(defaultSchema.getName())) != null) {
                    do {
                        ByteIterable byteIterable = cursor.getKey();
                        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getKey(...)");
                        Name.SequenceName name = NameBinding.Sequence.INSTANCE.fromEntry(byteIterable);
                        if (!Intrinsics.areEqual((Object)name.schema(), (Object)defaultSchema.getName())) break;
                        list.add(name);
                    } while (cursor.getNext());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Entity entityForName(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = EntityMetadata.Companion.store(defaultSchema.getCatalogue(), this.getContext().getTxn().getXodusTx());
                if (store.get(this.getContext().getTxn().getXodusTx(), NameBinding.Entity.INSTANCE.toEntry(name)) == null) {
                    throw new DatabaseException.EntityDoesNotExistException(name);
                }
                Entity entity = new DefaultEntity(name, defaultSchema);
                return entity;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Sequence sequenceForName(@NotNull Name.SequenceName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = DefaultSequence.Companion.store(defaultSchema.getCatalogue(), this.getContext().getTxn().getXodusTx());
                if (store.get(this.getContext().getTxn().getXodusTx(), NameBinding.Sequence.INSTANCE.toEntry(name)) == null) {
                    throw new DatabaseException.SequenceDoesNotExistException(name);
                }
                Sequence sequence = new DefaultSequence(name, defaultSchema);
                return sequence;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Entity createEntity(@NotNull Name.EntityName name, @NotNull List<Pair<Name.ColumnName, ColumnMetadata>> columns2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Collection<String> collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                boolean bl = false;
                if (columns2.isEmpty()) {
                    throw new DatabaseException.NoColumnException(name);
                }
                Store store = EntityMetadata.Companion.store(defaultSchema.getCatalogue(), this.getContext().getTxn().getXodusTx());
                Iterable iterable = columns2;
                long l = System.currentTimeMillis();
                boolean $i$f$map = false;
                void var12_12 = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(((Name.ColumnName)it.getFirst()).getColumn());
                }
                collection = (List)destination$iv$iv;
                List list = collection;
                long l2 = l;
                EntityMetadata entry = new EntityMetadata(l2, list);
                if (!store.add(this.getContext().getTxn().getXodusTx(), NameBinding.Entity.INSTANCE.toEntry(name), EntityMetadata.Companion.toEntry(entry))) {
                    throw new DatabaseException.EntityAlreadyExistsException(name);
                }
                defaultSchema.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openBitmap(ExtensionsKt.storeName(name), StoreConfig.WITHOUT_DUPLICATES, this.getContext().getTxn().getXodusTx());
                Iterable $this$map$iv2 = columns2;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair bl2 = (Pair)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    Store metadataStore = ColumnMetadata.Companion.store$cottontaildb_dbms(defaultSchema.getCatalogue(), this.getContext().getTxn().getXodusTx());
                    if (!metadataStore.add(this.getContext().getTxn().getXodusTx(), NameBinding.Column.INSTANCE.toEntry((Name.ColumnName)it.getFirst()), ColumnMetadata.Companion.toEntry((ColumnMetadata)it.getSecond()))) {
                        throw new DatabaseException.DuplicateColumnException(name, (Name.ColumnName)it.getFirst());
                    }
                    if (((ColumnMetadata)it.getSecond()).getAutoIncrement()) {
                        this.createSequence(defaultSchema.getName().sequence(((Name.ColumnName)it.getFirst()).getEntity() + "_" + ((Name.ColumnName)it.getFirst()).getColumn() + "_auto"));
                    }
                    if (defaultSchema.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName((Name.ColumnName)it.getFirst()), StoreConfig.WITHOUT_DUPLICATES, this.getContext().getTxn().getXodusTx(), true) == null) {
                        throw new DatabaseException.DataCorruptionException("CREATE entity " + name + " failed: Failed to create store for column " + (Pair)it + ".");
                    }
                    collection2.add(new ColumnDef((Name.ColumnName)it.getFirst(), ((ColumnMetadata)it.getSecond()).getType(), ((ColumnMetadata)it.getSecond()).getNullable(), ((ColumnMetadata)it.getSecond()).getPrimary(), ((ColumnMetadata)it.getSecond()).getAutoIncrement()));
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ColumnDef[] definitions = thisCollection$iv.toArray(new ColumnDef[0]);
                EntityEvent.Create event = new EntityEvent.Create(name, definitions);
                this.getContext().getTxn().signalEvent(event);
                Entity entity = new DefaultEntity(name, defaultSchema);
                return entity;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void dropEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                void $this$mapTo$iv$iv;
                Object it;
                boolean bl = false;
                Store entityMetadata = EntityMetadata.Companion.store(defaultSchema.getCatalogue(), this.getContext().getTxn().getXodusTx());
                if (entityMetadata.get(this.getContext().getTxn().getXodusTx(), NameBinding.Entity.INSTANCE.toEntry(name)) == null) {
                    throw new DatabaseException.EntityDoesNotExistException(name);
                }
                EntityTx entityTx = new DefaultEntity(name, defaultSchema).newTx(this.getContext());
                Iterable $this$forEach$iv = entityTx.listIndexes();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Name.IndexName)element$iv;
                    boolean bl2 = false;
                    entityTx.dropIndex((Name.IndexName)it);
                }
                Store columnMetadata = ColumnMetadata.Companion.store$cottontaildb_dbms(defaultSchema.getCatalogue(), this.getContext().getTxn().getXodusTx());
                Iterable $this$map$iv = entityTx.listColumns();
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    ColumnDef columnDef2 = (ColumnDef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    if (!columnMetadata.delete(this.getContext().getTxn().getXodusTx(), NameBinding.Column.INSTANCE.toEntry(it2.getName()))) {
                        throw new DatabaseException.DataCorruptionException("DROP entity " + name + " failed: Failed to delete column entry for column " + (ColumnDef)it2 + ".");
                    }
                    if (it2.getAutoIncrement()) {
                        this.dropSequence(defaultSchema.getName().sequence(it2.getName().getEntity() + "_" + it2.getName().getColumn() + "_auto"));
                    }
                    defaultSchema.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(it2.getName()), this.getContext().getTxn().getXodusTx());
                    collection.add(it2);
                }
                List dropped = (List)destination$iv$iv;
                if (!entityMetadata.delete(this.getContext().getTxn().getXodusTx(), NameBinding.Entity.INSTANCE.toEntry(name))) {
                    throw new DatabaseException.DataCorruptionException("DROP entity " + name + " failed: Failed to delete catalogue entry.");
                }
                defaultSchema.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(name) + "#bitmap", this.getContext().getTxn().getXodusTx());
                Collection $this$toTypedArray$iv = dropped;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                EntityEvent.Drop event = new EntityEvent.Drop(name, thisCollection$iv.toArray(new ColumnDef[0]));
                this.getContext().getTxn().signalEvent(event);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncateEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                ColumnDef it;
                boolean bl = false;
                EntityTx entityTx = this.entityForName(name).newTx(this.getContext());
                Iterable $this$forEach$iv = entityTx.listColumns();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ColumnDef)element$iv;
                    boolean bl2 = false;
                    defaultSchema.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().truncateStore(ExtensionsKt.storeName(name) + "#bitmap", this.getContext().getTxn().getXodusTx());
                    if (!it.getAutoIncrement()) continue;
                    SequenceTx sequenceTx = this.sequenceForName(defaultSchema.getName().sequence(it.getName().getEntity() + "_" + it.getName().getColumn() + "_auto")).newTx(this.getContext());
                    sequenceTx.reset-hRrSGgQ();
                }
                $this$forEach$iv = entityTx.listIndexes();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Name.IndexName)element$iv;
                    boolean bl3 = false;
                    IndexTx indexTx = entityTx.indexForName((Name.IndexName)it).newTx(this.getContext());
                    indexTx.getDbo().getType().getDescriptor().deinitialize((Name.IndexName)it, defaultSchema.getCatalogue(), this.getContext().getTxn());
                    indexTx.getDbo().getType().getDescriptor().initialize((Name.IndexName)it, defaultSchema.getCatalogue(), this.getContext().getTxn());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Sequence createSequence(@NotNull Name.SequenceName name) {
            DefaultSequence defaultSequence;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = DefaultSequence.Companion.store(defaultSchema.getCatalogue(), this.getContext().getTxn().getXodusTx());
                if (!store.put(this.getContext().getTxn().getXodusTx(), NameBinding.Sequence.INSTANCE.toEntry(name), (ByteIterable)LongBinding.longToCompressedEntry((long)0L))) {
                    throw new DatabaseException.SequenceAlreadyExistsException(name);
                }
                defaultSequence = new DefaultSequence(name, defaultSchema);
            }
            finally {
                lock2.unlock();
            }
            return defaultSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropSequence(@NotNull Name.SequenceName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultSchema defaultSchema = DefaultSchema.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = DefaultSequence.Companion.store(defaultSchema.getCatalogue(), this.getContext().getTxn().getXodusTx());
                if (!store.delete(this.getContext().getTxn().getXodusTx(), NameBinding.Sequence.INSTANCE.toEntry(name))) {
                    throw new DatabaseException.SequenceDoesNotExistException(name);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }
    }
}

