/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.random.RandomGenerator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.config.StatisticsConfig;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Scanable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueTx;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.events.DataEvent;
import org.vitrivr.cottontail.dbms.events.EntityEvent;
import org.vitrivr.cottontail.dbms.events.Event;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.transactions.Transaction;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionManager;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionObserver;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionType;
import org.vitrivr.cottontail.dbms.queries.context.DefaultQueryContext;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;
import org.vitrivr.cottontail.dbms.statistics.collectors.AbstractMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.BooleanMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.BooleanVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.ByteMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.ByteStringMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.Complex32MetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.Complex32VectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.Complex64MetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.Complex64VectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.DateMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.DoubleMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.DoubleVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.FloatMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.FloatVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.IntMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.IntVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.LongMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.LongVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.collectors.ShortMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.StringMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.UuidMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.metrics.EntityMetric;
import org.vitrivr.cottontail.dbms.statistics.storage.ColumnStatistic;
import org.vitrivr.cottontail.dbms.statistics.storage.StatisticsStorageManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\tH\u0086\u0002J(\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u00020\u00112\n\u0010#\u001a\u00060\u001dj\u0002`$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020!0&H\u0016J\u0014\u0010'\u001a\u00020\u00112\n\u0010#\u001a\u00060\u001dj\u0002`$H\u0016R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/StatisticsManager;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionObserver;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "manager", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "(Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "Ljava/lang/ref/SoftReference;", "Lorg/vitrivr/cottontail/dbms/statistics/storage/ColumnStatistic;", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "store", "Lorg/vitrivr/cottontail/dbms/statistics/storage/StatisticsStorageManager;", "gatherStatisticsForEntity", "", "entityName", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "get", "name", "getCollector", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsCollector;", "def", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "statisticsConfig", "Lorg/vitrivr/cottontail/config/StatisticsConfig;", "numberOfEntries", "", "isRelevant", "", "event", "Lorg/vitrivr/cottontail/dbms/events/Event;", "onCommit", "txId", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "events", "", "onDeliveryFailure", "Companion", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nStatisticsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsManager.kt\norg/vitrivr/cottontail/dbms/statistics/StatisticsManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,255:1\n13309#2,2:256\n13309#2,2:258\n13309#2,2:260\n13374#2,3:274\n13374#2,3:277\n18#3,4:262\n50#3,6:266\n56#3:280\n37#4,2:272\n*S KotlinDebug\n*F\n+ 1 StatisticsManager.kt\norg/vitrivr/cottontail/dbms/statistics/StatisticsManager\n*L\n74#1:256,2\n81#1:258,2\n87#1:260,2\n186#1:274,3\n193#1:277,3\n164#1:262,4\n164#1:266,6\n164#1:280\n170#1:272,2\n*E\n"})
public final class StatisticsManager
implements TransactionObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultCatalogue catalogue;
    @NotNull
    private final TransactionManager manager;
    @NotNull
    private final AtomicLong counter;
    @NotNull
    private final StatisticsStorageManager store;
    @NotNull
    private final ConcurrentHashMap<Name.ColumnName, SoftReference<ColumnStatistic>> cache;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsManager.class);

    public StatisticsManager(@NotNull DefaultCatalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.catalogue = catalogue;
        this.manager = manager;
        this.counter = new AtomicLong(0L);
        this.store = new StatisticsStorageManager(this.catalogue.getConfig());
        this.cache = new ConcurrentHashMap();
    }

    @Override
    public boolean isRelevant(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return event instanceof DataEvent || event instanceof EntityEvent;
    }

    @Override
    public void onCommit(long txId, @NotNull List<? extends Event> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        HashMap<Object, EntityMetric> updated = new HashMap<Object, EntityMetric>();
        for (Event entry : events) {
            boolean bl;
            ColumnDef<?> it;
            ColumnDef<?> element$iv;
            int n;
            int n2;
            boolean $i$f$forEach;
            ColumnDef<?>[] $this$forEach$iv;
            Event event = entry;
            if (event instanceof EntityEvent.Create) {
                $this$forEach$iv = ((EntityEvent.Create)entry).getColumns();
                $i$f$forEach = false;
                n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$forEach$iv[n];
                    bl = false;
                    this.store.setColumnStatistic(it.getName(), new ColumnStatistic(it));
                    this.store.setMetric(((EntityEvent.Create)entry).getName(), new EntityMetric(0L, 0L, 0L, 0L, 0L, 31, null));
                }
                continue;
            }
            if (event instanceof EntityEvent.Drop) {
                $this$forEach$iv = ((EntityEvent.Drop)entry).getColumns();
                $i$f$forEach = false;
                n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$forEach$iv[n];
                    bl = false;
                    this.store.deleteColumnStatistic(it.getName());
                }
                this.store.deleteMetric(((EntityEvent.Drop)entry).getName());
                continue;
            }
            if (event instanceof EntityEvent.Truncate) {
                $this$forEach$iv = ((EntityEvent.Truncate)entry).getColumns();
                $i$f$forEach = false;
                n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$forEach$iv[n];
                    bl = false;
                    this.store.setColumnStatistic(it.getName(), new ColumnStatistic(it));
                }
                this.store.setMetric(((EntityEvent.Truncate)entry).getName(), new EntityMetric(0L, 0L, 0L, 0L, 0L, 31, null));
                continue;
            }
            if (event instanceof DataEvent.Insert) {
                updated.compute(((DataEvent.Insert)entry).getEntity(), (arg_0, arg_1) -> StatisticsManager.onCommit$lambda$3((Function2)new Function2<Name.EntityName, EntityMetric, EntityMetric>(this){
                    final /* synthetic */ StatisticsManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @Nullable
                    public final EntityMetric invoke(@NotNull Name.EntityName k, @Nullable EntityMetric v) {
                        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                        EntityMetric entityMetric = v;
                        if (entityMetric == null && (entityMetric = StatisticsManager.access$getStore$p(this.this$0).getMetric(k)) == null) {
                            entityMetric = new EntityMetric(0L, 0L, 0L, 0L, 0L, 31, null);
                        }
                        EntityMetric metric = entityMetric;
                        metric.setInserts(metric.getInserts() + 1L);
                        metric.setDeltaSinceAnalysis(metric.getDeltaSinceAnalysis() + 1L);
                        return metric;
                    }
                }, arg_0, arg_1));
                continue;
            }
            if (event instanceof DataEvent.Update) {
                updated.compute(((DataEvent.Update)entry).getEntity(), (arg_0, arg_1) -> StatisticsManager.onCommit$lambda$4((Function2)new Function2<Name.EntityName, EntityMetric, EntityMetric>(this){
                    final /* synthetic */ StatisticsManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @Nullable
                    public final EntityMetric invoke(@NotNull Name.EntityName k, @Nullable EntityMetric v) {
                        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                        EntityMetric entityMetric = v;
                        if (entityMetric == null && (entityMetric = StatisticsManager.access$getStore$p(this.this$0).getMetric(k)) == null) {
                            entityMetric = new EntityMetric(0L, 0L, 0L, 0L, 0L, 31, null);
                        }
                        EntityMetric metric = entityMetric;
                        metric.setUpdates(metric.getUpdates() + 1L);
                        metric.setDeltaSinceAnalysis(metric.getDeltaSinceAnalysis() + 1L);
                        return metric;
                    }
                }, arg_0, arg_1));
                continue;
            }
            if (!(event instanceof DataEvent.Delete)) continue;
            updated.compute(((DataEvent.Delete)entry).getEntity(), (arg_0, arg_1) -> StatisticsManager.onCommit$lambda$5((Function2)new Function2<Name.EntityName, EntityMetric, EntityMetric>(this){
                final /* synthetic */ StatisticsManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @Nullable
                public final EntityMetric invoke(@NotNull Name.EntityName k, @Nullable EntityMetric v) {
                    Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                    EntityMetric entityMetric = v;
                    if (entityMetric == null && (entityMetric = StatisticsManager.access$getStore$p(this.this$0).getMetric(k)) == null) {
                        entityMetric = new EntityMetric(0L, 0L, 0L, 0L, 0L, 31, null);
                    }
                    EntityMetric metric = entityMetric;
                    metric.setDeletes(metric.getDeletes() + 1L);
                    metric.setDeltaSinceAnalysis(metric.getDeltaSinceAnalysis() + 1L);
                    return metric;
                }
            }, arg_0, arg_1));
        }
        for (Map.Entry entry : ((Map)updated).entrySet()) {
            Name.EntityName entity = (Name.EntityName)entry.getKey();
            EntityMetric metric = (EntityMetric)entry.getValue();
            this.store.setMetric(entity, metric);
            if (!((float)metric.getDeltaSinceAnalysis() >= this.catalogue.getConfig().getStatistics().getThreshold())) continue;
            this.manager.getExecutionManager().getServiceWorkerPool$cottontaildb_dbms().schedule(() -> StatisticsManager.onCommit$lambda$6(this, entity), 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void onDeliveryFailure(long txId) {
    }

    @Nullable
    public final ColumnStatistic get(@NotNull Name.ColumnName name) {
        ColumnStatistic metric;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SoftReference<ColumnStatistic> softReference = this.cache.get(name);
        ColumnStatistic columnStatistic = metric = softReference != null ? softReference.get() : null;
        if (metric != null) {
            return metric;
        }
        metric = this.store.get(name);
        if (metric == null) {
            return null;
        }
        ((Map)this.cache).put(name, new SoftReference<ColumnStatistic>(metric));
        return metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void gatherStatisticsForEntity(@NotNull Name.EntityName entityName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        LOGGER.info("Starting statistics gathering for entity " + entityName + ".");
        Transaction transaction = this.manager.startTransaction(TransactionType.SYSTEM_READONLY);
        DefaultQueryContext context2 = new DefaultQueryContext("statistics-manager-" + this.counter.incrementAndGet(), this.catalogue, transaction, null, 8, null);
        try {
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            CatalogueTx catalogueTx = this.catalogue.newTx(context2);
            Schema schema = catalogueTx.schemaForName(entityName.schema());
            SchemaTx schemaTx = schema.newTx(context2);
            Entity entity = schemaTx.entityForName(entityName);
            EntityTx entityTx = entity.newTx(context2);
            Collection $this$toTypedArray$iv = entityTx.listColumns();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] columns2 = thisCollection$iv.toArray(new ColumnDef[0]);
            float sampleProbability = this.catalogue.getConfig().getStatistics().getSampleProbability();
            long expectedEntries = (long)((float)entityTx.count() * sampleProbability);
            int n = 0;
            int n2 = columns2.length;
            Object[] objectArray = new MetricsCollector[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.getCollector(columns2[n3], this.catalogue.getConfig().getStatistics(), expectedEntries), (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.statistics.collectors.MetricsCollector<org.vitrivr.cottontail.core.types.Value>");
            }
            Object[] collectors = objectArray;
            AutoCloseable autoCloseable = (AutoCloseable)Scanable.DefaultImpls.cursor$default((Scanable)entityTx, (ColumnDef[])columns2, null, (int)2, null);
            Throwable throwable2 = null;
            try {
                Cursor cursor = (Cursor)autoCloseable;
                boolean bl2 = false;
                if (expectedEntries <= this.catalogue.getConfig().getStatistics().getMinimumSampleSize()) {
                    while (cursor.moveNext()) {
                        Tuple record = (Tuple)cursor.value();
                        Object[] $this$forEachIndexed$iv = collectors;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            void collect;
                            int n4 = index$iv++;
                            Object object = item$iv;
                            int index = n4;
                            boolean bl3 = false;
                            collect.receive(record.get(index));
                        }
                    }
                } else {
                    RandomGenerator generator = this.catalogue.getConfig().getStatistics().randomGenerator();
                    while (cursor.moveNext()) {
                        if (!(generator.nextDouble(0.0, 1.0) <= (double)sampleProbability)) continue;
                        Tuple record = (Tuple)cursor.value();
                        Object[] $this$forEachIndexed$iv = collectors;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            void collect;
                            int n5 = index$iv++;
                            Object index = item$iv;
                            int index2 = n5;
                            boolean bl4 = false;
                            collect.receive(record.get(index2));
                        }
                    }
                }
                cursor = Unit.INSTANCE;
            }
            catch (Throwable cursor) {
                throwable2 = cursor;
                throw cursor;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            for (Throwable throwable2 : ArraysKt.zip((Object[])columns2, (Object[])collectors)) {
                ColumnDef column = (ColumnDef)throwable2.component1();
                MetricsCollector collector = (MetricsCollector)throwable2.component2();
                this.store.setColumnStatistic(column.getName(), new ColumnStatistic(column.getType(), collector.calculate(sampleProbability)));
                this.cache.remove(column.getName());
            }
            EntityMetric entityMetric = this.store.getMetric(entityName);
            if (entityMetric == null) {
                entityMetric = new EntityMetric(0L, 0L, 0L, 0L, 0L, 31, null);
            }
            EntityMetric metric = entityMetric;
            metric.setDeltaSinceAnalysis(0L);
            metric.setLastAnalysis(System.currentTimeMillis());
            this.store.setMetric(entityName, metric);
            long duration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            LOGGER.info("Statistics gathering for entity " + entityName + " completed successfully (took " + Duration.toString-impl((long)duration) + ").");
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Statistics manager failed to update entity statistics because schema " + entityName.schema() + " does not exist.");
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            LOGGER.error("Statistics manager failed to update entity statistics because entity " + entityName + " does not exist.");
        }
        catch (Throwable e) {
            LOGGER.error("Statistics manager failed to update entity statistics due to exception: " + e.getMessage() + ".");
        }
        finally {
            transaction.rollback();
        }
    }

    private final MetricsCollector<?> getCollector(ColumnDef<?> def, StatisticsConfig statisticsConfig, long numberOfEntries) {
        AbstractMetricsCollector abstractMetricsCollector;
        MetricsConfig config = new MetricsConfig(statisticsConfig, numberOfEntries);
        Types types = def.getType();
        if (Intrinsics.areEqual((Object)types, (Object)Types.Boolean.INSTANCE)) {
            abstractMetricsCollector = new BooleanMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Byte.INSTANCE)) {
            abstractMetricsCollector = new ByteMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Short.INSTANCE)) {
            abstractMetricsCollector = new ShortMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Date.INSTANCE)) {
            abstractMetricsCollector = new DateMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Double.INSTANCE)) {
            abstractMetricsCollector = new DoubleMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Float.INSTANCE)) {
            abstractMetricsCollector = new FloatMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Int.INSTANCE)) {
            abstractMetricsCollector = new IntMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Long.INSTANCE)) {
            abstractMetricsCollector = new LongMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.String.INSTANCE)) {
            abstractMetricsCollector = new StringMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Uuid.INSTANCE)) {
            abstractMetricsCollector = new UuidMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.ByteString.INSTANCE)) {
            abstractMetricsCollector = new ByteStringMetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Complex32.INSTANCE)) {
            abstractMetricsCollector = new Complex32MetricsCollector(config);
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Complex64.INSTANCE)) {
            abstractMetricsCollector = new Complex64MetricsCollector(config);
        } else if (types instanceof Types.BooleanVector) {
            abstractMetricsCollector = new BooleanVectorMetricsCollector(def.getType().getLogicalSize(), config);
        } else if (types instanceof Types.DoubleVector) {
            abstractMetricsCollector = new DoubleVectorMetricsCollector(def.getType().getLogicalSize(), config);
        } else if (types instanceof Types.FloatVector) {
            abstractMetricsCollector = new FloatVectorMetricsCollector(def.getType().getLogicalSize(), config);
        } else if (types instanceof Types.IntVector) {
            abstractMetricsCollector = new IntVectorMetricsCollector(def.getType().getLogicalSize(), config);
        } else if (types instanceof Types.LongVector) {
            abstractMetricsCollector = new LongVectorMetricsCollector(def.getType().getLogicalSize(), config);
        } else if (types instanceof Types.Complex32Vector) {
            abstractMetricsCollector = new Complex32VectorMetricsCollector(def.getType().getLogicalSize(), config);
        } else if (types instanceof Types.Complex64Vector) {
            abstractMetricsCollector = new Complex64VectorMetricsCollector(def.getType().getLogicalSize(), config);
        } else {
            throw new IllegalArgumentException("Invalid column type");
        }
        AbstractMetricsCollector collector = abstractMetricsCollector;
        return collector;
    }

    private static final EntityMetric onCommit$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EntityMetric)$tmp0.invoke(p0, p1);
    }

    private static final EntityMetric onCommit$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EntityMetric)$tmp0.invoke(p0, p1);
    }

    private static final EntityMetric onCommit$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EntityMetric)$tmp0.invoke(p0, p1);
    }

    private static final void onCommit$lambda$6(StatisticsManager this$0, Name.EntityName $entity) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        this$0.gatherStatisticsForEntity($entity);
    }

    public static final /* synthetic */ StatisticsStorageManager access$getStore$p(StatisticsManager $this) {
        return $this.store;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/StatisticsManager$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

