/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.Complex64VectorValue;
import org.vitrivr.cottontail.dbms.statistics.collectors.AbstractVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.values.Complex64VectorValueStatistics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/Complex64VectorMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/AbstractVectorMetricsCollector;", "Lorg/vitrivr/cottontail/core/values/Complex64VectorValue;", "logicalSize", "", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(ILorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "getLogicalSize", "()I", "calculate", "Lorg/vitrivr/cottontail/dbms/statistics/values/Complex64VectorValueStatistics;", "probability", "", "cottontaildb-dbms"})
public final class Complex64VectorMetricsCollector
extends AbstractVectorMetricsCollector<Complex64VectorValue> {
    private final int logicalSize;

    public Complex64VectorMetricsCollector(int logicalSize, @NotNull MetricsConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super((Types)new Types.Complex64Vector(logicalSize), config, null);
        this.logicalSize = logicalSize;
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    @NotNull
    public Complex64VectorValueStatistics calculate(float probability) {
        Complex64VectorValueStatistics sampleMetrics = new Complex64VectorValueStatistics(this.logicalSize, this.getNumberOfNullEntries(), this.getNumberOfNonNullEntries(), this.getNumberOfDistinctEntries());
        return new Complex64VectorValueStatistics(1.0f / probability, sampleMetrics);
    }
}

