/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.collectors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.LongVectorValue;
import org.vitrivr.cottontail.dbms.statistics.collectors.MetricsConfig;
import org.vitrivr.cottontail.dbms.statistics.collectors.RealVectorMetricsCollector;
import org.vitrivr.cottontail.dbms.statistics.values.LongVectorValueStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u000e\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\fR\u0019\u0010\u0010\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u0011\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/collectors/LongVectorMetricsCollector;", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/RealVectorMetricsCollector;", "Lorg/vitrivr/cottontail/core/values/LongVectorValue;", "logicalSize", "", "config", "Lorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;", "(ILorg/vitrivr/cottontail/dbms/statistics/collectors/MetricsConfig;)V", "getLogicalSize", "()I", "max", "getMax-KCB4rAk", "()[J", "[J", "min", "getMin-KCB4rAk", "sum", "getSum-KCB4rAk", "calculate", "Lorg/vitrivr/cottontail/dbms/statistics/values/LongVectorValueStatistics;", "probability", "", "receive", "", "value", "receive-KvwBEqU", "([J)V", "cottontaildb-dbms"})
public final class LongVectorMetricsCollector
extends RealVectorMetricsCollector<LongVectorValue> {
    private final int logicalSize;
    @NotNull
    private final long[] min;
    @NotNull
    private final long[] max;
    @NotNull
    private final long[] sum;

    public LongVectorMetricsCollector(int logicalSize, @NotNull MetricsConfig config) {
        int n;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super((Types)new Types.LongVector(logicalSize), config, null);
        this.logicalSize = logicalSize;
        int n2 = 0;
        int n3 = this.logicalSize;
        long[] lArray = new long[n3];
        LongVectorMetricsCollector longVectorMetricsCollector = this;
        while (n2 < n3) {
            n = n2++;
            lArray[n] = Long.MAX_VALUE;
        }
        longVectorMetricsCollector.min = LongVectorValue.constructor-impl((long[])lArray);
        n2 = 0;
        n3 = this.logicalSize;
        lArray = new long[n3];
        longVectorMetricsCollector = this;
        while (n2 < n3) {
            n = n2++;
            lArray[n] = Long.MIN_VALUE;
        }
        longVectorMetricsCollector.max = LongVectorValue.constructor-impl((long[])lArray);
        this.sum = LongVectorValue.constructor-impl((long[])new long[this.logicalSize]);
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    @NotNull
    public final long[] getMin-KCB4rAk() {
        return this.min;
    }

    @NotNull
    public final long[] getMax-KCB4rAk() {
        return this.max;
    }

    @NotNull
    public final long[] getSum-KCB4rAk() {
        return this.sum;
    }

    public void receive-KvwBEqU(@Nullable long[] value) {
        super.receive(value != null ? LongVectorValue.box-impl((long[])value) : null);
        if (value != null) {
            long[] lArray = value;
            int n = lArray.length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                long d = lArray[j];
                this.min[i2] = Long.min(d, this.min[i2]);
                this.max[i2] = Long.min(d, this.max[i2]);
                long[] lArray2 = this.sum;
                lArray2[i2] = lArray2[i2] + d;
            }
        }
    }

    @NotNull
    public LongVectorValueStatistics calculate(float probability) {
        LongVectorValueStatistics sampleMetrics = new LongVectorValueStatistics(this.logicalSize, this.getNumberOfNullEntries(), this.getNumberOfNonNullEntries(), this.getNumberOfDistinctEntries(), this.min, this.max, this.sum, null);
        return new LongVectorValueStatistics(1.0f / probability, sampleMetrics);
    }
}

