/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.values;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.SignedFloatBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.dbms.statistics.values.RealVectorValueStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.MetricsXodusBinding;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00016B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006BI\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0010J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\u0016\u0010&\u001a\u00020\u0002H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b'\u0010\u0014J\u0016\u0010(\u001a\u00020\u0002H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b)\u0010\u0014J\u0016\u0010*\u001a\u00020\u0002H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010\u0014JY\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0002H\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\t\u00103\u001a\u00020\bH\u00d6\u0001J\t\u00104\u001a\u000205H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u000e\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u00028VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u001c\u0010\r\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0018\u0010\u0014R\u001a\u0010\f\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u000b\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001a\"\u0004\b \u0010\u001cR\u001c\u0010\u000f\u001a\u00020\u0002X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b!\u0010\u0014\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00067"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/FloatVectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/values/RealVectorValueStatistics;", "Lorg/vitrivr/cottontail/core/values/FloatVectorValue;", "factor", "", "metrics", "(FLorg/vitrivr/cottontail/dbms/statistics/values/FloatVectorValueStatistics;)V", "logicalSize", "", "numberOfNullEntries", "", "numberOfNonNullEntries", "numberOfDistinctEntries", "min", "max", "sum", "(IJJJ[F[F[FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getLogicalSize", "()I", "getMax-JdBqzJc", "()[F", "[F", "mean", "getMean-JdBqzJc", "getMin-JdBqzJc", "getNumberOfDistinctEntries", "()J", "setNumberOfDistinctEntries", "(J)V", "getNumberOfNonNullEntries", "setNumberOfNonNullEntries", "getNumberOfNullEntries", "setNumberOfNullEntries", "getSum-JdBqzJc", "component1", "component2", "component3", "component4", "component5", "component5-JdBqzJc", "component6", "component6-JdBqzJc", "component7", "component7-JdBqzJc", "copy", "copy-uTnUhQg", "(IJJJ[F[F[F)Lorg/vitrivr/cottontail/dbms/statistics/values/FloatVectorValueStatistics;", "equals", "", "other", "", "hashCode", "toString", "", "Binding", "cottontaildb-dbms"})
public final class FloatVectorValueStatistics
extends RealVectorValueStatistics<FloatVectorValue> {
    private final int logicalSize;
    private long numberOfNullEntries;
    private long numberOfNonNullEntries;
    private long numberOfDistinctEntries;
    @NotNull
    private final float[] min;
    @NotNull
    private final float[] max;
    @NotNull
    private final float[] sum;

    private FloatVectorValueStatistics(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, float[] min, float[] max, float[] sum) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter((Object)sum, (String)"sum");
        super((Types)new Types.FloatVector(logicalSize), null);
        this.logicalSize = logicalSize;
        this.numberOfNullEntries = numberOfNullEntries;
        this.numberOfNonNullEntries = numberOfNonNullEntries;
        this.numberOfDistinctEntries = numberOfDistinctEntries;
        this.min = min;
        this.max = max;
        this.sum = sum;
    }

    public /* synthetic */ FloatVectorValueStatistics(int n, long l, long l2, long l3, float[] fArray, float[] fArray2, float[] fArray3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        int n3;
        float[] fArray4;
        int n4;
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        if ((n2 & 8) != 0) {
            l3 = 0L;
        }
        if ((n2 & 0x10) != 0) {
            n4 = 0;
            fArray4 = new float[n];
            while (n4 < n) {
                n3 = n4++;
                fArray4[n3] = Float.MAX_VALUE;
            }
            fArray = FloatVectorValue.constructor-impl((float[])fArray4);
        }
        if ((n2 & 0x20) != 0) {
            n4 = 0;
            fArray4 = new float[n];
            while (n4 < n) {
                n3 = n4++;
                fArray4[n3] = Float.MIN_VALUE;
            }
            fArray2 = FloatVectorValue.constructor-impl((float[])fArray4);
        }
        if ((n2 & 0x40) != 0) {
            fArray3 = FloatVectorValue.constructor-impl((float[])new float[n]);
        }
        this(n, l, l2, l3, fArray, fArray2, fArray3, null);
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    @Override
    public long getNumberOfNullEntries() {
        return this.numberOfNullEntries;
    }

    @Override
    public void setNumberOfNullEntries(long l) {
        this.numberOfNullEntries = l;
    }

    @Override
    public long getNumberOfNonNullEntries() {
        return this.numberOfNonNullEntries;
    }

    @Override
    public void setNumberOfNonNullEntries(long l) {
        this.numberOfNonNullEntries = l;
    }

    @Override
    public long getNumberOfDistinctEntries() {
        return this.numberOfDistinctEntries;
    }

    @Override
    public void setNumberOfDistinctEntries(long l) {
        this.numberOfDistinctEntries = l;
    }

    @NotNull
    public float[] getMin-JdBqzJc() {
        return this.min;
    }

    @NotNull
    public float[] getMax-JdBqzJc() {
        return this.max;
    }

    @NotNull
    public float[] getSum-JdBqzJc() {
        return this.sum;
    }

    public FloatVectorValueStatistics(float factor, @NotNull FloatVectorValueStatistics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        int n = 0;
        int n2 = metrics.logicalSize;
        float[] fArray = new float[n2];
        float[] fArray2 = metrics.getMax-JdBqzJc();
        float[] fArray3 = metrics.getMin-JdBqzJc();
        long l = (double)metrics.getNumberOfDistinctEntries() / (double)metrics.getNumberOfEntries() >= (double)metrics.getDistinctEntriesScalingThreshold() ? (long)((float)metrics.getNumberOfDistinctEntries() * factor) : metrics.getNumberOfDistinctEntries();
        long l2 = (long)((float)metrics.getNumberOfNonNullEntries() * factor);
        long l3 = (long)((float)metrics.getNumberOfNullEntries() * factor);
        int n3 = metrics.logicalSize;
        FloatVectorValueStatistics floatVectorValueStatistics = this;
        while (n < n2) {
            int n4 = n++;
            fArray[n4] = metrics.getSum-JdBqzJc()[n4] * factor;
        }
        floatVectorValueStatistics(n3, l3, l2, l, fArray3, fArray2, FloatVectorValue.constructor-impl((float[])fArray), null);
    }

    @NotNull
    public float[] getMean-JdBqzJc() {
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = FloatVectorValue.get-PgYoAEc((float[])this.getSum-JdBqzJc(), (int)n3) / (float)this.getNumberOfNonNullEntries();
        }
        return FloatVectorValue.constructor-impl((float[])fArray);
    }

    public final int component1() {
        return this.logicalSize;
    }

    public final long component2() {
        return this.numberOfNullEntries;
    }

    public final long component3() {
        return this.numberOfNonNullEntries;
    }

    public final long component4() {
        return this.numberOfDistinctEntries;
    }

    @NotNull
    public final float[] component5-JdBqzJc() {
        return this.min;
    }

    @NotNull
    public final float[] component6-JdBqzJc() {
        return this.max;
    }

    @NotNull
    public final float[] component7-JdBqzJc() {
        return this.sum;
    }

    @NotNull
    public final FloatVectorValueStatistics copy-uTnUhQg(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, @NotNull float[] min, @NotNull float[] max, @NotNull float[] sum) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter((Object)sum, (String)"sum");
        return new FloatVectorValueStatistics(logicalSize, numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries, min, max, sum, null);
    }

    public static /* synthetic */ FloatVectorValueStatistics copy-uTnUhQg$default(FloatVectorValueStatistics floatVectorValueStatistics, int n, long l, long l2, long l3, float[] fArray, float[] fArray2, float[] fArray3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = floatVectorValueStatistics.logicalSize;
        }
        if ((n2 & 2) != 0) {
            l = floatVectorValueStatistics.numberOfNullEntries;
        }
        if ((n2 & 4) != 0) {
            l2 = floatVectorValueStatistics.numberOfNonNullEntries;
        }
        if ((n2 & 8) != 0) {
            l3 = floatVectorValueStatistics.numberOfDistinctEntries;
        }
        if ((n2 & 0x10) != 0) {
            fArray = floatVectorValueStatistics.min;
        }
        if ((n2 & 0x20) != 0) {
            fArray2 = floatVectorValueStatistics.max;
        }
        if ((n2 & 0x40) != 0) {
            fArray3 = floatVectorValueStatistics.sum;
        }
        return floatVectorValueStatistics.copy-uTnUhQg(n, l, l2, l3, fArray, fArray2, fArray3);
    }

    @NotNull
    public String toString() {
        return "FloatVectorValueStatistics(logicalSize=" + this.logicalSize + ", numberOfNullEntries=" + this.numberOfNullEntries + ", numberOfNonNullEntries=" + this.numberOfNonNullEntries + ", numberOfDistinctEntries=" + this.numberOfDistinctEntries + ", min=" + FloatVectorValue.toString-impl((float[])this.min) + ", max=" + FloatVectorValue.toString-impl((float[])this.max) + ", sum=" + FloatVectorValue.toString-impl((float[])this.sum) + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.logicalSize);
        result = result * 31 + Long.hashCode(this.numberOfNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfNonNullEntries);
        result = result * 31 + Long.hashCode(this.numberOfDistinctEntries);
        result = result * 31 + FloatVectorValue.hashCode-impl((float[])this.min);
        result = result * 31 + FloatVectorValue.hashCode-impl((float[])this.max);
        result = result * 31 + FloatVectorValue.hashCode-impl((float[])this.sum);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FloatVectorValueStatistics)) {
            return false;
        }
        FloatVectorValueStatistics floatVectorValueStatistics = (FloatVectorValueStatistics)other;
        if (this.logicalSize != floatVectorValueStatistics.logicalSize) {
            return false;
        }
        if (this.numberOfNullEntries != floatVectorValueStatistics.numberOfNullEntries) {
            return false;
        }
        if (this.numberOfNonNullEntries != floatVectorValueStatistics.numberOfNonNullEntries) {
            return false;
        }
        if (this.numberOfDistinctEntries != floatVectorValueStatistics.numberOfDistinctEntries) {
            return false;
        }
        if (!FloatVectorValue.equals-impl0((float[])this.min, (float[])floatVectorValueStatistics.min)) {
            return false;
        }
        if (!FloatVectorValue.equals-impl0((float[])this.max, (float[])floatVectorValueStatistics.max)) {
            return false;
        }
        return FloatVectorValue.equals-impl0((float[])this.sum, (float[])floatVectorValueStatistics.sum);
    }

    public /* synthetic */ FloatVectorValueStatistics(int logicalSize, long numberOfNullEntries, long numberOfNonNullEntries, long numberOfDistinctEntries, float[] min, float[] max, float[] sum, DefaultConstructorMarker $constructor_marker) {
        this(logicalSize, numberOfNullEntries, numberOfNonNullEntries, numberOfDistinctEntries, min, max, sum);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/values/FloatVectorValueStatistics$Binding;", "Lorg/vitrivr/cottontail/storage/serializers/statistics/MetricsXodusBinding;", "Lorg/vitrivr/cottontail/dbms/statistics/values/FloatVectorValueStatistics;", "logicalSize", "", "(I)V", "getLogicalSize", "()I", "read", "stream", "Ljava/io/ByteArrayInputStream;", "write", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "statistics", "cottontaildb-dbms"})
    public static final class Binding
    implements MetricsXodusBinding<FloatVectorValueStatistics> {
        private final int logicalSize;

        public Binding(int logicalSize) {
            this.logicalSize = logicalSize;
        }

        public final int getLogicalSize() {
            return this.logicalSize;
        }

        @Override
        @NotNull
        public FloatVectorValueStatistics read(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            FloatVectorValueStatistics stat = new FloatVectorValueStatistics(this.logicalSize, 0L, 0L, 0L, null, null, null, 126, null);
            stat.setNumberOfNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfNonNullEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            stat.setNumberOfDistinctEntries(LongBinding.readCompressed((ByteArrayInputStream)stream));
            int n = this.logicalSize;
            for (int i2 = 0; i2 < n; ++i2) {
                float[] fArray = stat.getMin-JdBqzJc();
                Float f = SignedFloatBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)f, (String)"readObject(...)");
                fArray[i2] = ((Number)f).floatValue();
                float[] fArray2 = stat.getMax-JdBqzJc();
                Float f2 = SignedFloatBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"readObject(...)");
                fArray2[i2] = ((Number)f2).floatValue();
                float[] fArray3 = stat.getSum-JdBqzJc();
                Float f3 = SignedFloatBinding.BINDING.readObject(stream);
                Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"readObject(...)");
                fArray3[i2] = ((Number)f3).floatValue();
            }
            return stat;
        }

        @Override
        public void write(@NotNull LightOutputStream output, @NotNull FloatVectorValueStatistics statistics2) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)statistics2, (String)"statistics");
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfNonNullEntries());
            LongBinding.writeCompressed((LightOutputStream)output, (long)statistics2.getNumberOfDistinctEntries());
            int n = statistics2.getType().getLogicalSize();
            for (int i2 = 0; i2 < n; ++i2) {
                SignedFloatBinding.BINDING.writeObject(output, (Comparable)Float.valueOf(statistics2.getMin-JdBqzJc()[i2]));
                SignedFloatBinding.BINDING.writeObject(output, (Comparable)Float.valueOf(statistics2.getMax-JdBqzJc()[i2]));
                SignedFloatBinding.BINDING.writeObject(output, (Comparable)Float.valueOf(statistics2.getSum-JdBqzJc()[i2]));
            }
        }
    }
}

