/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.StatusException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.execution.operators.basics.Operator;
import org.vitrivr.cottontail.dbms.execution.operators.system.ExplainQueryOperator;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionManager;
import org.vitrivr.cottontail.dbms.queries.QueryHint;
import org.vitrivr.cottontail.dbms.queries.binding.GrpcQueryBinder;
import org.vitrivr.cottontail.dbms.queries.context.DefaultQueryContext;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.queries.operators.basics.OperatorNode;
import org.vitrivr.cottontail.dbms.queries.planning.CottontailQueryPlanner;
import org.vitrivr.cottontail.dbms.queries.planning.rules.RewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.logical.LeftConjunctionRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.logical.RightConjunctionRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.index.BooleanIndexScanRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.index.FulltextIndexRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.index.NNSIndexScanClass1Rule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.index.NNSIndexScanClass3Rule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.pushdown.CountPushdownRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.simd.FunctionVectorisationRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.sort.ExternalSortRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.sort.LimitingSortMergeRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.transform.DeferFetchOnFetchRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.transform.DeferFetchOnScanRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.transform.DeferFunctionRewriteRule;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DQLGrpcKt;
import org.vitrivr.cottontail.server.grpc.services.TransactionalGrpcService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DQLService;", "Lorg/vitrivr/cottontail/grpc/DQLGrpcKt$DQLCoroutineImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionalGrpcService;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "(Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "planner", "Lorg/vitrivr/cottontail/dbms/queries/planning/CottontailQueryPlanner;", "explain", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage;", "ping", "Lcom/google/protobuf/Empty;", "(Lcom/google/protobuf/Empty;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "query", "cottontaildb-dbms"})
@ExperimentalTime
public final class DQLService
extends DQLGrpcKt.DQLCoroutineImplBase
implements TransactionalGrpcService {
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final CottontailQueryPlanner planner;

    public DQLService(@NotNull Catalogue catalogue) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        super(null, 1, null);
        this.catalogue = catalogue;
        Object[] objectArray = new RewriteRule[]{LeftConjunctionRewriteRule.INSTANCE, RightConjunctionRewriteRule.INSTANCE};
        List logical = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new RewriteRule[]{BooleanIndexScanRule.INSTANCE, NNSIndexScanClass1Rule.INSTANCE, NNSIndexScanClass3Rule.INSTANCE, FulltextIndexRule.INSTANCE, CountPushdownRule.INSTANCE, ExternalSortRule.INSTANCE, LimitingSortMergeRule.INSTANCE, DeferFetchOnScanRewriteRule.INSTANCE, DeferFetchOnFetchRewriteRule.INSTANCE, DeferFunctionRewriteRule.INSTANCE};
        List physical = CollectionsKt.mutableListOf((Object[])objectArray2);
        if (this.getCatalogue().getConfig().getExecution().getSimd()) {
            ((Collection)physical).add(new FunctionVectorisationRule(this.getCatalogue().getConfig().getExecution().getSimdThreshold()));
        }
        this.planner = new CottontailQueryPlanner(logical, physical, this.getCatalogue().getConfig().getCache().getPlanCacheSize());
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.catalogue;
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> query(@NotNull CottontailGrpc.QueryMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return this.prepareAndExecute(requestMetadata, true, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.QueryMessage $request;
            final /* synthetic */ DQLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.QueryMessage queryMessage = this.$request;
                DQLService dQLService = this.this$0;
                DefaultQueryContext $this$invoke_u24lambda_u240 = ctx;
                boolean bl = false;
                QueryContext queryContext = $this$invoke_u24lambda_u240;
                CottontailGrpc.Query query2 = queryMessage.getQuery();
                Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"getQuery(...)");
                OperatorNode.Logical canonical = GrpcQueryBinder.INSTANCE.bind(queryContext, query2);
                ctx.register(canonical);
                if (ctx.getHints().contains(QueryHint.NoOptimisation.INSTANCE)) {
                    ctx.implement();
                } else {
                    ctx.plan(DQLService.access$getPlanner$p(dQLService), false, true);
                }
                return ctx.toOperatorTree();
            }
        }));
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> explain(@NotNull CottontailGrpc.QueryMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.RequestMetadata requestMetadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getMetadata(...)");
        return this.prepareAndExecute(requestMetadata, true, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.QueryMessage $request;
            final /* synthetic */ DQLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.QueryMessage queryMessage = this.$request;
                DQLService dQLService = this.this$0;
                DefaultQueryContext $this$invoke_u24lambda_u241 = ctx;
                boolean bl = false;
                QueryContext queryContext = $this$invoke_u24lambda_u241;
                CottontailGrpc.Query query2 = queryMessage.getQuery();
                Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"getQuery(...)");
                OperatorNode.Logical canonical = GrpcQueryBinder.INSTANCE.bind(queryContext, query2);
                ctx.register(canonical);
                DefaultQueryContext $this$invoke_u24lambda_u241_u24lambda_u240 = ctx;
                boolean bl2 = false;
                Map<Integer, List<Pair<OperatorNode.Physical, Float>>> candidates = DQLService.access$getPlanner$p(dQLService).plan($this$invoke_u24lambda_u241_u24lambda_u240, (OperatorNode.Logical)CollectionsKt.first(ctx.getLogical()), 5);
                return new ExplainQueryOperator(candidates, ctx);
            }
        }));
    }

    @Nullable
    public Object ping(@NotNull Empty request, @NotNull Continuation<? super Empty> $completion) {
        Empty empty = Empty.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)empty, (String)"getDefaultInstance(...)");
        return empty;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return TransactionalGrpcService.DefaultImpls.getManager(this);
    }

    @Override
    @NotNull
    public DefaultQueryContext queryContextFromMetadata(@NotNull CottontailGrpc.RequestMetadata metadata, boolean readOnly) {
        return TransactionalGrpcService.DefaultImpls.queryContextFromMetadata(this, metadata, readOnly);
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> prepareAndExecute(@NotNull CottontailGrpc.RequestMetadata metadata, boolean readOnly, @NotNull Function1<? super DefaultQueryContext, ? extends Operator> prepare) {
        return TransactionalGrpcService.DefaultImpls.prepareAndExecute(this, metadata, readOnly, prepare);
    }

    @Override
    @NotNull
    public StatusException handleError(@NotNull DefaultQueryContext $this$handleError, @NotNull Throwable e, boolean execution) {
        return TransactionalGrpcService.DefaultImpls.handleError(this, $this$handleError, e, execution);
    }

    public static final /* synthetic */ CottontailQueryPlanner access$getPlanner$p(DQLService $this) {
        return $this.planner;
    }
}

