/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusException;
import jetbrains.exodus.ExodusException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.operators.basics.Operator;
import org.vitrivr.cottontail.dbms.execution.transactions.Transaction;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionManager;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionType;
import org.vitrivr.cottontail.dbms.queries.context.DefaultQueryContext;
import org.vitrivr.cottontail.dbms.queries.operators.physical.system.ListLocksPhysicalOperatorNode;
import org.vitrivr.cottontail.dbms.queries.operators.physical.system.ListTransactionsPhysicalOperatorNode;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.TXNGrpcKt;
import org.vitrivr.cottontail.server.grpc.services.TransactionalGrpcService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\n\u001a\u00020\u000eH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\n\u001a\u00020\u000eH\u0016J\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/TXNService;", "Lorg/vitrivr/cottontail/grpc/TXNGrpcKt$TXNCoroutineImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionalGrpcService;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "(Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "begin", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ResponseMetadata;", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$BeginTransaction;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$BeginTransaction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "commit", "Lcom/google/protobuf/Empty;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$RequestMetadata;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$RequestMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kill", "listLocks", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "listTransactions", "rollback", "cottontaildb-dbms"})
@ExperimentalTime
public final class TXNService
extends TXNGrpcKt.TXNCoroutineImplBase
implements TransactionalGrpcService {
    @NotNull
    private final Catalogue catalogue;

    public TXNService(@NotNull Catalogue catalogue) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        super(null, 1, null);
        this.catalogue = catalogue;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.catalogue;
    }

    @Nullable
    public Object begin(@NotNull CottontailGrpc.BeginTransaction request, @NotNull Continuation<? super CottontailGrpc.ResponseMetadata> $completion) {
        try {
            CottontailGrpc.TransactionMode transactionMode = request.getMode();
            Transaction txn = (transactionMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[transactionMode.ordinal()]) == 1 ? this.getManager().startTransaction(TransactionType.USER_READONLY) : this.getManager().startTransaction(TransactionType.USER_EXCLUSIVE);
            CottontailGrpc.ResponseMetadata responseMetadata = CottontailGrpc.ResponseMetadata.newBuilder().setTransactionId(txn.getTransactionId()).setTransactionMode(request.getMode()).build();
            Intrinsics.checkNotNullExpressionValue((Object)responseMetadata, (String)"build(...)");
            return responseMetadata;
        }
        catch (ExodusException e) {
            StatusException statusException = Status.RESOURCE_EXHAUSTED.withCause((Throwable)e).withDescription("Could not start transaction. Please try again later!").asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"asException(...)");
            throw (Throwable)statusException;
        }
    }

    @Nullable
    public Object commit(@NotNull CottontailGrpc.RequestMetadata request, @NotNull Continuation<? super Empty> $completion) {
        if (request.getTransactionId() <= 0L) {
            StatusException statusException = Status.INVALID_ARGUMENT.withDescription("Failed to execute COMMIT: Invalid transaction identifier " + request.getTransactionId() + "!").asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"asException(...)");
            throw (Throwable)statusException;
        }
        DefaultQueryContext ctx = this.queryContextFromMetadata(request, false);
        try {
            ctx.getTxn().commit();
            Empty empty = Empty.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)empty, (String)"getDefaultInstance(...)");
            return empty;
        }
        catch (TransactionException.InConflict e) {
            StatusException statusException = Status.ABORTED.withCause((Throwable)e).withDescription("[" + ctx.getTxn().getTransactionId() + ", " + ctx.getQueryId() + "] Failed to execute COMMIT because transaction is in conflict.").asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"asException(...)");
            throw (Throwable)statusException;
        }
        catch (Throwable e) {
            StatusException statusException = Status.INTERNAL.withDescription("[" + ctx.getTxn().getTransactionId() + ", " + ctx.getQueryId() + "] Failed to execute COMMIT due to unexpected error: " + e.getMessage()).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"asException(...)");
            throw (Throwable)statusException;
        }
    }

    @Nullable
    public Object rollback(@NotNull CottontailGrpc.RequestMetadata request, @NotNull Continuation<? super Empty> $completion) {
        if (request.getTransactionId() <= 0L) {
            StatusException statusException = Status.INVALID_ARGUMENT.withDescription("Failed to execute ROLLBACK: Invalid transaction identifier " + request.getTransactionId() + "!").asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"asException(...)");
            throw (Throwable)statusException;
        }
        DefaultQueryContext ctx = this.queryContextFromMetadata(request, false);
        try {
            ctx.getTxn().rollback();
            Empty empty = Empty.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)empty, (String)"getDefaultInstance(...)");
            return empty;
        }
        catch (Throwable e) {
            StatusException statusException = Status.INTERNAL.withDescription("Failed to execute COMMIT due to unexpected error: " + e.getMessage()).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"asException(...)");
            throw (Throwable)statusException;
        }
    }

    @Nullable
    public Object kill(@NotNull CottontailGrpc.RequestMetadata request, @NotNull Continuation<? super Empty> $completion) {
        if (request.getTransactionId() <= 0L) {
            StatusException statusException = Status.INVALID_ARGUMENT.withDescription("Failed to execute KILL: Invalid transaction identifier " + request.getTransactionId() + "!").asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"asException(...)");
            throw (Throwable)statusException;
        }
        DefaultQueryContext ctx = this.queryContextFromMetadata(request, false);
        try {
            ctx.getTxn().kill();
            Empty empty = Empty.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)empty, (String)"getDefaultInstance(...)");
            return empty;
        }
        catch (Throwable e) {
            StatusException statusException = Status.INTERNAL.withDescription("Failed to execute KILL due to unexpected error: " + e.getMessage()).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"asException(...)");
            throw (Throwable)statusException;
        }
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listTransactions(@NotNull Empty request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.RequestMetadata requestMetadata = CottontailGrpc.RequestMetadata.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getDefaultInstance(...)");
        return this.prepareAndExecute(requestMetadata, true, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(this){
            final /* synthetic */ TXNService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                ctx.register(new ListTransactionsPhysicalOperatorNode(ctx, this.this$0.getManager()));
                return ctx.toOperatorTree();
            }
        }));
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listLocks(@NotNull Empty request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.RequestMetadata requestMetadata = CottontailGrpc.RequestMetadata.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)requestMetadata, (String)"getDefaultInstance(...)");
        return this.prepareAndExecute(requestMetadata, true, (Function1<? super DefaultQueryContext, ? extends Operator>)((Function1)new Function1<DefaultQueryContext, Operator>(this){
            final /* synthetic */ TXNService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull DefaultQueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                ctx.register(new ListLocksPhysicalOperatorNode(ctx, this.this$0.getManager().getLockManager$cottontaildb_dbms()));
                return ctx.toOperatorTree();
            }
        }));
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return TransactionalGrpcService.DefaultImpls.getManager(this);
    }

    @Override
    @NotNull
    public DefaultQueryContext queryContextFromMetadata(@NotNull CottontailGrpc.RequestMetadata metadata, boolean readOnly) {
        return TransactionalGrpcService.DefaultImpls.queryContextFromMetadata(this, metadata, readOnly);
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> prepareAndExecute(@NotNull CottontailGrpc.RequestMetadata metadata, boolean readOnly, @NotNull Function1<? super DefaultQueryContext, ? extends Operator> prepare) {
        return TransactionalGrpcService.DefaultImpls.prepareAndExecute(this, metadata, readOnly, prepare);
    }

    @Override
    @NotNull
    public StatusException handleError(@NotNull DefaultQueryContext $this$handleError, @NotNull Throwable e, boolean execution) {
        return TransactionalGrpcService.DefaultImpls.handleError(this, $this$handleError, e, execution);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CottontailGrpc.TransactionMode.values().length];
            try {
                nArray[CottontailGrpc.TransactionMode.READONLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

