/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.values;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.BooleanVectorValue;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializer;
import org.xerial.snappy.Snappy;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/values/BooleanVectorValueValueSerializer;", "Lorg/vitrivr/cottontail/storage/serializers/values/ValueSerializer;", "Lorg/vitrivr/cottontail/core/values/BooleanVectorValue;", "size", "", "(I)V", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "fromEntry", "entry", "Ljetbrains/exodus/ByteIterable;", "fromEntry-J2OKTzU", "(Ljetbrains/exodus/ByteIterable;)[Z", "internalEntryToValue", "internalEntryToValue-J2OKTzU", "internalValueToEntry", "value", "internalValueToEntry-_Gn-1WM", "([Z)Ljetbrains/exodus/ByteIterable;", "toEntry", "toEntry-_Gn-1WM", "Companion", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nBooleanVectorValueValueSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanVectorValueValueSerializer.kt\norg/vitrivr/cottontail/storage/serializers/values/BooleanVectorValueValueSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class BooleanVectorValueValueSerializer
implements ValueSerializer<BooleanVectorValue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Types<BooleanVectorValue> type;

    public BooleanVectorValueValueSerializer(int size) {
        if (!(size > 0)) {
            boolean bl = false;
            String string = "Cannot initialize vector value binding with size value of " + size + ".";
            throw new IllegalArgumentException(string.toString());
        }
        this.type = (Types)new Types.BooleanVector(size);
    }

    @Override
    @NotNull
    public Types<BooleanVectorValue> getType() {
        return this.type;
    }

    private final boolean[] internalEntryToValue-J2OKTzU(ByteIterable entry) {
        long[] wordArray = Snappy.uncompressLongArray((byte[])entry.getBytesUnsafe());
        int n = this.getType().getLogicalSize();
        boolean[] blArray = new boolean[n];
        for (int j = 0; j < n; ++j) {
            int n2 = j;
            blArray[n2] = (wordArray[Companion.wordIndex(n2)] & 1L << n2) != 0L;
        }
        return BooleanVectorValue.constructor-impl((boolean[])blArray);
    }

    private final ByteIterable internalValueToEntry-_Gn-1WM(boolean[] value) {
        long[] wordArray = Companion.initWordArrayForSize(this.getType().getLogicalSize());
        boolean[] blArray = value;
        int n = blArray.length;
        for (int j = 0; j < n; ++j) {
            int i2 = j;
            boolean v = blArray[j];
            int wordIndex = Companion.wordIndex(i2);
            wordArray[wordIndex] = v ? wordArray[wordIndex] | 1L << i2 : wordArray[wordIndex] & (1L << i2 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        byte[] compressed = Snappy.compress((long[])wordArray);
        return (ByteIterable)new ArrayByteIterable(compressed, compressed.length);
    }

    @NotNull
    public boolean[] fromEntry-J2OKTzU(@NotNull ByteIterable entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return this.internalEntryToValue-J2OKTzU(entry);
    }

    @NotNull
    public ByteIterable toEntry-_Gn-1WM(@NotNull boolean[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.internalValueToEntry-_Gn-1WM(value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0004\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/values/BooleanVectorValueValueSerializer$Companion;", "", "()V", "initWordArrayForSize", "", "logicalSize", "", "wordIndex", "bitIndex", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final long[] initWordArrayForSize(int logicalSize) {
            return new long[this.wordIndex(logicalSize - 1) + 1];
        }

        protected final int wordIndex(int bitIndex) {
            return bitIndex >> 6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

