/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.utilities.selection.Selection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u000f\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\b\u0010#\u001a\u00020\u001bH\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000ej\b\u0012\u0004\u0012\u00028\u0000`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lorg/vitrivr/cottontail/utilities/selection/MinHeapSelection;", "T", "", "Lorg/vitrivr/cottontail/utilities/selection/Selection;", "k", "", "(I)V", "accessLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "added", "getAdded", "()I", "heap", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getK", "size", "getSize", "", "sorted", "getSorted", "()Z", "get", "i", "(I)Ljava/lang/Comparable;", "heapify", "", "offer", "element", "(Ljava/lang/Comparable;)V", "peek", "()Ljava/lang/Comparable;", "siftDown", "n", "sort", "toList", "", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nMinHeapSelection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinHeapSelection.kt\norg/vitrivr/cottontail/utilities/selection/MinHeapSelection\n+ 2 StampedLocksExtensions.kt\norg/vitrivr/cottontail/utilities/extensions/StampedLocksExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n12#2,7:165\n49#2,7:172\n12#2,7:179\n49#2,3:186\n55#2:190\n52#2,2:191\n1#3:189\n*S KotlinDebug\n*F\n+ 1 MinHeapSelection.kt\norg/vitrivr/cottontail/utilities/selection/MinHeapSelection\n*L\n37#1:165,7\n44#1:172,7\n66#1:179,7\n78#1:186,3\n78#1:190\n78#1:191,2\n*E\n"})
public final class MinHeapSelection<T extends Comparable<? super T>>
implements Selection<T> {
    private final int k;
    @NotNull
    private final ArrayList<T> heap;
    @NotNull
    private final StampedLock accessLock;
    private volatile boolean sorted;
    private volatile int added;

    public MinHeapSelection(int k) {
        this.k = k;
        this.heap = new ArrayList(this.getK());
        this.accessLock = new StampedLock();
        this.sorted = true;
    }

    @Override
    public int getK() {
        return this.k;
    }

    public final boolean getSorted() {
        return this.sorted;
    }

    public final int getAdded() {
        return this.added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int n;
        StampedLock $this$read$iv = this.accessLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            n = 0;
            n = this.heap.size();
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        StampedLock $this$write$iv = this.accessLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-MinHeapSelection$offer$22 = false;
            this.sorted = false;
            if (this.added < this.getK()) {
                this.heap.add(element);
                ++this.added;
                if (this.added == this.getK()) {
                    this.heapify();
                }
            } else {
                ++this.added;
                T t = this.heap.get(0);
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                if (element.compareTo(t) < 0) {
                    this.heap.set(0, element);
                    this.siftDown(0, this.getK() - 1);
                }
            }
            Unit $i$a$-write-MinHeapSelection$offer$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T peek() {
        StampedLock $this$read$iv = this.accessLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean bl = false;
            Comparable comparable = (Comparable)CollectionsKt.firstOrNull((List)this.heap);
            return (T)comparable;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T get(int i2) {
        StampedLock $this$write$iv = this.accessLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            Comparable ret;
            boolean bl = false;
            int maxIdx = this.heap.size() - 1;
            if (!(i2 <= maxIdx)) {
                boolean bl2 = false;
                String string = "Index " + i2 + " is out of bounds for this MinHeapSelect.";
                throw new IllegalArgumentException(string.toString());
            }
            if (i2 == this.getK() - 1) {
                T t = this.heap.get(0);
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                Comparable comparable = (Comparable)t;
                return (T)comparable;
            }
            if (!this.sorted) {
                this.sort();
            }
            T t = this.heap.get(maxIdx - i2);
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            Comparable comparable = ret = (Comparable)t;
            return (T)comparable;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public List<T> toList() {
        if (!this.sorted) {
            this.sort();
        }
        Object object = this.heap.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<T of org.vitrivr.cottontail.utilities.selection.MinHeapSelection>");
        return (List)object;
    }

    private final void sort() {
        int n = Math.min(this.getK(), this.added);
        int inc = 1;
        do {
            inc *= 3;
        } while (++inc <= n);
        do {
            for (int i2 = inc /= 3; i2 < n; ++i2) {
                T t = this.heap.get(i2);
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                Comparable v = (Comparable)t;
                int j = i2;
                while (((Comparable)this.heap.get(j - inc)).compareTo(v) < 0) {
                    this.heap.set(j, this.heap.get(j - inc));
                    if ((j -= inc) >= inc) continue;
                }
                this.heap.set(j, v);
            }
        } while (inc > 1);
        this.sorted = true;
    }

    private final void siftDown(int i2, int n) {
        int k = i2;
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n) {
                Comparable comparable = (Comparable)this.heap.get(j);
                T t = this.heap.get(j + 1);
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                if (comparable.compareTo(t) < 0) {
                    ++j;
                }
            }
            Comparable comparable = (Comparable)this.heap.get(k);
            T t = this.heap.get(j);
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            if (comparable.compareTo(t) >= 0) break;
            T t2 = this.heap.get(k);
            Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
            Comparable a = (Comparable)t2;
            this.heap.set(k, this.heap.get(j));
            this.heap.set(j, a);
            k = j;
        }
    }

    private final void heapify() {
        int n = this.heap.size();
        for (int i2 = n / 2 - 1; -1 < i2; --i2) {
            this.siftDown(i2, n - 1);
        }
    }
}

