/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.test;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.execution.ExecutionManager;
import org.vitrivr.cottontail.dbms.execution.services.AutoRebuilderService;
import org.vitrivr.cottontail.server.grpc.services.DDLService;
import org.vitrivr.cottontail.server.grpc.services.DMLService;
import org.vitrivr.cottontail.server.grpc.services.DQLService;
import org.vitrivr.cottontail.server.grpc.services.TXNService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/test/EmbeddedCottontailGrpcServer;", "", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue$cottontaildb_dbms_testFixtures", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "executor", "Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;", "grpc", "Lio/grpc/Server;", "kotlin.jvm.PlatformType", "<set-?>", "", "isRunning", "()Z", "shutdownAndWait", "", "cottontaildb-dbms_testFixtures"})
@ExperimentalTime
public final class EmbeddedCottontailGrpcServer {
    @NotNull
    private final ExecutionManager executor;
    @NotNull
    private final DefaultCatalogue catalogue;
    private final Server grpc;
    private volatile boolean isRunning;

    /*
     * WARNING - void declaration
     */
    public EmbeddedCottontailGrpcServer(@NotNull Config config) {
        ServerBuilder serverBuilder;
        void it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.executor = new ExecutionManager(config);
        this.catalogue = new DefaultCatalogue(config, this.executor);
        ServerBuilder serverBuilder2 = ServerBuilder.forPort((int)config.getServer().getPort()).executor((Executor)this.executor.getConnectionWorkerPool()).addService((BindableService)new DDLService(this.catalogue, new AutoRebuilderService((Catalogue)this.catalogue))).addService((BindableService)new DMLService((Catalogue)this.catalogue)).addService((BindableService)new DQLService((Catalogue)this.catalogue)).addService((BindableService)new TXNService((Catalogue)this.catalogue));
        EmbeddedCottontailGrpcServer embeddedCottontailGrpcServer = this;
        boolean bl = false;
        if (config.getServer().getUseTls()) {
            Path path = config.getServer().getCertFile();
            Intrinsics.checkNotNull((Object)path);
            File certFile = path.toFile();
            Path path2 = config.getServer().getPrivateKey();
            Intrinsics.checkNotNull((Object)path2);
            File privateKeyFile = path2.toFile();
            serverBuilder = it.useTransportSecurity(certFile, privateKeyFile);
        } else {
            serverBuilder = it;
        }
        embeddedCottontailGrpcServer.grpc = serverBuilder.build();
        try {
            this.grpc.start();
        }
        catch (Throwable e) {
            this.executor.shutdownAndWait();
            this.catalogue.close();
            throw e;
        }
        this.isRunning = true;
    }

    @NotNull
    public final DefaultCatalogue getCatalogue$cottontaildb_dbms_testFixtures() {
        return this.catalogue;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final void shutdownAndWait() {
        if (this.isRunning) {
            this.grpc.shutdown().awaitTermination();
            this.catalogue.close();
            this.executor.shutdownAndWait();
            this.isRunning = false;
        }
    }
}

