/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Scanner;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.LongVector;
import jdk.incubator.vector.ShortVector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.legacy.VersionProber;
import org.vitrivr.cottontail.server.CottontailServer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u001b\u0010\u0007\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0002\u00a2\u0006\u0002\u0010\n\u001a\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u001b\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0007\u00a2\u0006\u0002\u0010\u000f\u001a \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u001a\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"COTTONTAIL_CONFIG_FILE_ENV_KEY", "", "COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY", "embedded", "Lorg/vitrivr/cottontail/server/CottontailServer;", "config", "Lorg/vitrivr/cottontail/config/Config;", "findConfigPathOrdered", "args", "", "([Ljava/lang/String;)Ljava/lang/String;", "loadConfig", "path", "main", "", "([Ljava/lang/String;)V", "migrate", "", "from", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "to", "standalone", "cottontaildb-dbms"})
@SourceDebugExtension(value={"SMAP\nCottontail.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cottontail.kt\norg/vitrivr/cottontail/CottontailKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class CottontailKt {
    @NotNull
    public static final String COTTONTAIL_CONFIG_FILE_ENV_KEY = "COTTONTAIL_CONFIG";
    @NotNull
    public static final String COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY = "org.vitrivr.cottontail.config";

    @ExperimentalTime
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            Config config = CottontailKt.loadConfig(CottontailKt.findConfigPathOrdered(args));
            if (config.getExecution().getSimd()) {
                try {
                    System.out.println((Object)"Cottontail DB is running with SIMD extensions through the Java Vector API. This feature is experimental!");
                    System.out.println((Object)("(Byte) Preferred: " + ByteVector.SPECIES_MAX + ". Maximum: " + ByteVector.SPECIES_MAX));
                    System.out.println((Object)("(Short) Preferred: " + ShortVector.SPECIES_MAX + ". Maximum: " + ShortVector.SPECIES_MAX));
                    System.out.println((Object)("(Int) Preferred: " + IntVector.SPECIES_MAX + ". Maximum: " + IntVector.SPECIES_MAX));
                    System.out.println((Object)("(Long) Preferred: " + LongVector.SPECIES_MAX + ". Maximum: " + LongVector.SPECIES_MAX));
                    System.out.println((Object)("(Float) Preferred: " + FloatVector.SPECIES_MAX + ". Maximum: " + FloatVector.SPECIES_MAX + "t"));
                    System.out.println((Object)("(Double) Preferred: " + DoubleVector.SPECIES_MAX + ". Maximum: " + DoubleVector.SPECIES_MAX));
                }
                catch (NoClassDefFoundError e) {
                    System.err.println("Failed to start Cottontail DB due to error: No support for Java Vector API. Please unset 'execution.simd' flag in config.");
                    System.exit(1);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
            }
            CottontailKt.standalone(config);
        }
        catch (Throwable e) {
            System.err.println("Failed to start Cottontail DB due to error:");
            e.printStackTrace();
            System.err.println(Unit.INSTANCE);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        Dispatchers.getDefault();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String findConfigPathOrdered(String[] args) {
        String string;
        if (!(args.length == 0) && !StringsKt.isBlank((CharSequence)args[0])) {
            string = args[0];
            return string;
        }
        if (System.getProperties().containsKey(COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY)) {
            String string2 = System.getProperty(COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY, "");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            if (!StringsKt.isBlank((CharSequence)string2)) {
                String string3 = System.getProperty(COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY);
                Intrinsics.checkNotNull((Object)string3);
                string = string3;
                return string;
            }
        }
        if (System.getenv().containsKey(COTTONTAIL_CONFIG_FILE_ENV_KEY)) {
            String string4 = System.getenv(COTTONTAIL_CONFIG_FILE_ENV_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getenv(...)");
            if (!StringsKt.isBlank((CharSequence)string4)) {
                String string5 = System.getenv(COTTONTAIL_CONFIG_FILE_ENV_KEY);
                Intrinsics.checkNotNull((Object)string5);
                string = string5;
                return string;
            }
        }
        System.err.println("No CottontailDB Config file specified. Defaulting to ./config.json");
        return "./config.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Config loadConfig(String path) {
        Path configPath = Paths.get(path, new String[0]);
        try {
            Config config;
            if (!Files.isRegularFile(configPath, new LinkOption[0])) {
                System.err.println("No CottontailDB config exists under " + configPath + "; trying to create default config!");
                Config config2 = new Config(null, null, null, null, null, null, null, null, null, 511, null);
                Closeable closeable = Files.newBufferedWriter(configPath, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    BufferedWriter it = (BufferedWriter)closeable;
                    boolean bl = false;
                    it.write(Json.Default.encodeToString((SerializationStrategy)Config.Companion.serializer(), (Object)config2));
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return config2;
            }
            Closeable config2 = Files.newBufferedReader(configPath);
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)config2;
                boolean bl = false;
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)Config.Companion.serializer();
                Intrinsics.checkNotNull((Object)it);
                config = (Config)Json.Default.decodeFromString(deserializationStrategy, TextStreamsKt.readText((Reader)it));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)config2, (Throwable)throwable);
            }
            return config;
        }
        catch (Throwable e) {
            System.err.println("Could not load Cottontail DB configuration file under " + configPath + ". Cottontail DB will shutdown!");
            e.printStackTrace();
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * Exception decompiling
     */
    @ExperimentalTime
    public static final void standalone(@NotNull Config config) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE], 1[SWITCH]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @ExperimentalTime
    @NotNull
    public static final CottontailServer embedded(@NotNull Config config) {
        DBOVersion detected;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!Files.exists(config.getRoot(), new LinkOption[0])) {
            Files.createDirectories(config.getRoot(), new FileAttribute[0]);
        }
        if ((detected = new VersionProber(config).probe()) != VersionProber.Companion.getEXPECTED() && detected != DBOVersion.UNDEFINED) {
            throw new DatabaseException.VersionMismatchException(VersionProber.Companion.getEXPECTED(), detected);
        }
        return new CottontailServer(config);
    }

    @ExperimentalTime
    public static final boolean migrate(@NotNull Config config, @NotNull DBOVersion from, @NotNull DBOVersion to) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)from), (String)"from");
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        Scanner scanner = new Scanner(System.in);
        System.out.println((Object)("Cottontail DB detected a version mismatch (expected: " + to + ", found: " + from + "). Would you like to perform a upgrade (y/n)?"));
        while (true) {
            String string;
            String string2 = scanner.nextLine();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextLine(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            int n = -1;
            switch (string.hashCode()) {
                case 3521: {
                    if (string.equals("no")) {
                        n = 1;
                    }
                    break;
                }
                case 119527: {
                    if (string.equals("yes")) {
                        n = 2;
                    }
                    break;
                }
                case 121: {
                    if (string.equals("y")) {
                        n = 2;
                    }
                    break;
                }
                case 110: {
                    if (string.equals("n")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    new VersionProber(config).migrate();
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            Thread.sleep(100L);
        }
    }
}

