/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.catalogue.entries;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/entries/MetadataEntry;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "cottontaildb-dbms"})
public final class MetadataEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String key;
    @NotNull
    private final String value;
    @NotNull
    private static final String CATALOGUE_METADATA_STORE_NAME = "ctt_cat_metadata";
    @NotNull
    public static final String METADATA_ENTRY_DB_VERSION = "db_version";

    public MetadataEntry(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.key = key;
        this.value = value;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final String component1() {
        return this.key;
    }

    @NotNull
    public final String component2() {
        return this.value;
    }

    @NotNull
    public final MetadataEntry copy(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new MetadataEntry(key, value);
    }

    public static /* synthetic */ MetadataEntry copy$default(MetadataEntry metadataEntry, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = metadataEntry.key;
        }
        if ((n & 2) != 0) {
            string2 = metadataEntry.value;
        }
        return metadataEntry.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "MetadataEntry(key=" + this.key + ", value=" + this.value + ")";
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetadataEntry)) {
            return false;
        }
        MetadataEntry metadataEntry = (MetadataEntry)other;
        if (!Intrinsics.areEqual((Object)this.key, (Object)metadataEntry.key)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)metadataEntry.value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0010J'\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0016J%\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/entries/MetadataEntry$Companion;", "", "()V", "CATALOGUE_METADATA_STORE_NAME", "", "METADATA_ENTRY_DB_VERSION", "delete", "", "key", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "transaction", "Ljetbrains/exodus/env/Transaction;", "delete$cottontaildb_dbms", "init", "", "init$cottontaildb_dbms", "read", "Lorg/vitrivr/cottontail/dbms/catalogue/entries/MetadataEntry;", "read$cottontaildb_dbms", "store", "Ljetbrains/exodus/env/Store;", "store$cottontaildb_dbms", "write", "entry", "write$cottontaildb_dbms", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public final void init$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(MetadataEntry.CATALOGUE_METADATA_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to create catalogue metadata store.");
            }
        }

        @NotNull
        public final Store store$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(MetadataEntry.CATALOGUE_METADATA_STORE_NAME, StoreConfig.USE_EXISTING, transaction, false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open catalogue metadata store.");
            }
            return store;
        }

        @Nullable
        public final MetadataEntry read$cottontaildb_dbms(@NotNull String key, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            MetadataEntry metadataEntry;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            ByteIterable rawEntry = this.store$cottontaildb_dbms(catalogue, transaction).get(transaction, (ByteIterable)StringBinding.stringToEntry((String)key));
            if (rawEntry != null) {
                String string = StringBinding.entryToString((ByteIterable)rawEntry);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entryToString(...)");
                metadataEntry = new MetadataEntry(key, string);
            } else {
                metadataEntry = null;
            }
            return metadataEntry;
        }

        public final boolean write$cottontaildb_dbms(@NotNull MetadataEntry entry, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            return this.store$cottontaildb_dbms(catalogue, transaction).put(transaction, (ByteIterable)StringBinding.stringToEntry((String)entry.getKey()), (ByteIterable)StringBinding.stringToEntry((String)entry.getValue()));
        }

        public final boolean delete$cottontaildb_dbms(@NotNull String key, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            return this.store$cottontaildb_dbms(catalogue, transaction).delete(transaction, (ByteIterable)StringBinding.stringToEntry((String)key));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

