/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.column;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.storage.serializers.tablets.Compression;
import org.vitrivr.cottontail.utilities.math.BitUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB1\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/column/ColumnMetadata;", "", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "compression", "Lorg/vitrivr/cottontail/storage/serializers/tablets/Compression;", "nullable", "", "primary", "autoIncrement", "(Lorg/vitrivr/cottontail/core/types/Types;Lorg/vitrivr/cottontail/storage/serializers/tablets/Compression;ZZZ)V", "getAutoIncrement", "()Z", "getCompression", "()Lorg/vitrivr/cottontail/storage/serializers/tablets/Compression;", "getNullable", "getPrimary", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "cottontaildb-dbms"})
public final class ColumnMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Types<?> type;
    @NotNull
    private final Compression compression;
    private final boolean nullable;
    private final boolean primary;
    private final boolean autoIncrement;
    @NotNull
    private static final String CATALOGUE_COLUMN_STORE_NAME = "org.vitrivr.cottontail.columns";

    public ColumnMetadata(@NotNull Types<?> type, @NotNull Compression compression, boolean nullable, boolean primary, boolean autoIncrement) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        this.type = type;
        this.compression = compression;
        this.nullable = nullable;
        this.primary = primary;
        this.autoIncrement = autoIncrement;
    }

    @NotNull
    public final Types<?> getType() {
        return this.type;
    }

    @NotNull
    public final Compression getCompression() {
        return this.compression;
    }

    public final boolean getNullable() {
        return this.nullable;
    }

    public final boolean getPrimary() {
        return this.primary;
    }

    public final boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    @NotNull
    public final Types<?> component1() {
        return this.type;
    }

    @NotNull
    public final Compression component2() {
        return this.compression;
    }

    public final boolean component3() {
        return this.nullable;
    }

    public final boolean component4() {
        return this.primary;
    }

    public final boolean component5() {
        return this.autoIncrement;
    }

    @NotNull
    public final ColumnMetadata copy(@NotNull Types<?> type, @NotNull Compression compression, boolean nullable, boolean primary, boolean autoIncrement) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        return new ColumnMetadata(type, compression, nullable, primary, autoIncrement);
    }

    public static /* synthetic */ ColumnMetadata copy$default(ColumnMetadata columnMetadata, Types types, Compression compression, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            types = columnMetadata.type;
        }
        if ((n & 2) != 0) {
            compression = columnMetadata.compression;
        }
        if ((n & 4) != 0) {
            bl = columnMetadata.nullable;
        }
        if ((n & 8) != 0) {
            bl2 = columnMetadata.primary;
        }
        if ((n & 0x10) != 0) {
            bl3 = columnMetadata.autoIncrement;
        }
        return columnMetadata.copy(types, compression, bl, bl2, bl3);
    }

    @NotNull
    public String toString() {
        return "ColumnMetadata(type=" + this.type + ", compression=" + this.compression + ", nullable=" + this.nullable + ", primary=" + this.primary + ", autoIncrement=" + this.autoIncrement + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.compression.hashCode();
        result = result * 31 + Boolean.hashCode(this.nullable);
        result = result * 31 + Boolean.hashCode(this.primary);
        result = result * 31 + Boolean.hashCode(this.autoIncrement);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColumnMetadata)) {
            return false;
        }
        ColumnMetadata columnMetadata = (ColumnMetadata)other;
        if (!Intrinsics.areEqual(this.type, columnMetadata.type)) {
            return false;
        }
        if (this.compression != columnMetadata.compression) {
            return false;
        }
        if (this.nullable != columnMetadata.nullable) {
            return false;
        }
        if (this.primary != columnMetadata.primary) {
            return false;
        }
        return this.autoIncrement == columnMetadata.autoIncrement;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/dbms/column/ColumnMetadata$Companion;", "", "()V", "CATALOGUE_COLUMN_STORE_NAME", "", "fromEntry", "Lorg/vitrivr/cottontail/dbms/column/ColumnMetadata;", "entry", "Ljetbrains/exodus/ByteIterable;", "init", "", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "transaction", "Ljetbrains/exodus/env/Transaction;", "init$cottontaildb_dbms", "store", "Ljetbrains/exodus/env/Store;", "store$cottontaildb_dbms", "toEntry", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public final void init$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ColumnMetadata.CATALOGUE_COLUMN_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to create column catalogue store.");
            }
        }

        @NotNull
        public final Store store$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Store store = catalogue.getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ColumnMetadata.CATALOGUE_COLUMN_STORE_NAME, StoreConfig.USE_EXISTING, transaction, false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open store for column catalogue.");
            }
            return store;
        }

        @NotNull
        public final ColumnMetadata fromEntry(@NotNull ByteIterable entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            ByteArrayInputStream iterator2 = new ByteArrayInputStream(entry.getBytesUnsafe());
            Types type = Types.Companion.forOrdinal(IntegerBinding.readCompressed((ByteArrayInputStream)iterator2), IntegerBinding.readCompressed((ByteArrayInputStream)iterator2));
            Compression compression = Compression.values()[IntegerBinding.readCompressed((ByteArrayInputStream)iterator2)];
            Integer bitmap = IntegerBinding.BINDING.readObject(iterator2);
            Intrinsics.checkNotNull((Object)bitmap);
            return new ColumnMetadata(type, compression, BitUtil.INSTANCE.isBitSet(bitmap.intValue(), 0), BitUtil.INSTANCE.isBitSet(bitmap.intValue(), 1), BitUtil.INSTANCE.isBitSet(bitmap.intValue(), 2));
        }

        @NotNull
        public final ByteIterable toEntry(@NotNull ColumnMetadata entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            LightOutputStream output = new LightOutputStream();
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)entry.getType().getOrdinal());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)entry.getType().getLogicalSize());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)entry.getCompression().ordinal());
            int bitmap = 0;
            if (entry.getNullable()) {
                bitmap = BitUtil.INSTANCE.setBit(bitmap, 0);
            }
            if (entry.getPrimary()) {
                bitmap = BitUtil.INSTANCE.setBit(bitmap, 1);
            }
            if (entry.getAutoIncrement()) {
                bitmap = BitUtil.INSTANCE.setBit(bitmap, 2);
            }
            IntegerBinding.BINDING.writeObject(output, (Comparable)Integer.valueOf(bitmap));
            ArrayByteIterable arrayByteIterable = output.asArrayByteIterable();
            Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"asArrayByteIterable(...)");
            return (ByteIterable)arrayByteIterable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

