/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.column;

import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.tablets.Tablet;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.column.EmptyColumnCursor;
import org.vitrivr.cottontail.dbms.column.FixedLengthCursor;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.general.Tx;
import org.vitrivr.cottontail.dbms.queries.context.QueryContext;
import org.vitrivr.cottontail.dbms.statistics.StatisticsUtilitiesKt;
import org.vitrivr.cottontail.dbms.statistics.storage.ColumnStatistic;
import org.vitrivr.cottontail.dbms.statistics.values.ValueStatistics;
import org.vitrivr.cottontail.storage.serializers.SerializerFactory;
import org.vitrivr.cottontail.storage.serializers.tablets.Compression;
import org.vitrivr.cottontail.storage.serializers.tablets.TabletSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002\u001d\u001eB#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/vitrivr/cottontail/dbms/column/FixedLengthColumn;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/dbms/column/Column;", "columnDef", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "compression", "Lorg/vitrivr/cottontail/storage/serializers/tablets/Compression;", "(Lorg/vitrivr/cottontail/core/database/ColumnDef;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;Lorg/vitrivr/cottontail/storage/serializers/tablets/Compression;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getColumnDef", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getCompression", "()Lorg/vitrivr/cottontail/storage/serializers/tablets/Compression;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "newTx", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class FixedLengthColumn<T extends Value>
implements Column<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnDef<T> columnDef;
    @NotNull
    private final DefaultEntity parent;
    @NotNull
    private final Compression compression;
    public static final int TABLET_SIZE = 128;
    public static final int TABLET_SHR = 7;

    public FixedLengthColumn(@NotNull ColumnDef<T> columnDef2, @NotNull DefaultEntity parent, @NotNull Compression compression) {
        Intrinsics.checkNotNullParameter(columnDef2, (String)"columnDef");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        this.columnDef = columnDef2;
        this.parent = parent;
        this.compression = compression;
        if (!(!(this.getType() instanceof Types.String) && !(this.getColumnDef().getType() instanceof Types.ByteString))) {
            boolean bl = false;
            String string = "FixedLengthColumn can only be used for fixed-length types.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    @Override
    @NotNull
    public DefaultEntity getParent() {
        return this.parent;
    }

    @NotNull
    public final Compression getCompression() {
        return this.compression;
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.getColumnDef().getName();
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public ColumnTx<T> newTx(@NotNull QueryContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ColumnTx columnTx = (ColumnTx)context2.getTxn().getCachedTxForDBO(this);
        if (columnTx == null) {
            columnTx = new Tx(context2);
        }
        return columnTx;
    }

    @Override
    @NotNull
    public Types<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return Column.DefaultImpls.getVersion(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/dbms/column/FixedLengthColumn$Companion;", "", "()V", "TABLET_SHR", "", "TABLET_SIZE", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0019H\u0016J\u001b\u0010\u001a\u001a\u0004\u0018\u00018\u00002\n\u0010\u001b\u001a\u00060\u0014j\u0002`\u0015H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0017H\u0002J\u0014\u0010\u001e\u001a\u00020\u00172\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u001b\u0010\u001f\u001a\u0004\u0018\u00018\u00002\n\u0010\u001b\u001a\u00060\u0014j\u0002`\u0015H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J#\u0010\"\u001a\u0004\u0018\u00018\u00002\n\u0010\u001b\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/vitrivr/cottontail/dbms/column/FixedLengthColumn$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "Lorg/vitrivr/cottontail/dbms/general/Tx$WithCommitFinalization;", "context", "Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;", "(Lorg/vitrivr/cottontail/dbms/column/FixedLengthColumn;Lorg/vitrivr/cottontail/dbms/queries/context/QueryContext;)V", "dataStore", "Ljetbrains/exodus/env/Store;", "dbo", "Lorg/vitrivr/cottontail/dbms/column/FixedLengthColumn;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/column/FixedLengthColumn;", "dirty", "", "serializer", "Lorg/vitrivr/cottontail/storage/serializers/tablets/TabletSerializer;", "tablet", "Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "tabletId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "beforeCommit", "", "cursor", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "delete", "tupleId", "(J)Lorg/vitrivr/cottontail/core/types/Value;", "flushTablet", "loadTabletF", "read", "statistics", "Lorg/vitrivr/cottontail/dbms/statistics/values/ValueStatistics;", "write", "value", "(JLorg/vitrivr/cottontail/core/types/Value;)Lorg/vitrivr/cottontail/core/types/Value;", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements ColumnTx<T>,
    Tx.WithCommitFinalization {
        @NotNull
        private final Store dataStore;
        @NotNull
        private final TabletSerializer<T> serializer;
        private long tabletId;
        @Nullable
        private Tablet<T> tablet;
        private boolean dirty;

        public Tx(QueryContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            context2.getTxn().cacheTx(this);
            Store store = FixedLengthColumn.this.getCatalogue().getTransactionManager().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(FixedLengthColumn.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getTxn().getXodusTx(), false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Data store for column " + FixedLengthColumn.this.getName() + " is missing.");
            }
            this.dataStore = store;
            this.serializer = SerializerFactory.INSTANCE.tablet(FixedLengthColumn.this.getColumnDef().getType(), 128, FixedLengthColumn.this.getCompression());
            this.tabletId = -1L;
        }

        @Override
        @NotNull
        public FixedLengthColumn<T> getDbo() {
            return FixedLengthColumn.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ValueStatistics<T> statistics() {
            Lock lock2 = this.getTxLatch();
            FixedLengthColumn fixedLengthColumn = FixedLengthColumn.this;
            lock2.lock();
            try {
                ValueStatistics<?> statistics2;
                boolean bl = false;
                ColumnStatistic columnStatistic = fixedLengthColumn.getCatalogue().getStatisticsManager().get(fixedLengthColumn.getName());
                ValueStatistics<?> valueStatistics = columnStatistic != null ? columnStatistic.getStatistics() : null;
                ValueStatistics<?> valueStatistics2 = statistics2 = valueStatistics instanceof ValueStatistics ? valueStatistics : null;
                if (valueStatistics2 != null) {
                    ValueStatistics<?> valueStatistics3 = valueStatistics2;
                    return valueStatistics3;
                }
                ValueStatistics valueStatistics4 = StatisticsUtilitiesKt.defaultStatistics(this.getColumnDef().getType());
                return valueStatistics4;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T read(long tupleId) {
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                long tabletId = tupleId >>> 7;
                int tabletIdx = (int)(tupleId % (long)128);
                this.loadTabletF(tabletId);
                Tablet tablet = this.tablet;
                Intrinsics.checkNotNull(tablet);
                Value value = tablet.get(tabletIdx);
                return value;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T write(long tupleId, @NotNull T value) {
            Value value2;
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                long tabletId = tupleId >>> 7;
                int tabletIdx = (int)(tupleId % (long)128);
                this.loadTabletF(tabletId);
                Tablet tablet = this.tablet;
                Intrinsics.checkNotNull(tablet);
                Value old = tablet.get(tabletIdx);
                Tablet tablet2 = this.tablet;
                Intrinsics.checkNotNull(tablet2);
                tablet2.set(tabletIdx, value);
                this.dirty = true;
                value2 = old;
            }
            finally {
                lock2.unlock();
            }
            return value2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T delete(long tupleId) {
            Value value;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                long tabletId = tupleId >>> 7;
                int tabletIdx = (int)(tupleId % (long)128);
                this.loadTabletF(tabletId);
                Tablet tablet = this.tablet;
                Intrinsics.checkNotNull(tablet);
                Value old = tablet.get(tabletIdx);
                Tablet tablet2 = this.tablet;
                Intrinsics.checkNotNull(tablet2);
                tablet2.set(tabletIdx, null);
                this.dirty = true;
                value = old;
            }
            finally {
                lock2.unlock();
            }
            return value;
        }

        @Override
        @NotNull
        public Cursor<T> cursor() {
            long count = this.dataStore.count(this.getContext().getTxn().getXodusTx());
            if (count == 0L) {
                EmptyColumnCursor emptyColumnCursor = EmptyColumnCursor.INSTANCE;
                Intrinsics.checkNotNull((Object)emptyColumnCursor, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.basics.Cursor<T of org.vitrivr.cottontail.dbms.column.FixedLengthColumn?>");
                return emptyColumnCursor;
            }
            return new FixedLengthCursor(this);
        }

        @Override
        public void beforeCommit() {
            this.flushTablet();
        }

        private final void loadTabletF(long tabletId) {
            if (this.tabletId == tabletId) {
                return;
            }
            this.flushTablet();
            this.tabletId = tabletId;
            ByteIterable rawTablet = this.dataStore.get(this.getContext().getTxn().getXodusTx(), (ByteIterable)LongBinding.longToCompressedEntry((long)tabletId));
            this.tablet = rawTablet != null ? this.serializer.fromEntry(rawTablet) : Tablet.Companion.of$default((Tablet.Companion)Tablet.Companion, (int)128, FixedLengthColumn.this.getType(), (boolean)false, (int)4, null);
        }

        private final void flushTablet() {
            if (this.dirty && this.tablet != null) {
                Transaction transaction = this.getContext().getTxn().getXodusTx();
                ByteIterable byteIterable = (ByteIterable)LongBinding.longToCompressedEntry((long)this.tabletId);
                Tablet tablet = this.tablet;
                Intrinsics.checkNotNull(tablet);
                this.dataStore.put(transaction, byteIterable, this.serializer.toEntry(tablet));
                this.dirty = false;
            }
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnTx.DefaultImpls.getColumnDef(this);
        }
    }
}

