/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.column;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.tablets.Tablet;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.column.FixedLengthColumn;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.storage.serializers.SerializerFactory;
import org.vitrivr.cottontail.storage.serializers.tablets.TabletSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003B\u0017\u0012\u0010\u0010\u0004\u001a\f0\u0005R\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\u00060\u0012j\u0002`\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0014\u0010 \u001a\u00020\u001e2\n\u0010\u0016\u001a\u00060\u0012j\u0002`\u0017H\u0016J\u000f\u0010!\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\"R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0012j\u0002`\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \n*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/vitrivr/cottontail/dbms/column/FixedLengthCursor;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "column", "Lorg/vitrivr/cottontail/dbms/column/FixedLengthColumn$Tx;", "Lorg/vitrivr/cottontail/dbms/column/FixedLengthColumn;", "(Lorg/vitrivr/cottontail/dbms/column/FixedLengthColumn$Tx;)V", "cursor", "Ljetbrains/exodus/env/Cursor;", "kotlin.jvm.PlatformType", "serializer", "Lorg/vitrivr/cottontail/storage/serializers/tablets/TabletSerializer;", "store", "Ljetbrains/exodus/env/Store;", "tablet", "Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "tabletId", "", "Lorg/vitrivr/cottontail/core/database/TabletId;", "tabletIndex", "", "tupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "xodusTx", "Ljetbrains/exodus/env/Transaction;", "close", "", "key", "moveNext", "", "movePrevious", "moveTo", "value", "()Lorg/vitrivr/cottontail/core/types/Value;", "cottontaildb-dbms"})
public final class FixedLengthCursor<T extends Value>
implements org.vitrivr.cottontail.core.basics.Cursor<T> {
    private final Transaction xodusTx;
    @NotNull
    private final Store store;
    @NotNull
    private final TabletSerializer<T> serializer;
    private final Cursor cursor;
    private long tupleId;
    private long tabletId;
    private int tabletIndex;
    @Nullable
    private Tablet<T> tablet;

    public FixedLengthCursor(@NotNull FixedLengthColumn.Tx column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        this.xodusTx = column.getContext().getTxn().getXodusTx().getReadonlySnapshot();
        Store store = this.xodusTx.getEnvironment().openStore(ExtensionsKt.storeName(((FixedLengthColumn)column.getDbo()).getName()), StoreConfig.USE_EXISTING, this.xodusTx, false);
        if (store == null) {
            throw new DatabaseException.DataCorruptionException("Data store for column " + ((FixedLengthColumn)column.getDbo()).getName() + " is missing.");
        }
        this.store = store;
        this.serializer = SerializerFactory.INSTANCE.tablet(column.getColumnDef().getType(), 128, ((FixedLengthColumn)column.getDbo()).getCompression());
        this.cursor = this.store.openCursor(this.xodusTx);
        this.tupleId = -1L;
        this.tabletId = -1L;
        this.tabletIndex = -1;
    }

    public boolean moveNext() {
        return this.moveTo(this.tupleId + 1L);
    }

    public boolean movePrevious() {
        return this.moveTo(this.tupleId - 1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean moveTo(long tupleId) {
        if (tupleId < 0L) {
            return false;
        }
        if (this.tupleId == tupleId) {
            return true;
        }
        long tabletId = tupleId >>> 7;
        long l = tabletId;
        if (l != this.tabletId) {
            if (l == this.tabletId + 1L) {
                if (!this.cursor.getNext()) return false;
                ByteIterable byteIterable = this.cursor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
                this.tablet = this.serializer.fromEntry(byteIterable);
            } else if (l == this.tabletId - 1L) {
                if (!this.cursor.getPrev()) return false;
                ByteIterable byteIterable = this.cursor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"getValue(...)");
                this.tablet = this.serializer.fromEntry(byteIterable);
            } else {
                ByteIterable tablet = this.cursor.getSearchKey((ByteIterable)LongBinding.longToCompressedEntry((long)tabletId));
                if (tablet == null) return false;
                this.tablet = this.serializer.fromEntry(tablet);
            }
        }
        this.tabletId = tabletId;
        this.tupleId = tupleId;
        this.tabletIndex = (int)(tupleId % (long)128);
        return true;
    }

    public long key() {
        return this.tupleId;
    }

    @Nullable
    public T value() {
        Tablet<T> tablet = this.tablet;
        Intrinsics.checkNotNull(tablet);
        return (T)tablet.get(this.tabletIndex);
    }

    public void close() {
        this.cursor.close();
        this.xodusTx.abort();
    }

    public boolean hasNext() {
        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
    }

    @Nullable
    public T next() {
        return (T)((Value)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this));
    }

    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

